/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.inheritance;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbstractMethodWithMissingImplementationsInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("abstract.method.with.missing.implementations.display.name", new Object[0]);
        if (string == null) {
            AbstractMethodWithMissingImplementationsInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("abstract.method.with.missing.implementations.problem.descriptor", new Object[0]);
        if (string == null) {
            AbstractMethodWithMissingImplementationsInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AbstractMethodWithMissingImplementationsVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/inheritance/AbstractMethodWithMissingImplementationsInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class InheritorFinder
    implements Runnable {
        private final PsiClass aClass;
        private Collection<PsiClass> inheritors = null;

        InheritorFinder(PsiClass aClass) {
            this.aClass = aClass;
        }

        @Override
        public void run() {
            SearchScope searchScope = this.aClass.getUseScope();
            this.inheritors = ClassInheritorsSearch.search(this.aClass, searchScope, true).findAll();
        }

        public Collection<PsiClass> getInheritors() {
            ProgressManager progressManager = ProgressManager.getInstance();
            progressManager.runProcess(this, null);
            return this.inheritors;
        }
    }

    private static class AbstractMethodWithMissingImplementationsVisitor
    extends BaseInspectionVisitor {
        private AbstractMethodWithMissingImplementationsVisitor() {
        }

        @Override
        public void visitMethod(PsiMethod method) {
            super.visitMethod(method);
            if (method.getNameIdentifier() == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return;
            }
            if (!containingClass.isInterface() || !method.hasModifierProperty("abstract")) {
                return;
            }
            InheritorFinder inheritorFinder = new InheritorFinder(containingClass);
            for (PsiClass inheritor : inheritorFinder.getInheritors()) {
                if (AbstractMethodWithMissingImplementationsVisitor.hasMatchingImplementation(inheritor, method)) continue;
                if (inheritor.isEnum()) {
                    List<PsiEnumConstant> enumConstants = PsiTreeUtil.getChildrenOfTypeAsList(inheritor, PsiEnumConstant.class);
                    for (PsiEnumConstant enumConstant : enumConstants) {
                        PsiEnumConstantInitializer initializingClass = enumConstant.getInitializingClass();
                        if (initializingClass != null && AbstractMethodWithMissingImplementationsVisitor.hasMatchingImplementation(initializingClass, method)) continue;
                        this.registerMethodError(method, new Object[0]);
                        return;
                    }
                    continue;
                }
                this.registerMethodError(method, new Object[0]);
                return;
            }
        }

        private static boolean hasMatchingImplementation(@NotNull PsiClass aClass, @NotNull PsiMethod method) {
            if (aClass == null) {
                AbstractMethodWithMissingImplementationsVisitor.$$$reportNull$$$0(0);
            }
            if (method == null) {
                AbstractMethodWithMissingImplementationsVisitor.$$$reportNull$$$0(1);
            }
            if (aClass.isInterface() || aClass.hasModifierProperty("abstract")) {
                return true;
            }
            PsiMethod overridingMethod = AbstractMethodWithMissingImplementationsVisitor.findOverridingMethod(aClass, method);
            if (overridingMethod == null || overridingMethod.hasModifierProperty("static")) {
                return false;
            }
            if (!method.hasModifierProperty("packageLocal")) {
                return true;
            }
            PsiClass superClass = method.getContainingClass();
            PsiManager manager = overridingMethod.getManager();
            JavaPsiFacade facade = JavaPsiFacade.getInstance(manager.getProject());
            return facade.arePackagesTheSame(superClass, aClass);
        }

        @Nullable
        private static PsiMethod findOverridingMethod(PsiClass aClass, @NotNull PsiMethod method) {
            PsiClass superClass;
            if (method == null) {
                AbstractMethodWithMissingImplementationsVisitor.$$$reportNull$$$0(2);
            }
            if (aClass.equals(superClass = method.getContainingClass())) {
                return null;
            }
            PsiSubstitutor substitutor = TypeConversionUtil.getSuperClassSubstitutor(superClass, aClass, PsiSubstitutor.EMPTY);
            MethodSignature signature = method.getSignature(substitutor);
            List<Pair<PsiMethod, PsiSubstitutor>> pairs = aClass.findMethodsAndTheirSubstitutorsByName(signature.getName(), true);
            for (Pair<PsiMethod, PsiSubstitutor> pair : pairs) {
                PsiSubstitutor overridingSubstitutor;
                MethodSignature foundMethodSignature;
                PsiClass containingClass;
                PsiMethod overridingMethod = (PsiMethod)pair.first;
                if (overridingMethod.hasModifierProperty("abstract") || (containingClass = overridingMethod.getContainingClass()) != null && containingClass.isInterface() && !overridingMethod.hasModifierProperty("default") || !MethodSignatureUtil.isSubsignature(signature, foundMethodSignature = overridingMethod.getSignature(overridingSubstitutor = (PsiSubstitutor)pair.second)) || overridingMethod == method) continue;
                return overridingMethod;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/inheritance/AbstractMethodWithMissingImplementationsInspection$AbstractMethodWithMissingImplementationsVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "hasMatchingImplementation";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findOverridingMethod";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

