/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.GenericsUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.function.Predicate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public class StreamApiUtil {
    @Contract(value="null -> null")
    public static PsiType getStreamElementType(PsiType type) {
        return StreamApiUtil.getStreamElementType(type, true);
    }

    @Contract(value="null, _ -> null")
    public static PsiType getStreamElementType(PsiType type, boolean variableType) {
        if (!(type instanceof PsiClassType)) {
            return null;
        }
        PsiClass aClass = ((PsiClassType)type).resolve();
        if (InheritanceUtil.isInheritor(aClass, false, "java.util.stream.IntStream")) {
            return PsiType.INT;
        }
        if (InheritanceUtil.isInheritor(aClass, false, "java.util.stream.LongStream")) {
            return PsiType.LONG;
        }
        if (InheritanceUtil.isInheritor(aClass, false, "java.util.stream.DoubleStream")) {
            return PsiType.DOUBLE;
        }
        if (!InheritanceUtil.isInheritor(aClass, false, "java.util.stream.Stream")) {
            return null;
        }
        PsiType streamType = PsiUtil.substituteTypeParameter(type, "java.util.stream.Stream", 0, false);
        if (variableType) {
            if (streamType instanceof PsiIntersectionType) {
                return null;
            }
            streamType = GenericsUtil.getVariableTypeByExpressionType(streamType);
        }
        return streamType;
    }

    public static boolean isNullOrEmptyStream(PsiExpression expression) {
        if (ExpressionUtils.isNullLiteral(expression)) {
            return true;
        }
        if (!(expression instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression call = (PsiMethodCallExpression)expression;
        String name = call.getMethodExpression().getReferenceName();
        if (!"empty".equals(name) && !"of".equals(name) || !call.getArgumentList().isEmpty()) {
            return false;
        }
        PsiMethod method = call.resolveMethod();
        if (method == null || !method.hasModifierProperty("static")) {
            return false;
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return false;
        }
        String qualifiedName = aClass.getQualifiedName();
        return qualifiedName != null && qualifiedName.startsWith("java.util.stream.");
    }

    @Contract(value="null -> false")
    public static boolean isSupportedStreamElement(PsiType type) {
        if (type == null) {
            return false;
        }
        if (type instanceof PsiPrimitiveType) {
            return type.equals(PsiType.INT) || type.equals(PsiType.LONG) || type.equals(PsiType.DOUBLE);
        }
        return true;
    }

    @Contract(value="null -> null")
    @Nullable
    public static String getStreamClassForType(@Nullable PsiType type) {
        if (type == null) {
            return null;
        }
        if (type instanceof PsiPrimitiveType) {
            if (type.equals(PsiType.INT)) {
                return "java.util.stream.IntStream";
            }
            if (type.equals(PsiType.LONG)) {
                return "java.util.stream.LongStream";
            }
            if (type.equals(PsiType.DOUBLE)) {
                return "java.util.stream.DoubleStream";
            }
            return null;
        }
        return "java.util.stream.Stream";
    }

    @Nullable
    public static PsiMethodCallExpression findSubsequentCall(PsiMethodCallExpression call, Predicate<String> isWantedCall, Predicate<String> isAllowedIntermediateCall) {
        return StreamApiUtil.findSubsequentCall(call, isWantedCall, c -> false, isAllowedIntermediateCall);
    }

    @Nullable
    public static PsiMethodCallExpression findSubsequentCall(PsiMethodCallExpression call, Predicate<String> isWantedCall, Predicate<PsiMethodCallExpression> isWantedCollector, Predicate<String> isAllowedIntermediateCall) {
        PsiMethodCallExpression chainCall = ExpressionUtils.getCallForQualifier(call);
        while (chainCall != null) {
            PsiMethodCallExpression collectorCall;
            PsiExpression[] args;
            String name = chainCall.getMethodExpression().getReferenceName();
            if (name == null) {
                return null;
            }
            if (isWantedCall.test(name)) {
                return chainCall;
            }
            if (name.equals("collect") && (args = chainCall.getArgumentList().getExpressions()).length == 1 && (collectorCall = ObjectUtils.tryCast(PsiUtil.skipParenthesizedExprDown(args[0]), PsiMethodCallExpression.class)) != null && isWantedCollector.test(collectorCall)) {
                return collectorCall;
            }
            if (!isAllowedIntermediateCall.test(name) || !InheritanceUtil.isInheritor(chainCall.getType(), "java.util.stream.BaseStream")) {
                return null;
            }
            chainCall = ExpressionUtils.getCallForQualifier(chainCall);
        }
        return null;
    }
}

