/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.NullnessUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnnecessaryCallToStringValueOfInspection
extends BaseInspection
implements CleanupLocalInspectionTool {
    private static final CallMatcher STATIC_TO_STRING_CONVERTERS = CallMatcher.anyOf(CallMatcher.staticCall("java.lang.String", "valueOf").parameterTypes("boolean"), CallMatcher.staticCall("java.lang.String", "valueOf").parameterTypes("char"), CallMatcher.staticCall("java.lang.String", "valueOf").parameterTypes("double"), CallMatcher.staticCall("java.lang.String", "valueOf").parameterTypes("float"), CallMatcher.staticCall("java.lang.String", "valueOf").parameterTypes("int"), CallMatcher.staticCall("java.lang.String", "valueOf").parameterTypes("long"), CallMatcher.staticCall("java.lang.String", "valueOf").parameterTypes("java.lang.Object"), CallMatcher.staticCall("java.lang.Boolean", "toString").parameterTypes("boolean"), CallMatcher.staticCall("java.lang.Byte", "toString").parameterTypes("byte"), CallMatcher.staticCall("java.lang.Short", "toString").parameterTypes("short"), CallMatcher.staticCall("java.lang.Character", "toString").parameterTypes("char"), CallMatcher.staticCall("java.lang.Integer", "toString").parameterTypes("int"), CallMatcher.staticCall("java.lang.Long", "toString").parameterTypes("long"), CallMatcher.staticCall("java.lang.Float", "toString").parameterTypes("float"), CallMatcher.staticCall("java.lang.Double", "toString").parameterTypes("double"), CallMatcher.staticCall("java.util.Objects", "toString").parameterTypes("java.lang.Object"));

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.conversion.to.string.display.name", new Object[0]);
        if (string == null) {
            UnnecessaryCallToStringValueOfInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("unnecessary.tostring.call.problem.descriptor", new Object[0]);
        if (string == null) {
            UnnecessaryCallToStringValueOfInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        String text2 = (String)infos[0];
        return new UnnecessaryCallToStringValueOfFix(text2);
    }

    public static String calculateReplacementText(PsiExpression expression) {
        if (!(expression instanceof PsiPolyadicExpression)) {
            return expression.getText();
        }
        PsiType type = expression.getType();
        if (TypeUtils.typeEquals("java.lang.String", type) || ParenthesesUtils.getPrecedence(expression) < 6) {
            return expression.getText();
        }
        return '(' + expression.getText() + ')';
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryCallToStringValueOfVisitor();
    }

    @Nullable
    private static PsiExpression tryUnwrapRedundantConversion(PsiMethodCallExpression call) {
        if (!STATIC_TO_STRING_CONVERTERS.test(call)) {
            return null;
        }
        PsiExpression argument = ParenthesesUtils.stripParentheses(call.getArgumentList().getExpressions()[0]);
        if (argument == null) {
            return null;
        }
        PsiType argumentType = argument.getType();
        boolean throwable = TypeUtils.expressionHasTypeOrSubtype(argument, "java.lang.Throwable");
        if (ExpressionUtils.isConversionToStringNecessary(call, throwable) && (!TypeUtils.isJavaLangString(argumentType) || NullnessUtil.getExpressionNullness(argument, true) != Nullness.NOT_NULL)) {
            return null;
        }
        return argument;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/style/UnnecessaryCallToStringValueOfInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class UnnecessaryCallToStringValueOfVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryCallToStringValueOfVisitor() {
        }

        @Override
        public void visitMethodCallExpression(PsiMethodCallExpression call) {
            PsiExpression argument = UnnecessaryCallToStringValueOfInspection.tryUnwrapRedundantConversion(call);
            if (argument == null) {
                return;
            }
            this.registerErrorAtOffset((PsiElement)call, 0, call.getArgumentList().getStartOffsetInParent(), ProblemHighlightType.LIKE_UNUSED_SYMBOL, UnnecessaryCallToStringValueOfInspection.calculateReplacementText(argument));
        }
    }

    private static class UnnecessaryCallToStringValueOfFix
    extends InspectionGadgetsFix {
        private final String replacementText;

        UnnecessaryCallToStringValueOfFix(String replacementText) {
            this.replacementText = replacementText;
        }

        @Override
        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("unnecessary.call.to.string.valueof.quickfix", this.replacementText);
            if (string == null) {
                UnnecessaryCallToStringValueOfFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            if ("Simplify" == null) {
                UnnecessaryCallToStringValueOfFix.$$$reportNull$$$0(1);
            }
            return "Simplify";
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiMethodCallExpression call = (PsiMethodCallExpression)descriptor.getPsiElement();
            PsiExpression arg = UnnecessaryCallToStringValueOfInspection.tryUnwrapRedundantConversion(call);
            if (arg == null) {
                return;
            }
            CommentTracker tracker = new CommentTracker();
            PsiReplacementUtil.replaceExpression(call, UnnecessaryCallToStringValueOfInspection.calculateReplacementText(tracker.markUnchanged(arg)), tracker);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/siyeh/ig/style/UnnecessaryCallToStringValueOfInspection$UnnecessaryCallToStringValueOfFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

