/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.threading;

import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class SafeLockInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getID() {
        if ("LockAcquiredButNotSafelyReleased" == null) {
            SafeLockInspection.$$$reportNull$$$0(0);
        }
        return "LockAcquiredButNotSafelyReleased";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("safe.lock.display.name", new Object[0]);
        if (string == null) {
            SafeLockInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiExpression expression = (PsiExpression)infos[0];
        PsiType type = expression.getType();
        assert (type != null);
        String text2 = type.getPresentableText();
        String string = InspectionGadgetsBundle.message("safe.lock.problem.descriptor", text2);
        if (string == null) {
            SafeLockInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SafeLockVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/siyeh/ig/threading/SafeLockInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static enum LockType {
        READ,
        WRITE,
        REGULAR;

    }

    private static class UnlockVisitor
    extends JavaRecursiveElementWalkingVisitor {
        private boolean containsUnlock;
        private final PsiVariable variable;
        private final LockType type;

        private UnlockVisitor(@NotNull PsiVariable variable, @NotNull LockType type) {
            if (variable == null) {
                UnlockVisitor.$$$reportNull$$$0(0);
            }
            if (type == null) {
                UnlockVisitor.$$$reportNull$$$0(1);
            }
            this.variable = variable;
            this.type = type;
        }

        @Override
        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                UnlockVisitor.$$$reportNull$$$0(2);
            }
            if (!this.containsUnlock) {
                super.visitElement(element);
            }
        }

        @Override
        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
            if (call == null) {
                UnlockVisitor.$$$reportNull$$$0(3);
            }
            if (this.containsUnlock) {
                return;
            }
            super.visitMethodCallExpression(call);
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"unlock".equals(methodName)) {
                return;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier instanceof PsiReferenceExpression) {
                if (this.type != LockType.REGULAR) {
                    return;
                }
                PsiReference reference = (PsiReference)((Object)qualifier);
                PsiElement target = reference.resolve();
                if (this.variable.equals(target)) {
                    this.containsUnlock = true;
                }
            } else if (qualifier instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)qualifier;
                PsiReferenceExpression methodExpression1 = methodCallExpression.getMethodExpression();
                String methodName1 = methodExpression1.getReferenceName();
                if (this.type == LockType.READ && "readLock".equals(methodName1) || this.type == LockType.WRITE && "writeLock".equals(methodName1)) {
                    PsiExpression qualifierExpression = methodExpression1.getQualifierExpression();
                    if (!(qualifierExpression instanceof PsiReferenceExpression)) {
                        return;
                    }
                    PsiReferenceExpression referenceExpression = (PsiReferenceExpression)qualifierExpression;
                    PsiElement target = referenceExpression.resolve();
                    if (this.variable.equals(target)) {
                        this.containsUnlock = true;
                    }
                }
            }
        }

        boolean containsUnlock() {
            return this.containsUnlock;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "call";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/threading/SafeLockInspection$UnlockVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitElement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodCallExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class SafeLockVisitor
    extends BaseInspectionVisitor {
        private SafeLockVisitor() {
        }

        @Override
        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            LockType type;
            PsiVariable boundVariable;
            PsiReferenceExpression referenceExpression;
            if (expression == null) {
                SafeLockVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethodCallExpression(expression);
            if (!SafeLockVisitor.isLockAcquireMethod(expression)) {
                return;
            }
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
            if (qualifierExpression instanceof PsiReferenceExpression) {
                referenceExpression = (PsiReferenceExpression)qualifierExpression;
                PsiElement target = referenceExpression.resolve();
                if (!(target instanceof PsiVariable)) {
                    return;
                }
                boundVariable = (PsiVariable)target;
                type = LockType.REGULAR;
            } else if (qualifierExpression instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)qualifierExpression;
                PsiReferenceExpression methodExpression1 = methodCallExpression.getMethodExpression();
                String methodName = methodExpression1.getReferenceName();
                if ("readLock".equals(methodName)) {
                    type = LockType.READ;
                } else if ("writeLock".equals(methodName)) {
                    type = LockType.WRITE;
                } else {
                    return;
                }
                PsiExpression qualifierExpression1 = methodExpression1.getQualifierExpression();
                if (!(qualifierExpression1 instanceof PsiReferenceExpression)) {
                    return;
                }
                referenceExpression = (PsiReferenceExpression)qualifierExpression1;
                PsiElement target = referenceExpression.resolve();
                if (!(target instanceof PsiVariable)) {
                    return;
                }
                boundVariable = (PsiVariable)target;
            } else {
                return;
            }
            PsiStatement statement = PsiTreeUtil.getParentOfType((PsiElement)expression, PsiStatement.class);
            if (statement == null) {
                return;
            }
            PsiStatement nextStatement = PsiTreeUtil.getNextSiblingOfType(statement, PsiStatement.class);
            while (nextStatement != null && !SafeLockVisitor.isSignificant(nextStatement)) {
                nextStatement = PsiTreeUtil.getNextSiblingOfType(nextStatement, PsiStatement.class);
            }
            if (!(nextStatement instanceof PsiTryStatement)) {
                this.registerError((PsiElement)expression, referenceExpression);
                return;
            }
            PsiTryStatement tryStatement = (PsiTryStatement)nextStatement;
            if (SafeLockVisitor.lockIsUnlockedInFinally(tryStatement, boundVariable, type)) {
                return;
            }
            this.registerError((PsiElement)expression, referenceExpression);
        }

        private static boolean isSignificant(@NotNull PsiStatement statement) {
            if (statement == null) {
                SafeLockVisitor.$$$reportNull$$$0(1);
            }
            final Ref<Boolean> result2 = new Ref<Boolean>(Boolean.TRUE);
            statement.accept(new JavaRecursiveElementWalkingVisitor(){

                @Override
                public void visitExpression(PsiExpression expression) {
                    super.visitExpression(expression);
                    result2.set(Boolean.FALSE);
                    this.stopWalking();
                }
            });
            return result2.get() == false;
        }

        private static boolean lockIsUnlockedInFinally(PsiTryStatement tryStatement, PsiVariable boundVariable, LockType type) {
            PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
            if (finallyBlock == null) {
                return false;
            }
            PsiCodeBlock tryBlock = tryStatement.getTryBlock();
            if (tryBlock == null) {
                return false;
            }
            UnlockVisitor visitor = new UnlockVisitor(boundVariable, type);
            finallyBlock.accept(visitor);
            return visitor.containsUnlock();
        }

        private static boolean isLockAcquireMethod(PsiMethodCallExpression expression) {
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"lock".equals(methodName) && !"lockInterruptibly".equals(methodName)) {
                return false;
            }
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            if (qualifier == null) {
                return false;
            }
            return TypeUtils.expressionHasTypeOrSubtype(qualifier, "java.util.concurrent.locks.Lock");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
            }
            objectArray2[1] = "com/siyeh/ig/threading/SafeLockInspection$SafeLockVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodCallExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSignificant";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

