/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AllOverridingMethodsSearch;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.intellij.util.containers.MultiMap;
import org.jetbrains.annotations.NotNull;

public class JavaAllOverridingMethodsSearcher
implements QueryExecutor<Pair<PsiMethod, PsiMethod>, AllOverridingMethodsSearch.SearchParameters> {
    @Override
    public boolean execute(@NotNull AllOverridingMethodsSearch.SearchParameters p, final @NotNull Processor<Pair<PsiMethod, PsiMethod>> consumer) {
        if (p == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "p", "com/intellij/psi/impl/search/JavaAllOverridingMethodsSearcher", "execute"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/JavaAllOverridingMethodsSearcher", "execute"));
        }
        final PsiClass psiClass = p.getPsiClass();
        final MultiMap<String, PsiMethod> methods = ApplicationManager.getApplication().runReadAction(new Computable<MultiMap<String, PsiMethod>>(){

            @Override
            public MultiMap<String, PsiMethod> compute() {
                MultiMap<String, PsiMethod> methods = MultiMap.create();
                for (PsiMethod method : psiClass.getMethods()) {
                    if (!PsiUtil.canBeOverriden(method)) continue;
                    methods.putValue(method.getName(), method);
                }
                return methods;
            }
        });
        SearchScope scope = p.getScope();
        Processor<PsiClass> inheritorsProcessor = new Processor<PsiClass>(){

            @Override
            public boolean process(PsiClass inheritor) {
                PsiSubstitutor substitutor = null;
                for (String name : methods.keySet()) {
                    if (inheritor.findMethodsByName(name, true).length == 0) continue;
                    for (PsiMethod method : methods.get(name)) {
                        PsiClass superClass;
                        if (method.hasModifierProperty("packageLocal") && !JavaPsiFacade.getInstance(inheritor.getProject()).arePackagesTheSame(psiClass, inheritor)) continue;
                        if (substitutor == null && (substitutor = TypeConversionUtil.getClassSubstitutor(psiClass, inheritor, PsiSubstitutor.EMPTY)) == null) {
                            return true;
                        }
                        MethodSignature signature = method.getSignature(substitutor);
                        PsiMethod inInheritor = MethodSignatureUtil.findMethodBySuperSignature(inheritor, signature, false);
                        if (inInheritor != null && !inInheritor.hasModifierProperty("static") && !consumer.process(Pair.create(method, inInheritor))) {
                            return false;
                        }
                        if (!psiClass.isInterface() || inheritor.isInterface() || (superClass = inheritor.getSuperClass()) == null || superClass.isInheritor(psiClass, true) || (inInheritor = MethodSignatureUtil.findMethodInSuperClassBySignatureInDerived(inheritor, superClass, signature, true)) == null || inInheritor.hasModifierProperty("static") || consumer.process(Pair.create(method, inInheritor))) continue;
                        return false;
                    }
                }
                return true;
            }
        };
        return ClassInheritorsSearch.search(psiClass, scope, true).forEach(inheritorsProcessor);
    }
}

