/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.util.FileTypeUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class EmptyTryBlockInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("empty.try.block.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/errorhandling/EmptyTryBlockInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("empty.try.block.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/errorhandling/EmptyTryBlockInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public boolean shouldInspect(PsiFile file) {
        return !FileTypeUtils.isInServerPageFile(file);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new EmptyTryBlockVisitor();
    }

    private static class EmptyTryBlockVisitor
    extends BaseInspectionVisitor {
        private EmptyTryBlockVisitor() {
        }

        @Override
        public void visitTryStatement(@NotNull PsiTryStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/errorhandling/EmptyTryBlockInspection$EmptyTryBlockVisitor", "visitTryStatement"));
            }
            super.visitTryStatement(statement);
            PsiCodeBlock finallyBlock = statement.getTryBlock();
            if (finallyBlock == null) {
                return;
            }
            if (finallyBlock.getStatements().length != 0) {
                return;
            }
            this.registerStatementError(statement, new Object[0]);
        }
    }
}

