/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DaemonCodeAnalyzerEx
extends DaemonCodeAnalyzer {
    private static final Logger LOG = Logger.getInstance("#com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx");

    public static DaemonCodeAnalyzerEx getInstanceEx(Project project) {
        return (DaemonCodeAnalyzerEx)project.getComponent(DaemonCodeAnalyzer.class);
    }

    public static boolean processHighlights(@NotNull Document document, @NotNull Project project, final @Nullable(value="null means all") HighlightSeverity minSeverity, int startOffset, int endOffset, final @NotNull Processor<HighlightInfo> processor) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerEx", "processHighlights"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerEx", "processHighlights"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerEx", "processHighlights"));
        }
        LOG.assertTrue(ApplicationManager.getApplication().isReadAccessAllowed());
        final SeverityRegistrar severityRegistrar = SeverityRegistrar.getSeverityRegistrar(project);
        MarkupModelEx model = (MarkupModelEx)DocumentMarkupModel.forDocument(document, project, true);
        return model.processRangeHighlightersOverlappingWith(startOffset, endOffset, (Processor<? super RangeHighlighterEx>)new Processor<RangeHighlighterEx>(){

            @Override
            public boolean process(@NotNull RangeHighlighterEx marker) {
                if (marker == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "marker", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerEx$1", "process"));
                }
                Object tt = marker.getErrorStripeTooltip();
                if (!(tt instanceof HighlightInfo)) {
                    return true;
                }
                HighlightInfo info = (HighlightInfo)tt;
                return minSeverity != null && severityRegistrar.compare(info.getSeverity(), minSeverity) < 0 || info.highlighter == null || processor.process(info);
            }
        });
    }

    static boolean processHighlightsOverlappingOutside(@NotNull Document document, @NotNull Project project, final @Nullable(value="null means all") HighlightSeverity minSeverity, int startOffset, int endOffset, final @NotNull Processor<HighlightInfo> processor) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerEx", "processHighlightsOverlappingOutside"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerEx", "processHighlightsOverlappingOutside"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerEx", "processHighlightsOverlappingOutside"));
        }
        LOG.assertTrue(ApplicationManager.getApplication().isReadAccessAllowed());
        final SeverityRegistrar severityRegistrar = SeverityRegistrar.getSeverityRegistrar(project);
        MarkupModelEx model = (MarkupModelEx)DocumentMarkupModel.forDocument(document, project, true);
        return model.processRangeHighlightersOutside(startOffset, endOffset, (Processor<? super RangeHighlighterEx>)new Processor<RangeHighlighterEx>(){

            @Override
            public boolean process(@NotNull RangeHighlighterEx marker) {
                if (marker == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "marker", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerEx$2", "process"));
                }
                Object tt = marker.getErrorStripeTooltip();
                if (!(tt instanceof HighlightInfo)) {
                    return true;
                }
                HighlightInfo info = (HighlightInfo)tt;
                return minSeverity != null && severityRegistrar.compare(info.getSeverity(), minSeverity) < 0 || info.highlighter == null || processor.process(info);
            }
        });
    }

    static boolean hasErrors(@NotNull Project project, @NotNull Document document) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerEx", "hasErrors"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/DaemonCodeAnalyzerEx", "hasErrors"));
        }
        return !DaemonCodeAnalyzerEx.processHighlights(document, project, HighlightSeverity.ERROR, 0, document.getTextLength(), CommonProcessors.alwaysFalse());
    }

    @NotNull
    public abstract List<HighlightInfo> runMainPasses(@NotNull PsiFile var1, @NotNull Document var2, @NotNull ProgressIndicator var3);

    public abstract boolean isErrorAnalyzingFinished(@NotNull PsiFile var1);

    @NotNull
    public abstract FileStatusMap getFileStatusMap();

    @NotNull
    public abstract List<HighlightInfo> getFileLevelHighlights(@NotNull Project var1, @NotNull PsiFile var2);

    public abstract void cleanFileLevelHighlights(@NotNull Project var1, int var2, PsiFile var3);

    public abstract void addFileLevelHighlight(@NotNull Project var1, int var2, @NotNull HighlightInfo var3, @NotNull PsiFile var4);
}

