/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.testOnly;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.TestFrameworks;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.impl.light.LightModifierList;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestOnlyInspection
extends BaseJavaBatchLocalInspectionTool {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message("inspection.test.only.problems.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/testOnly/TestOnlyInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getShortName() {
        if ("TestOnlyProblems" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/testOnly/TestOnlyInspection", "getShortName"));
        }
        return "TestOnlyProblems";
    }

    @Override
    @NotNull
    public String getGroupDisplayName() {
        String string = GENERAL_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/testOnly/TestOnlyInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder h, boolean isOnTheFly) {
        if (h == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "h", "com/intellij/codeInspection/testOnly/TestOnlyInspection", "buildVisitor"));
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            @Override
            public void visitCallExpression(PsiCallExpression e) {
                TestOnlyInspection.validate(e, e.resolveMethod(), h);
            }

            @Override
            public void visitReferenceExpression(PsiReferenceExpression reference) {
                PsiElement resolve = reference.resolve();
                if (resolve instanceof PsiField) {
                    TestOnlyInspection.validate(reference, (PsiField)resolve, h);
                }
            }

            @Override
            public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                if (reference.getParent() instanceof PsiNewExpression || reference.getParent() instanceof PsiAnonymousClass || PsiTreeUtil.getParentOfType((PsiElement)reference, PsiImportStatementBase.class) != null) {
                    return;
                }
                PsiElement resolve = reference.resolve();
                if (resolve instanceof PsiClass) {
                    TestOnlyInspection.validate(reference, (PsiClass)resolve, h);
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/testOnly/TestOnlyInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    private static void validate(@NotNull PsiElement reference, @Nullable PsiMember member, ProblemsHolder h) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/codeInspection/testOnly/TestOnlyInspection", "validate"));
        }
        if (member == null || !TestOnlyInspection.isAnnotatedAsTestOnly(member)) {
            return;
        }
        if (TestOnlyInspection.isInsideTestOnlyMethod(reference)) {
            return;
        }
        if (TestOnlyInspection.isInsideTestOnlyField(reference)) {
            return;
        }
        if (TestOnlyInspection.isInsideTestClass(reference)) {
            return;
        }
        if (TestOnlyInspection.isUnderTestSources(reference)) {
            return;
        }
        PsiAnnotation anno = TestOnlyInspection.findVisibleForTestingAnnotation(member);
        if (anno != null) {
            String modifier = TestOnlyInspection.getAccessModifierWithoutTesting(anno);
            if (modifier == null) {
                modifier = member.hasModifierProperty("public") ? "protected" : (member.hasModifierProperty("protected") ? "packageLocal" : "private");
            }
            LightModifierList modList = new LightModifierList(member.getManager(), JavaLanguage.INSTANCE, modifier);
            if (JavaResolveUtil.isAccessible(member, member.getContainingClass(), modList, reference, null, null)) {
                return;
            }
        }
        TestOnlyInspection.reportProblem(reference, member, h);
    }

    @Nullable
    private static String getAccessModifierWithoutTesting(PsiAnnotation anno) {
        PsiElement target;
        PsiAnnotationMemberValue ref = anno.findAttributeValue("visibility");
        if (ref instanceof PsiReferenceExpression && (target = ((PsiReferenceExpression)ref).resolve()) instanceof PsiEnumConstant) {
            String name = ((PsiEnumConstant)target).getName();
            return "PRIVATE".equals(name) ? "private" : ("PROTECTED".equals(name) ? "protected" : "packageLocal");
        }
        return null;
    }

    @Nullable
    private static PsiAnnotation findVisibleForTestingAnnotation(@NotNull PsiMember member) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/codeInspection/testOnly/TestOnlyInspection", "findVisibleForTestingAnnotation"));
        }
        PsiAnnotation anno = AnnotationUtil.findAnnotation((PsiModifierListOwner)member, "com.google.common.annotations.VisibleForTesting");
        return anno != null ? anno : AnnotationUtil.findAnnotation((PsiModifierListOwner)member, "com.android.annotations.VisibleForTesting");
    }

    private static boolean isInsideTestOnlyMethod(PsiElement e) {
        return TestOnlyInspection.isAnnotatedAsTestOnly(TestOnlyInspection.getTopLevelParentOfType(e, PsiMethod.class));
    }

    private static boolean isInsideTestOnlyField(PsiElement e) {
        return TestOnlyInspection.isAnnotatedAsTestOnly(TestOnlyInspection.getTopLevelParentOfType(e, PsiField.class));
    }

    private static boolean isAnnotatedAsTestOnly(@Nullable PsiMember m) {
        if (m == null) {
            return false;
        }
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)m, "org.jetbrains.annotations.TestOnly", false, false) || TestOnlyInspection.findVisibleForTestingAnnotation(m) != null || TestOnlyInspection.isAnnotatedAsTestOnly(m.getContainingClass());
    }

    private static boolean isInsideTestClass(PsiElement e) {
        PsiClass c = TestOnlyInspection.getTopLevelParentOfType(e, PsiClass.class);
        return c != null && TestFrameworks.getInstance().isTestClass(c);
    }

    private static <T extends PsiElement> T getTopLevelParentOfType(PsiElement e, Class<T> c) {
        T parent = PsiTreeUtil.getParentOfType(e, c);
        if (parent == null) {
            return null;
        }
        T next;
        while ((next = PsiTreeUtil.getParentOfType(parent, c)) != null) {
            parent = next;
        }
        return parent;
    }

    private static boolean isUnderTestSources(PsiElement e) {
        ProjectRootManager rm = ProjectRootManager.getInstance(e.getProject());
        VirtualFile f = e.getContainingFile().getVirtualFile();
        return f != null && rm.getFileIndex().isInTestSourceContent(f);
    }

    private static void reportProblem(PsiElement e, PsiMember target, ProblemsHolder h) {
        String message = InspectionsBundle.message(target instanceof PsiClass ? "inspection.test.only.problems.test.only.class.reference" : "inspection.test.only.problems.test.only.method.call", new Object[0]);
        h.registerProblem(e, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
    }
}

