/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.java.parser;

import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderUtil;
import com.intellij.lang.WhitespacesBinders;
import com.intellij.lang.java.parser.JavaParser;
import com.intellij.lang.java.parser.JavaParserUtil;
import com.intellij.lang.java.parser.ReferenceParser;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExpressionParser {
    private static final TokenSet ASSIGNMENT_OPS = TokenSet.create(JavaTokenType.EQ, JavaTokenType.ASTERISKEQ, JavaTokenType.DIVEQ, JavaTokenType.PERCEQ, JavaTokenType.PLUSEQ, JavaTokenType.MINUSEQ, JavaTokenType.LTLTEQ, JavaTokenType.GTGTEQ, JavaTokenType.GTGTGTEQ, JavaTokenType.ANDEQ, JavaTokenType.OREQ, JavaTokenType.XOREQ);
    private static final TokenSet RELATIONAL_OPS = TokenSet.create(JavaTokenType.LT, JavaTokenType.GT, JavaTokenType.LE, JavaTokenType.GE);
    private static final TokenSet POSTFIX_OPS = TokenSet.create(JavaTokenType.PLUSPLUS, JavaTokenType.MINUSMINUS);
    private static final TokenSet PREF_ARITHMETIC_OPS = TokenSet.orSet(POSTFIX_OPS, TokenSet.create(JavaTokenType.PLUS, JavaTokenType.MINUS));
    private static final TokenSet PREFIX_OPS = TokenSet.orSet(PREF_ARITHMETIC_OPS, TokenSet.create(JavaTokenType.TILDE, JavaTokenType.EXCL));
    private static final TokenSet LITERALS = TokenSet.create(JavaTokenType.TRUE_KEYWORD, JavaTokenType.FALSE_KEYWORD, JavaTokenType.NULL_KEYWORD, JavaTokenType.INTEGER_LITERAL, JavaTokenType.LONG_LITERAL, JavaTokenType.FLOAT_LITERAL, JavaTokenType.DOUBLE_LITERAL, JavaTokenType.CHARACTER_LITERAL, JavaTokenType.STRING_LITERAL);
    private static final TokenSet CONDITIONAL_OR_OPS = TokenSet.create(JavaTokenType.OROR);
    private static final TokenSet CONDITIONAL_AND_OPS = TokenSet.create(JavaTokenType.ANDAND);
    private static final TokenSet OR_OPS = TokenSet.create(JavaTokenType.OR);
    private static final TokenSet XOR_OPS = TokenSet.create(JavaTokenType.XOR);
    private static final TokenSet AND_OPS = TokenSet.create(JavaTokenType.AND);
    private static final TokenSet EQUALITY_OPS = TokenSet.create(JavaTokenType.EQEQ, JavaTokenType.NE);
    private static final TokenSet SHIFT_OPS = TokenSet.create(JavaTokenType.LTLT, JavaTokenType.GTGT, JavaTokenType.GTGTGT);
    private static final TokenSet ADDITIVE_OPS = TokenSet.create(JavaTokenType.PLUS, JavaTokenType.MINUS);
    private static final TokenSet MULTIPLICATIVE_OPS = TokenSet.create(JavaTokenType.ASTERISK, JavaTokenType.DIV, JavaTokenType.PERC);
    private static final TokenSet ARGS_LIST_END = TokenSet.create(JavaTokenType.RPARENTH, JavaTokenType.RBRACE, JavaTokenType.RBRACKET);
    private static final TokenSet ARGS_LIST_CONTINUE = TokenSet.create(JavaTokenType.IDENTIFIER, TokenType.BAD_CHARACTER, JavaTokenType.COMMA, JavaTokenType.INTEGER_LITERAL, JavaTokenType.STRING_LITERAL);
    private static final TokenSet THIS_OR_SUPER = TokenSet.create(JavaTokenType.THIS_KEYWORD, JavaTokenType.SUPER_KEYWORD);
    private static final TokenSet ID_OR_SUPER = TokenSet.create(JavaTokenType.IDENTIFIER, JavaTokenType.SUPER_KEYWORD);
    private static final TokenSet TYPE_START = TokenSet.orSet(ElementType.PRIMITIVE_TYPE_BIT_SET, TokenSet.create(JavaTokenType.IDENTIFIER, JavaTokenType.AT));
    private final JavaParser myParser;

    public ExpressionParser(@NotNull JavaParser javaParser) {
        if (javaParser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaParser", "com/intellij/lang/java/parser/ExpressionParser", "<init>"));
        }
        this.myParser = javaParser;
    }

    @Nullable
    public PsiBuilder.Marker parse(PsiBuilder builder) {
        return this.parseAssignment(builder);
    }

    @Nullable
    private PsiBuilder.Marker parseAssignment(PsiBuilder builder) {
        PsiBuilder.Marker left = this.parseConditional(builder);
        if (left == null) {
            return null;
        }
        IElementType tokenType = ExpressionParser.getGtTokenType(builder);
        if (ASSIGNMENT_OPS.contains(tokenType) && tokenType != null) {
            PsiBuilder.Marker assignment = left.precede();
            ExpressionParser.advanceGtToken(builder, tokenType);
            PsiBuilder.Marker right = this.parse(builder);
            if (right == null) {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.expression", new Object[0]));
            }
            assignment.done(JavaElementType.ASSIGNMENT_EXPRESSION);
            return assignment;
        }
        return left;
    }

    @Nullable
    public PsiBuilder.Marker parseConditional(PsiBuilder builder) {
        PsiBuilder.Marker condition = this.parseExpression(builder, ExprType.CONDITIONAL_OR);
        if (condition == null) {
            return null;
        }
        if (builder.getTokenType() != JavaTokenType.QUEST) {
            return condition;
        }
        PsiBuilder.Marker ternary = condition.precede();
        builder.advanceLexer();
        PsiBuilder.Marker truePart = this.parse(builder);
        if (truePart == null) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.expression", new Object[0]));
            ternary.done(JavaElementType.CONDITIONAL_EXPRESSION);
            return ternary;
        }
        if (builder.getTokenType() != JavaTokenType.COLON) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.colon", new Object[0]));
            ternary.done(JavaElementType.CONDITIONAL_EXPRESSION);
            return ternary;
        }
        builder.advanceLexer();
        PsiBuilder.Marker falsePart = this.parseConditional(builder);
        if (falsePart == null) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.expression", new Object[0]));
            ternary.done(JavaElementType.CONDITIONAL_EXPRESSION);
            return ternary;
        }
        ternary.done(JavaElementType.CONDITIONAL_EXPRESSION);
        return ternary;
    }

    @Nullable
    private PsiBuilder.Marker parseExpression(PsiBuilder builder, ExprType type) {
        switch (type) {
            case CONDITIONAL_OR: {
                return this.parseBinary(builder, ExprType.CONDITIONAL_AND, CONDITIONAL_OR_OPS);
            }
            case CONDITIONAL_AND: {
                return this.parseBinary(builder, ExprType.OR, CONDITIONAL_AND_OPS);
            }
            case OR: {
                return this.parseBinary(builder, ExprType.XOR, OR_OPS);
            }
            case XOR: {
                return this.parseBinary(builder, ExprType.AND, XOR_OPS);
            }
            case AND: {
                return this.parseBinary(builder, ExprType.EQUALITY, AND_OPS);
            }
            case EQUALITY: {
                return this.parseBinary(builder, ExprType.RELATIONAL, EQUALITY_OPS);
            }
            case RELATIONAL: {
                return this.parseRelational(builder);
            }
            case SHIFT: {
                return this.parseBinary(builder, ExprType.ADDITIVE, SHIFT_OPS);
            }
            case ADDITIVE: {
                return this.parseBinary(builder, ExprType.MULTIPLICATIVE, ADDITIVE_OPS);
            }
            case MULTIPLICATIVE: {
                return this.parseBinary(builder, ExprType.UNARY, MULTIPLICATIVE_OPS);
            }
            case UNARY: {
                return this.parseUnary(builder);
            }
            case TYPE: {
                return this.myParser.getReferenceParser().parseType(builder, 5);
            }
        }
        assert (false) : "Unexpected type: " + (Object)((Object)type);
        return null;
    }

    @Nullable
    private PsiBuilder.Marker parseBinary(PsiBuilder builder, ExprType type, TokenSet ops) {
        IElementType tokenType;
        PsiBuilder.Marker result = this.parseExpression(builder, type);
        if (result == null) {
            return null;
        }
        int operandCount = 1;
        IElementType currentExprTokenType = tokenType = ExpressionParser.getGtTokenType(builder);
        while (tokenType != null && ops.contains(tokenType)) {
            ExpressionParser.advanceGtToken(builder, tokenType);
            PsiBuilder.Marker right = this.parseExpression(builder, type);
            ++operandCount;
            tokenType = ExpressionParser.getGtTokenType(builder);
            if (tokenType != null && ops.contains(tokenType) && tokenType == currentExprTokenType && right != null) continue;
            result = result.precede();
            if (right == null) {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.expression", new Object[0]));
            }
            result.done(operandCount > 2 ? JavaElementType.POLYADIC_EXPRESSION : JavaElementType.BINARY_EXPRESSION);
            if (right == null) break;
            currentExprTokenType = tokenType;
            operandCount = 1;
        }
        return result;
    }

    @Nullable
    private PsiBuilder.Marker parseRelational(PsiBuilder builder) {
        IElementType tokenType;
        PsiBuilder.Marker left = this.parseExpression(builder, ExprType.SHIFT);
        if (left == null) {
            return null;
        }
        while ((tokenType = ExpressionParser.getGtTokenType(builder)) != null) {
            ExprType toParse;
            IElementType toCreate;
            if (RELATIONAL_OPS.contains(tokenType)) {
                toCreate = JavaElementType.BINARY_EXPRESSION;
                toParse = ExprType.SHIFT;
            } else {
                if (tokenType != JavaTokenType.INSTANCEOF_KEYWORD) break;
                toCreate = JavaElementType.INSTANCE_OF_EXPRESSION;
                toParse = ExprType.TYPE;
            }
            PsiBuilder.Marker expression = left.precede();
            ExpressionParser.advanceGtToken(builder, tokenType);
            PsiBuilder.Marker right = this.parseExpression(builder, toParse);
            if (right == null) {
                JavaParserUtil.error(builder, toParse == ExprType.TYPE ? JavaErrorMessages.message("expected.type", new Object[0]) : JavaErrorMessages.message("expected.expression", new Object[0]));
                expression.done(toCreate);
                return expression;
            }
            expression.done(toCreate);
            left = expression;
        }
        return left;
    }

    @Nullable
    private PsiBuilder.Marker parseUnary(PsiBuilder builder) {
        IElementType tokenType = builder.getTokenType();
        if (PREFIX_OPS.contains(tokenType)) {
            PsiBuilder.Marker unary = builder.mark();
            builder.advanceLexer();
            PsiBuilder.Marker operand = this.parseUnary(builder);
            if (operand == null) {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.expression", new Object[0]));
            }
            unary.done(JavaElementType.PREFIX_EXPRESSION);
            return unary;
        }
        if (tokenType == JavaTokenType.LPARENTH) {
            PsiBuilder.Marker typeCast = builder.mark();
            builder.advanceLexer();
            ReferenceParser.TypeInfo typeInfo = this.myParser.getReferenceParser().parseTypeInfo(builder, 101);
            if (typeInfo == null || !PsiBuilderUtil.expect(builder, JavaTokenType.RPARENTH)) {
                typeCast.rollbackTo();
                return this.parsePostfix(builder);
            }
            if (PREF_ARITHMETIC_OPS.contains(builder.getTokenType()) && !typeInfo.isPrimitive) {
                typeCast.rollbackTo();
                return this.parsePostfix(builder);
            }
            PsiBuilder.Marker expr = this.parseUnary(builder);
            if (expr == null) {
                if (!typeInfo.isParameterized) {
                    typeCast.rollbackTo();
                    return this.parsePostfix(builder);
                }
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.expression", new Object[0]));
            }
            typeCast.done(JavaElementType.TYPE_CAST_EXPRESSION);
            return typeCast;
        }
        return this.parsePostfix(builder);
    }

    @Nullable
    private PsiBuilder.Marker parsePostfix(PsiBuilder builder) {
        PsiBuilder.Marker operand = this.parsePrimary(builder, null, -1);
        if (operand == null) {
            return null;
        }
        while (POSTFIX_OPS.contains(builder.getTokenType())) {
            PsiBuilder.Marker postfix = operand.precede();
            builder.advanceLexer();
            postfix.done(JavaElementType.POSTFIX_EXPRESSION);
            operand = postfix;
        }
        return operand;
    }

    @Nullable
    private PsiBuilder.Marker parsePrimary(PsiBuilder builder, @Nullable BreakPoint breakPoint, int breakOffset) {
        IElementType tokenType;
        PsiBuilder.Marker startMarker = builder.mark();
        PsiBuilder.Marker expr = this.parsePrimaryExpressionStart(builder);
        if (expr == null) {
            startMarker.drop();
            return null;
        }
        while (true) {
            if ((tokenType = builder.getTokenType()) == JavaTokenType.DOT) {
                PsiBuilder.Marker refExpr;
                int offset;
                PsiBuilder.Marker copy;
                PsiBuilder.Marker dotPos = builder.mark();
                int dotOffset = builder.getCurrentOffset();
                builder.advanceLexer();
                IElementType dotTokenType = builder.getTokenType();
                if (dotTokenType == JavaTokenType.AT) {
                    this.myParser.getDeclarationParser().parseAnnotations(builder);
                    dotTokenType = builder.getTokenType();
                }
                if (dotTokenType == JavaTokenType.CLASS_KEYWORD && JavaParserUtil.exprType(expr) == JavaElementType.REFERENCE_EXPRESSION) {
                    if (breakPoint == BreakPoint.P1 && builder.getCurrentOffset() == breakOffset) {
                        JavaParserUtil.error(builder, JavaErrorMessages.message("expected.identifier", new Object[0]));
                        PsiBuilderUtil.drop(startMarker, dotPos);
                        return expr;
                    }
                    copy = startMarker.precede();
                    offset = builder.getCurrentOffset();
                    startMarker.rollbackTo();
                    PsiBuilder.Marker classObjAccess = this.parseClassAccessOrMethodReference(builder);
                    if (classObjAccess == null || builder.getCurrentOffset() < offset) {
                        copy.rollbackTo();
                        return this.parsePrimary(builder, BreakPoint.P1, offset);
                    }
                    startMarker = copy;
                    expr = classObjAccess;
                    continue;
                }
                if (dotTokenType == JavaTokenType.NEW_KEYWORD) {
                    dotPos.drop();
                    expr = this.parseNew(builder, expr);
                    continue;
                }
                if (dotTokenType == JavaTokenType.SUPER_KEYWORD && builder.lookAhead(1) == JavaTokenType.LPARENTH) {
                    dotPos.drop();
                    refExpr = expr.precede();
                    builder.mark().done(JavaElementType.REFERENCE_PARAMETER_LIST);
                    builder.advanceLexer();
                    refExpr.done(JavaElementType.REFERENCE_EXPRESSION);
                    expr = refExpr;
                    continue;
                }
                if (THIS_OR_SUPER.contains(dotTokenType) && JavaParserUtil.exprType(expr) == JavaElementType.REFERENCE_EXPRESSION) {
                    if (breakPoint == BreakPoint.P2 && builder.getCurrentOffset() == breakOffset) {
                        dotPos.rollbackTo();
                        startMarker.drop();
                        return expr;
                    }
                    copy = startMarker.precede();
                    offset = builder.getCurrentOffset();
                    startMarker.rollbackTo();
                    PsiBuilder.Marker ref = this.myParser.getReferenceParser().parseJavaCodeReference(builder, false, true, false, false);
                    if (ref == null || builder.getTokenType() != JavaTokenType.DOT || builder.getCurrentOffset() != dotOffset) {
                        copy.rollbackTo();
                        return this.parsePrimary(builder, BreakPoint.P2, offset);
                    }
                    builder.advanceLexer();
                    if (builder.getTokenType() != dotTokenType) {
                        copy.rollbackTo();
                        return this.parsePrimary(builder, BreakPoint.P2, offset);
                    }
                    builder.advanceLexer();
                    startMarker = copy;
                    expr = ref.precede();
                    expr.done(dotTokenType == JavaTokenType.THIS_KEYWORD ? JavaElementType.THIS_EXPRESSION : JavaElementType.SUPER_EXPRESSION);
                    continue;
                }
                refExpr = expr.precede();
                this.myParser.getReferenceParser().parseReferenceParameterList(builder, false, false);
                if (!PsiBuilderUtil.expect(builder, ID_OR_SUPER)) {
                    dotPos.rollbackTo();
                    builder.advanceLexer();
                    this.myParser.getReferenceParser().parseReferenceParameterList(builder, false, false);
                    JavaParserUtil.error(builder, JavaErrorMessages.message("expected.identifier", new Object[0]));
                    refExpr.done(JavaElementType.REFERENCE_EXPRESSION);
                    startMarker.drop();
                    return refExpr;
                }
                dotPos.drop();
                refExpr.done(JavaElementType.REFERENCE_EXPRESSION);
                expr = refExpr;
                continue;
            }
            if (tokenType == JavaTokenType.LPARENTH) {
                if (JavaParserUtil.exprType(expr) != JavaElementType.REFERENCE_EXPRESSION) {
                    startMarker.drop();
                    return expr;
                }
                PsiBuilder.Marker callExpr = expr.precede();
                this.parseArgumentList(builder);
                callExpr.done(JavaElementType.METHOD_CALL_EXPRESSION);
                expr = callExpr;
                continue;
            }
            if (tokenType != JavaTokenType.LBRACKET) break;
            if (breakPoint == BreakPoint.P4) {
                startMarker.drop();
                return expr;
            }
            builder.advanceLexer();
            if (builder.getTokenType() == JavaTokenType.RBRACKET && JavaParserUtil.exprType(expr) == JavaElementType.REFERENCE_EXPRESSION) {
                int pos = builder.getCurrentOffset();
                PsiBuilder.Marker copy = startMarker.precede();
                startMarker.rollbackTo();
                PsiBuilder.Marker classObjAccess = this.parseClassAccessOrMethodReference(builder);
                if (classObjAccess == null || builder.getCurrentOffset() <= pos) {
                    copy.rollbackTo();
                    return this.parsePrimary(builder, BreakPoint.P4, -1);
                }
                startMarker = copy;
                expr = classObjAccess;
                continue;
            }
            PsiBuilder.Marker arrayAccess = expr.precede();
            PsiBuilder.Marker index = this.parse(builder);
            if (index == null) {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.expression", new Object[0]));
                arrayAccess.done(JavaElementType.ARRAY_ACCESS_EXPRESSION);
                startMarker.drop();
                return arrayAccess;
            }
            if (builder.getTokenType() != JavaTokenType.RBRACKET) {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.rbracket", new Object[0]));
                arrayAccess.done(JavaElementType.ARRAY_ACCESS_EXPRESSION);
                startMarker.drop();
                return arrayAccess;
            }
            builder.advanceLexer();
            arrayAccess.done(JavaElementType.ARRAY_ACCESS_EXPRESSION);
            expr = arrayAccess;
        }
        if (tokenType == JavaTokenType.DOUBLE_COLON) {
            return this.parseMethodReference(builder, startMarker);
        }
        startMarker.drop();
        return expr;
    }

    @Nullable
    private PsiBuilder.Marker parsePrimaryExpressionStart(PsiBuilder builder) {
        IElementType tokenType = builder.getTokenType();
        if (LITERALS.contains(tokenType)) {
            PsiBuilder.Marker literal = builder.mark();
            builder.advanceLexer();
            literal.done(JavaElementType.LITERAL_EXPRESSION);
            return literal;
        }
        if (tokenType == JavaTokenType.LBRACE) {
            return this.parseArrayInitializer(builder);
        }
        if (tokenType == JavaTokenType.NEW_KEYWORD) {
            return this.parseNew(builder, null);
        }
        if (tokenType == JavaTokenType.LPARENTH) {
            PsiBuilder.Marker lambda = this.parseLambdaAfterParenth(builder, null);
            if (lambda != null) {
                return lambda;
            }
            PsiBuilder.Marker parenth = builder.mark();
            builder.advanceLexer();
            PsiBuilder.Marker inner = this.parse(builder);
            if (inner == null) {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.expression", new Object[0]));
            }
            if (!PsiBuilderUtil.expect(builder, JavaTokenType.RPARENTH) && inner != null) {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.rparen", new Object[0]));
            }
            parenth.done(JavaElementType.PARENTH_EXPRESSION);
            return parenth;
        }
        if (TYPE_START.contains(tokenType)) {
            PsiBuilder.Marker mark = builder.mark();
            ReferenceParser.TypeInfo typeInfo = this.myParser.getReferenceParser().parseTypeInfo(builder, 0);
            if (typeInfo != null) {
                PsiBuilder.Marker result;
                boolean optionalClassKeyword;
                boolean bl = optionalClassKeyword = typeInfo.isPrimitive || typeInfo.isArray;
                if ((optionalClassKeyword || !typeInfo.hasErrors && typeInfo.isParameterized) && (result = this.parseClassAccessOrMethodReference(builder, mark, optionalClassKeyword)) != null) {
                    return result;
                }
            }
            mark.rollbackTo();
        }
        PsiBuilder.Marker annotation = null;
        if (tokenType == JavaTokenType.AT) {
            annotation = this.myParser.getDeclarationParser().parseAnnotations(builder);
            tokenType = builder.getTokenType();
        }
        if (tokenType == JavaTokenType.IDENTIFIER) {
            PsiBuilder.Marker refExpr;
            if (builder.lookAhead(1) == JavaTokenType.ARROW) {
                return this.parseLambdaExpression(builder, false, null);
            }
            if (annotation != null) {
                PsiBuilder.Marker refParam = annotation.precede();
                refParam.doneBefore(JavaElementType.REFERENCE_PARAMETER_LIST, annotation);
                refExpr = refParam.precede();
            } else {
                refExpr = builder.mark();
                builder.mark().done(JavaElementType.REFERENCE_PARAMETER_LIST);
            }
            builder.advanceLexer();
            refExpr.done(JavaElementType.REFERENCE_EXPRESSION);
            return refExpr;
        }
        if (annotation != null) {
            annotation.rollbackTo();
            tokenType = builder.getTokenType();
        }
        PsiBuilder.Marker expr = null;
        if (tokenType == JavaTokenType.LT) {
            expr = builder.mark();
            if (!this.myParser.getReferenceParser().parseReferenceParameterList(builder, false, false)) {
                expr.rollbackTo();
                return null;
            }
            tokenType = builder.getTokenType();
            if (!THIS_OR_SUPER.contains(tokenType)) {
                expr.rollbackTo();
                return null;
            }
        }
        if (THIS_OR_SUPER.contains(tokenType)) {
            if (expr == null) {
                expr = builder.mark();
                builder.mark().done(JavaElementType.REFERENCE_PARAMETER_LIST);
            }
            builder.advanceLexer();
            expr.done(builder.getTokenType() == JavaTokenType.LPARENTH ? JavaElementType.REFERENCE_EXPRESSION : (tokenType == JavaTokenType.THIS_KEYWORD ? JavaElementType.THIS_EXPRESSION : JavaElementType.SUPER_EXPRESSION));
            return expr;
        }
        return null;
    }

    @Nullable
    private PsiBuilder.Marker parseArrayInitializer(PsiBuilder builder) {
        if (builder.getTokenType() != JavaTokenType.LBRACE) {
            return null;
        }
        PsiBuilder.Marker arrayInit = builder.mark();
        builder.advanceLexer();
        boolean expressionMissed = false;
        PsiBuilder.Marker lastComma = null;
        while (true) {
            IElementType tokenType;
            PsiBuilder.Marker arg;
            if (builder.getTokenType() == JavaTokenType.RBRACE) {
                builder.advanceLexer();
                break;
            }
            if (builder.getTokenType() == null) {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.rbrace", new Object[0]));
                break;
            }
            if (expressionMissed && lastComma != null) {
                lastComma.precede().errorBefore(JavaErrorMessages.message("expected.expression", new Object[0]), lastComma);
                lastComma.drop();
                lastComma = null;
            }
            if ((arg = this.parse(builder)) == null) {
                if (builder.getTokenType() == JavaTokenType.COMMA) {
                    expressionMissed = true;
                    lastComma = builder.mark();
                } else {
                    JavaParserUtil.error(builder, JavaErrorMessages.message("expected.rbrace", new Object[0]));
                    break;
                }
            }
            if ((tokenType = builder.getTokenType()) == JavaTokenType.COMMA) {
                builder.advanceLexer();
                continue;
            }
            if (tokenType == JavaTokenType.RBRACE) continue;
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.comma", new Object[0]));
        }
        if (lastComma != null) {
            lastComma.drop();
        }
        arrayInit.done(JavaElementType.ARRAY_INITIALIZER_EXPRESSION);
        return arrayInit;
    }

    @NotNull
    private PsiBuilder.Marker parseNew(PsiBuilder builder, @Nullable PsiBuilder.Marker start) {
        int dimCount;
        PsiBuilder.Marker anno;
        PsiBuilder.Marker newExpr;
        block19: {
            PsiBuilder.Marker refOrType;
            newExpr = start != null ? start.precede() : builder.mark();
            builder.advanceLexer();
            this.myParser.getReferenceParser().parseReferenceParameterList(builder, false, true);
            anno = this.myParser.getDeclarationParser().parseAnnotations(builder);
            IElementType tokenType = builder.getTokenType();
            if (tokenType == JavaTokenType.IDENTIFIER) {
                PsiBuilderUtil.rollbackTo(anno);
                refOrType = this.myParser.getReferenceParser().parseJavaCodeReference(builder, true, true, true, true);
                if (refOrType == null) {
                    JavaParserUtil.error(builder, JavaErrorMessages.message("expected.identifier", new Object[0]));
                    newExpr.done(JavaElementType.NEW_EXPRESSION);
                    PsiBuilder.Marker marker = newExpr;
                    if (marker == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/parser/ExpressionParser", "parseNew"));
                    }
                    return marker;
                }
            } else if (ElementType.PRIMITIVE_TYPE_BIT_SET.contains(tokenType)) {
                refOrType = null;
                builder.advanceLexer();
            } else {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.identifier", new Object[0]));
                newExpr.done(JavaElementType.NEW_EXPRESSION);
                PsiBuilder.Marker marker = newExpr;
                if (marker == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/parser/ExpressionParser", "parseNew"));
                }
                return marker;
            }
            if (refOrType != null && builder.getTokenType() == JavaTokenType.LPARENTH) {
                this.parseArgumentList(builder);
                if (builder.getTokenType() == JavaTokenType.LBRACE) {
                    PsiBuilder.Marker classElement = refOrType.precede();
                    this.myParser.getDeclarationParser().parseClassBodyWithBraces(builder, false, false);
                    classElement.done(JavaElementType.ANONYMOUS_CLASS);
                }
                newExpr.done(JavaElementType.NEW_EXPRESSION);
                PsiBuilder.Marker marker = newExpr;
                if (marker == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/parser/ExpressionParser", "parseNew"));
                }
                return marker;
            }
            anno = this.myParser.getDeclarationParser().parseAnnotations(builder);
            if (builder.getTokenType() != JavaTokenType.LBRACKET) {
                PsiBuilderUtil.rollbackTo(anno);
                JavaParserUtil.error(builder, refOrType == null ? JavaErrorMessages.message("expected.lbracket", new Object[0]) : JavaErrorMessages.message("expected.lparen.or.lbracket", new Object[0]));
                newExpr.done(JavaElementType.NEW_EXPRESSION);
                PsiBuilder.Marker marker = newExpr;
                if (marker == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/parser/ExpressionParser", "parseNew"));
                }
                return marker;
            }
            int bracketCount = 0;
            dimCount = 0;
            do {
                PsiBuilder.Marker dimExpr;
                anno = this.myParser.getDeclarationParser().parseAnnotations(builder);
                if (builder.getTokenType() != JavaTokenType.LBRACKET) break block19;
                builder.advanceLexer();
                if (bracketCount == dimCount && (dimExpr = this.parse(builder)) != null) {
                    ++dimCount;
                }
                ++bracketCount;
            } while (JavaParserUtil.expectOrError(builder, JavaTokenType.RBRACKET, "expected.rbracket"));
            newExpr.done(JavaElementType.NEW_EXPRESSION);
            PsiBuilder.Marker marker = newExpr;
            if (marker == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/parser/ExpressionParser", "parseNew"));
            }
            return marker;
        }
        PsiBuilderUtil.rollbackTo(anno);
        if (dimCount == 0) {
            if (builder.getTokenType() == JavaTokenType.LBRACE) {
                this.parseArrayInitializer(builder);
            } else {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.array.initializer", new Object[0]));
            }
        }
        newExpr.done(JavaElementType.NEW_EXPRESSION);
        PsiBuilder.Marker marker = newExpr;
        if (marker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/parser/ExpressionParser", "parseNew"));
        }
        return marker;
    }

    @Nullable
    private PsiBuilder.Marker parseClassAccessOrMethodReference(PsiBuilder builder) {
        PsiBuilder.Marker expr = builder.mark();
        boolean primitive = ElementType.PRIMITIVE_TYPE_BIT_SET.contains(builder.getTokenType());
        if (this.myParser.getReferenceParser().parseType(builder, 0) == null) {
            expr.drop();
            return null;
        }
        PsiBuilder.Marker result = this.parseClassAccessOrMethodReference(builder, expr, primitive);
        if (result == null) {
            expr.rollbackTo();
        }
        return result;
    }

    @Nullable
    private PsiBuilder.Marker parseClassAccessOrMethodReference(PsiBuilder builder, PsiBuilder.Marker expr, boolean optionalClassKeyword) {
        IElementType tokenType = builder.getTokenType();
        if (tokenType == JavaTokenType.DOT) {
            return ExpressionParser.parseClassObjectAccess(builder, expr, optionalClassKeyword);
        }
        if (tokenType == JavaTokenType.DOUBLE_COLON) {
            return this.parseMethodReference(builder, expr);
        }
        return null;
    }

    @Nullable
    private static PsiBuilder.Marker parseClassObjectAccess(PsiBuilder builder, PsiBuilder.Marker expr, boolean optionalClassKeyword) {
        PsiBuilder.Marker mark = builder.mark();
        builder.advanceLexer();
        if (builder.getTokenType() == JavaTokenType.CLASS_KEYWORD) {
            mark.drop();
            builder.advanceLexer();
        } else {
            if (!optionalClassKeyword) {
                return null;
            }
            mark.rollbackTo();
            builder.error(".class expected");
        }
        expr.done(JavaElementType.CLASS_OBJECT_ACCESS_EXPRESSION);
        return expr;
    }

    @NotNull
    private PsiBuilder.Marker parseMethodReference(PsiBuilder builder, PsiBuilder.Marker start) {
        builder.advanceLexer();
        this.myParser.getReferenceParser().parseReferenceParameterList(builder, false, false);
        if (!PsiBuilderUtil.expect(builder, JavaTokenType.IDENTIFIER) && !PsiBuilderUtil.expect(builder, JavaTokenType.NEW_KEYWORD)) {
            JavaParserUtil.error(builder, JavaErrorMessages.message("expected.identifier", new Object[0]));
        }
        start.done(JavaElementType.METHOD_REF_EXPRESSION);
        PsiBuilder.Marker marker = start;
        if (marker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/parser/ExpressionParser", "parseMethodReference"));
        }
        return marker;
    }

    @Nullable
    private PsiBuilder.Marker parseLambdaAfterParenth(PsiBuilder builder, @Nullable PsiBuilder.Marker typeList) {
        boolean isTyped;
        boolean isLambda;
        IElementType nextToken1 = builder.lookAhead(1);
        IElementType nextToken2 = builder.lookAhead(2);
        if (nextToken1 == JavaTokenType.RPARENTH && nextToken2 == JavaTokenType.ARROW) {
            isLambda = true;
            isTyped = false;
        } else if (nextToken1 == JavaTokenType.AT || ElementType.MODIFIER_BIT_SET.contains(nextToken1) || ElementType.PRIMITIVE_TYPE_BIT_SET.contains(nextToken1)) {
            isLambda = true;
            isTyped = true;
        } else if (nextToken1 == JavaTokenType.IDENTIFIER) {
            if (nextToken2 == JavaTokenType.COMMA || nextToken2 == JavaTokenType.RPARENTH && builder.lookAhead(3) == JavaTokenType.ARROW) {
                isLambda = true;
                isTyped = false;
            } else if (nextToken2 == JavaTokenType.ARROW) {
                isLambda = false;
                isTyped = false;
            } else {
                boolean arrow = false;
                PsiBuilder.Marker marker = builder.mark();
                while (!builder.eof()) {
                    builder.advanceLexer();
                    IElementType tokenType = builder.getTokenType();
                    if (tokenType == JavaTokenType.ARROW) {
                        arrow = true;
                        break;
                    }
                    if (tokenType == JavaTokenType.RPARENTH) {
                        arrow = builder.lookAhead(1) == JavaTokenType.ARROW;
                        break;
                    }
                    if (tokenType != JavaTokenType.LPARENTH && tokenType != JavaTokenType.SEMICOLON && tokenType != JavaTokenType.LBRACE && tokenType != JavaTokenType.RBRACE) continue;
                    break;
                }
                marker.rollbackTo();
                isLambda = arrow;
                isTyped = true;
            }
        } else {
            isLambda = false;
            isTyped = false;
        }
        return isLambda ? this.parseLambdaExpression(builder, isTyped, typeList) : null;
    }

    @Nullable
    private PsiBuilder.Marker parseLambdaExpression(PsiBuilder builder, boolean typed, @Nullable PsiBuilder.Marker typeList) {
        PsiBuilder.Marker start = typeList != null ? typeList.precede() : builder.mark();
        this.myParser.getDeclarationParser().parseLambdaParameterList(builder, typed);
        if (!PsiBuilderUtil.expect(builder, JavaTokenType.ARROW)) {
            start.rollbackTo();
            return null;
        }
        PsiBuilder.Marker body = builder.getTokenType() == JavaTokenType.LBRACE ? this.myParser.getStatementParser().parseCodeBlock(builder) : this.parse(builder);
        if (body == null) {
            builder.error(JavaErrorMessages.message("expected.lbrace", new Object[0]));
        }
        start.done(JavaElementType.LAMBDA_EXPRESSION);
        return start;
    }

    @NotNull
    public PsiBuilder.Marker parseArgumentList(PsiBuilder builder) {
        PsiBuilder.Marker list = builder.mark();
        builder.advanceLexer();
        boolean first = true;
        while (true) {
            IElementType tokenType = builder.getTokenType();
            if (first && (ARGS_LIST_END.contains(tokenType) || builder.eof()) || !first && !ARGS_LIST_CONTINUE.contains(tokenType)) break;
            boolean hasError = false;
            if (!first) {
                if (builder.getTokenType() == JavaTokenType.COMMA) {
                    builder.advanceLexer();
                } else {
                    hasError = true;
                    JavaParserUtil.error(builder, JavaErrorMessages.message("expected.comma.or.rparen", new Object[0]));
                    ExpressionParser.emptyExpression(builder);
                }
            }
            first = false;
            PsiBuilder.Marker arg = this.parse(builder);
            if (arg != null) continue;
            if (!hasError) {
                JavaParserUtil.error(builder, JavaErrorMessages.message("expected.expression", new Object[0]));
                ExpressionParser.emptyExpression(builder);
            }
            if (!ARGS_LIST_CONTINUE.contains(builder.getTokenType())) break;
            if (builder.getTokenType() == JavaTokenType.COMMA || builder.eof()) continue;
            builder.advanceLexer();
        }
        boolean closed = JavaParserUtil.expectOrError(builder, JavaTokenType.RPARENTH, "expected.rparen");
        list.done(JavaElementType.EXPRESSION_LIST);
        if (!closed) {
            list.setCustomEdgeTokenBinders(null, WhitespacesBinders.GREEDY_RIGHT_BINDER);
        }
        PsiBuilder.Marker marker = list;
        if (marker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/java/parser/ExpressionParser", "parseArgumentList"));
        }
        return marker;
    }

    private static void emptyExpression(PsiBuilder builder) {
        JavaParserUtil.emptyElement(builder, JavaElementType.EMPTY_EXPRESSION);
    }

    @Nullable
    private static IElementType getGtTokenType(PsiBuilder builder) {
        IElementType tokenType = builder.getTokenType();
        if (tokenType != JavaTokenType.GT) {
            return tokenType;
        }
        if (builder.rawLookup(1) == JavaTokenType.GT) {
            tokenType = builder.rawLookup(2) == JavaTokenType.GT ? (builder.rawLookup(3) == JavaTokenType.EQ ? JavaTokenType.GTGTGTEQ : JavaTokenType.GTGTGT) : (builder.rawLookup(2) == JavaTokenType.EQ ? JavaTokenType.GTGTEQ : JavaTokenType.GTGT);
        } else if (builder.rawLookup(1) == JavaTokenType.EQ) {
            tokenType = JavaTokenType.GE;
        }
        return tokenType;
    }

    private static void advanceGtToken(PsiBuilder builder, IElementType type) {
        PsiBuilder.Marker gtToken = builder.mark();
        if (type == JavaTokenType.GTGTGTEQ) {
            PsiBuilderUtil.advance(builder, 4);
        } else if (type == JavaTokenType.GTGTGT || type == JavaTokenType.GTGTEQ) {
            PsiBuilderUtil.advance(builder, 3);
        } else if (type == JavaTokenType.GTGT || type == JavaTokenType.GE) {
            PsiBuilderUtil.advance(builder, 2);
        } else {
            gtToken.drop();
            builder.advanceLexer();
            return;
        }
        gtToken.collapse(type);
    }

    private static enum BreakPoint {
        P1,
        P2,
        P4;

    }

    private static enum ExprType {
        CONDITIONAL_OR,
        CONDITIONAL_AND,
        OR,
        XOR,
        AND,
        EQUALITY,
        RELATIONAL,
        SHIFT,
        ADDITIVE,
        MULTIPLICATIVE,
        UNARY,
        TYPE;

    }
}

