/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThrowFromFinallyBlockInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("throw.from.finally.block.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/errorhandling/ThrowFromFinallyBlockInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        if (infos.length == 0) {
            String string = InspectionGadgetsBundle.message("throw.from.finally.block.problem.descriptor", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/errorhandling/ThrowFromFinallyBlockInspection", "buildErrorString"));
            }
            return string;
        }
        PsiClassType type = (PsiClassType)infos[0];
        String string = InspectionGadgetsBundle.message("possible.throw.from.finally.block.problem.descriptor", type.getPresentableText());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/errorhandling/ThrowFromFinallyBlockInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ThrowFromFinallyBlockVisitor();
    }

    private static PsiCodeBlock getContainingFinallyBlock(@NotNull PsiElement element, @NotNull PsiType thrownType) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/errorhandling/ThrowFromFinallyBlockInspection", "getContainingFinallyBlock"));
        }
        if (thrownType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thrownType", "com/siyeh/ig/errorhandling/ThrowFromFinallyBlockInspection", "getContainingFinallyBlock"));
        }
        PsiElement currentElement = element;
        PsiTryStatement tryStatement;
        while ((tryStatement = PsiTreeUtil.getParentOfType(currentElement, PsiTryStatement.class, true, PsiClass.class, PsiLambdaExpression.class)) != null) {
            PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
            if (PsiTreeUtil.isAncestor(finallyBlock, currentElement, true)) {
                return finallyBlock;
            }
            if (PsiTreeUtil.isAncestor(tryStatement.getTryBlock(), currentElement, true) && ThrowFromFinallyBlockInspection.isCaught(tryStatement, thrownType)) {
                return null;
            }
            currentElement = tryStatement;
        }
        return null;
    }

    private static boolean isCaught(PsiTryStatement tryStatement, PsiType exceptionType) {
        for (PsiParameter parameter : tryStatement.getCatchBlockParameters()) {
            PsiType type = parameter.getType();
            if (!type.isAssignableFrom(exceptionType)) continue;
            return true;
        }
        return false;
    }

    private static class ThrowFromFinallyBlockVisitor
    extends BaseInspectionVisitor {
        private ThrowFromFinallyBlockVisitor() {
        }

        @Override
        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            super.visitMethodCallExpression(expression);
            List<PsiClassType> exceptions = ExceptionUtil.getThrownExceptions(expression);
            if (exceptions.isEmpty()) {
                return;
            }
            for (PsiClassType exception : exceptions) {
                PsiCodeBlock finallyBlock = ThrowFromFinallyBlockInspection.getContainingFinallyBlock(expression, exception);
                if (finallyBlock == null || !ThrowFromFinallyBlockVisitor.isHidingOfPreviousException(finallyBlock, expression)) continue;
                this.registerMethodCallError(expression, exception);
                return;
            }
        }

        @Override
        public void visitThrowStatement(PsiThrowStatement statement) {
            PsiReferenceExpression referenceExpression;
            PsiElement target;
            super.visitThrowStatement(statement);
            PsiExpression exception = ParenthesesUtils.stripParentheses(statement.getException());
            if (exception == null) {
                return;
            }
            PsiType type = exception.getType();
            if (type == null) {
                return;
            }
            PsiCodeBlock finallyBlock = ThrowFromFinallyBlockInspection.getContainingFinallyBlock(statement, type);
            if (finallyBlock == null) {
                return;
            }
            if (exception instanceof PsiReferenceExpression && ((target = (referenceExpression = (PsiReferenceExpression)exception).resolve()) == null || !PsiTreeUtil.isAncestor(finallyBlock, target, true))) {
                return;
            }
            if (ThrowFromFinallyBlockVisitor.isHidingOfPreviousException(finallyBlock, statement)) {
                this.registerStatementError(statement, new Object[0]);
            }
        }

        private static boolean isHidingOfPreviousException(PsiCodeBlock finallyBlock, PsiElement throwElement) {
            PsiElement parent = finallyBlock.getParent();
            if (!(parent instanceof PsiTryStatement)) {
                return false;
            }
            PsiTryStatement tryStatement = (PsiTryStatement)parent;
            PsiCodeBlock[] catchBlocks = tryStatement.getCatchBlocks();
            if (catchBlocks.length == 0) {
                return true;
            }
            PsiIfStatement ifStatement = ThrowFromFinallyBlockVisitor.getParentOfType(throwElement, PsiIfStatement.class, finallyBlock);
            if (ifStatement == null) {
                return true;
            }
            boolean inThenBranch = PsiTreeUtil.isAncestor(ifStatement.getThenBranch(), throwElement, false);
            boolean inElseBranch = PsiTreeUtil.isAncestor(ifStatement.getElseBranch(), throwElement, false);
            if (!inThenBranch && !inElseBranch) {
                return true;
            }
            PsiExpression condition = ifStatement.getCondition();
            PsiVariable variable = ExpressionUtils.getVariableFromNullComparison(condition, inThenBranch);
            if (variable == null) {
                return true;
            }
            boolean assigned = true;
            for (PsiCodeBlock catchBlock : catchBlocks) {
                assigned &= VariableAccessUtils.variableIsAssigned(variable, catchBlock);
            }
            return !assigned;
        }

        @Nullable
        public static <T extends PsiElement> T getParentOfType(@Nullable PsiElement element, @NotNull Class<T> aClass, @NotNull PsiElement stopAt) {
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/errorhandling/ThrowFromFinallyBlockInspection$ThrowFromFinallyBlockVisitor", "getParentOfType"));
            }
            if (stopAt == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stopAt", "com/siyeh/ig/errorhandling/ThrowFromFinallyBlockInspection$ThrowFromFinallyBlockVisitor", "getParentOfType"));
            }
            if (element == null || element instanceof PsiFile) {
                return null;
            }
            for (element = element.getParent(); element != null && !aClass.isInstance(element); element = element.getParent()) {
                if (element != stopAt && !(element instanceof PsiFile)) continue;
                return null;
            }
            return (T)element;
        }
    }
}

