/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NotNull;

class ConvertOctalLiteralToDecimalFix
extends InspectionGadgetsFix {
    ConvertOctalLiteralToDecimalFix() {
    }

    @Override
    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/ConvertOctalLiteralToDecimalFix", "getFamilyName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getName() {
        String string = InspectionGadgetsBundle.message("convert.octal.literal.to.decimal.literal.quickfix", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/ConvertOctalLiteralToDecimalFix", "getName"));
        }
        return string;
    }

    @Override
    protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
        PsiElement element = descriptor.getPsiElement();
        if (!(element instanceof PsiLiteralExpression)) {
            return;
        }
        Object value = ((PsiLiteralExpression)element).getValue();
        if (value == null) {
            return;
        }
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance(project);
        PsiElementFactory factory = psiFacade.getElementFactory();
        PsiExpression decimalNumber = factory.createExpressionFromText(value.toString(), element);
        element.replace(decimalNumber);
    }
}

