/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.concurrency.AppDelayQueue;
import com.intellij.util.concurrency.BoundedTaskExecutor;
import com.intellij.util.concurrency.SchedulingWrapper;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class AppScheduledExecutorService
extends SchedulingWrapper {
    private static final Logger LOG = Logger.getInstance("#org.jetbrains.ide.PooledThreadExecutor");
    private Consumer<Thread> newThreadListener;

    @NotNull
    static ScheduledExecutorService getInstance() {
        AppScheduledExecutorService appScheduledExecutorService = Holder.INSTANCE;
        if (appScheduledExecutorService == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/concurrency/AppScheduledExecutorService", "getInstance"));
        }
        return appScheduledExecutorService;
    }

    AppScheduledExecutorService() {
        super(new BackendThreadPoolExecutor(), new AppDelayQueue());
        ((BackendThreadPoolExecutor)this.backendExecutorService).doSetThreadFactory(new ThreadFactory(){
            private final AtomicInteger counter = new AtomicInteger();

            @Override
            @NotNull
            public Thread newThread(@NotNull Runnable r) {
                if (r == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/util/concurrency/AppScheduledExecutorService$1", "newThread"));
                }
                Thread thread = new Thread(r, "ApplicationImpl pooled thread " + this.counter.incrementAndGet());
                thread.setPriority(4);
                Consumer listener = AppScheduledExecutorService.this.newThreadListener;
                if (listener != null) {
                    listener.consume(thread);
                }
                Thread thread2 = thread;
                if (thread2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/concurrency/AppScheduledExecutorService$1", "newThread"));
                }
                return thread2;
            }
        });
    }

    public void setNewThreadListener(@NotNull Consumer<Thread> threadListener) {
        if (threadListener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "threadListener", "com/intellij/util/concurrency/AppScheduledExecutorService", "setNewThreadListener"));
        }
        if (this.newThreadListener != null) {
            throw new IllegalStateException("Listener was already set: " + this.newThreadListener);
        }
        this.newThreadListener = threadListener;
    }

    @Override
    @NotNull
    public List<Runnable> shutdownNow() {
        List<Runnable> list = AppScheduledExecutorService.error();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/concurrency/AppScheduledExecutorService", "shutdownNow"));
        }
        return list;
    }

    @Override
    public void shutdown() {
        AppScheduledExecutorService.error();
    }

    static List<Runnable> error() {
        throw new IncorrectOperationException("You must not call this method on the global app pool");
    }

    @Override
    void doShutdown() {
        super.doShutdown();
        ((BackendThreadPoolExecutor)this.backendExecutorService).doShutdown();
    }

    @Override
    @NotNull
    List<Runnable> doShutdownNow() {
        List<Runnable> list = ContainerUtil.concat(super.doShutdownNow(), ((BackendThreadPoolExecutor)this.backendExecutorService).doShutdownNow());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/concurrency/AppScheduledExecutorService", "doShutdownNow"));
        }
        return list;
    }

    public void shutdownAppScheduledExecutorService() {
        this.delayQueue.shutdown();
        this.doShutdown();
    }

    public int getBackendPoolExecutorSize() {
        return ((ThreadPoolExecutor)this.backendExecutorService).getPoolSize();
    }

    private static class BackendThreadPoolExecutor
    extends ThreadPoolExecutor {
        BackendThreadPoolExecutor() {
            super(1, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
        }

        @Override
        protected void beforeExecute(Thread t, Runnable r) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Running " + BoundedTaskExecutor.info(r) + " in thread@" + System.identityHashCode(t));
            }
        }

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            if (t != null) {
                LOG.error("Worker exited due to exception", t);
            }
        }

        private void doShutdown() {
            super.shutdown();
        }

        private List<Runnable> doShutdownNow() {
            return super.shutdownNow();
        }

        private void doSetThreadFactory(ThreadFactory threadFactory) {
            super.setThreadFactory(threadFactory);
        }

        @Override
        public void shutdown() {
            AppScheduledExecutorService.error();
        }

        @Override
        @NotNull
        public List<Runnable> shutdownNow() {
            List<Runnable> list = AppScheduledExecutorService.error();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/concurrency/AppScheduledExecutorService$BackendThreadPoolExecutor", "shutdownNow"));
            }
            return list;
        }

        @Override
        public void setCorePoolSize(int corePoolSize) {
            AppScheduledExecutorService.error();
        }

        @Override
        public void allowCoreThreadTimeOut(boolean value) {
            AppScheduledExecutorService.error();
        }

        @Override
        public void setMaximumPoolSize(int maximumPoolSize) {
            AppScheduledExecutorService.error();
        }

        @Override
        public void setKeepAliveTime(long time, TimeUnit unit) {
            AppScheduledExecutorService.error();
        }

        @Override
        public void setThreadFactory(ThreadFactory threadFactory) {
            AppScheduledExecutorService.error();
        }
    }

    private static class Holder {
        private static final AppScheduledExecutorService INSTANCE = new AppScheduledExecutorService();

        private Holder() {
        }
    }
}

