/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.LanguageSubstitutors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class SubstitutedFileType
extends LanguageFileType {
    @NotNull
    private final FileType myOriginalFileType;
    @NotNull
    private final FileType myFileType;

    private SubstitutedFileType(@NotNull FileType originalFileType, @NotNull LanguageFileType substitutionFileType, @NotNull Language substitutedLanguage) {
        if (originalFileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalFileType", "com/intellij/util/indexing/SubstitutedFileType", "<init>"));
        }
        if (substitutionFileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutionFileType", "com/intellij/util/indexing/SubstitutedFileType", "<init>"));
        }
        if (substitutedLanguage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutedLanguage", "com/intellij/util/indexing/SubstitutedFileType", "<init>"));
        }
        super(substitutedLanguage);
        this.myOriginalFileType = originalFileType;
        this.myFileType = substitutionFileType;
    }

    @NotNull
    public static FileType substituteFileType(@NotNull VirtualFile file, @NotNull FileType fileType, Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/indexing/SubstitutedFileType", "substituteFileType"));
        }
        if (fileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileType", "com/intellij/util/indexing/SubstitutedFileType", "substituteFileType"));
        }
        if (project == null) {
            FileType fileType2 = fileType;
            if (fileType2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/SubstitutedFileType", "substituteFileType"));
            }
            return fileType2;
        }
        if (fileType instanceof LanguageFileType) {
            Language language = ((LanguageFileType)fileType).getLanguage();
            Language substitutedLanguage = LanguageSubstitutors.INSTANCE.substituteLanguage(language, file, project);
            LanguageFileType substFileType = substitutedLanguage.getAssociatedFileType();
            if (!substitutedLanguage.equals(language) && substFileType != null) {
                SubstitutedFileType substitutedFileType = new SubstitutedFileType(fileType, substFileType, substitutedLanguage);
                if (substitutedFileType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/SubstitutedFileType", "substituteFileType"));
                }
                return substitutedFileType;
            }
        }
        FileType fileType3 = fileType;
        if (fileType3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/SubstitutedFileType", "substituteFileType"));
        }
        return fileType3;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myFileType.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/SubstitutedFileType", "getName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getDescription() {
        String string = this.myFileType.getDescription();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/SubstitutedFileType", "getDescription"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getDefaultExtension() {
        String string = this.myFileType.getDefaultExtension();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/SubstitutedFileType", "getDefaultExtension"));
        }
        return string;
    }

    @Override
    public Icon getIcon() {
        return this.myFileType.getIcon();
    }

    @Override
    public String getCharset(@NotNull VirtualFile file, @NotNull byte[] content) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/indexing/SubstitutedFileType", "getCharset"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/util/indexing/SubstitutedFileType", "getCharset"));
        }
        return this.myFileType.getCharset(file, content);
    }

    @NotNull
    public FileType getOriginalFileType() {
        FileType fileType = this.myOriginalFileType;
        if (fileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/SubstitutedFileType", "getOriginalFileType"));
        }
        return fileType;
    }

    @NotNull
    public FileType getFileType() {
        FileType fileType = this.myFileType;
        if (fileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/SubstitutedFileType", "getFileType"));
        }
        return fileType;
    }

    public boolean isSameFileType() {
        return this.myFileType.equals(this.myOriginalFileType);
    }

    public String toString() {
        return "SubstitutedFileType: original=" + this.myOriginalFileType + "; substituted=" + this.myFileType;
    }
}

