/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiDiamondTypeImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Function;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class PsiDiamondTypeUtil {
    private static final Logger LOG = Logger.getInstance("#" + PsiDiamondTypeUtil.class.getName());

    private PsiDiamondTypeUtil() {
    }

    public static boolean canCollapseToDiamond(PsiNewExpression expression, PsiNewExpression context, @Nullable PsiType expectedType) {
        return PsiDiamondTypeUtil.canCollapseToDiamond(expression, context, expectedType, false);
    }

    public static boolean canChangeContextForDiamond(PsiNewExpression expression, PsiType expectedType) {
        PsiNewExpression copy = (PsiNewExpression)expression.copy();
        return PsiDiamondTypeUtil.canCollapseToDiamond(copy, copy, expectedType, true);
    }

    private static boolean canCollapseToDiamond(PsiNewExpression expression, PsiNewExpression context, @Nullable PsiType expectedType, boolean skipDiamonds) {
        PsiTypeElement[] typeElements;
        PsiReferenceParameterList parameterList;
        PsiJavaCodeReferenceElement classReference;
        if (PsiUtil.getLanguageLevel(context).isAtLeast(LanguageLevel.JDK_1_7) && (classReference = expression.getClassOrAnonymousClassReference()) != null && (parameterList = classReference.getParameterList()) != null && (typeElements = parameterList.getTypeParameterElements()).length > 0) {
            if (!skipDiamonds && typeElements.length == 1 && typeElements[0].getType() instanceof PsiDiamondType) {
                return false;
            }
            PsiDiamondType.DiamondInferenceResult inferenceResult = PsiDiamondTypeImpl.resolveInferredTypes(expression, context);
            if (inferenceResult.getErrorMessage() == null) {
                List<PsiType> types = inferenceResult.getInferredTypes();
                PsiType[] typeArguments = null;
                if (expectedType instanceof PsiClassType) {
                    typeArguments = ((PsiClassType)expectedType).getParameters();
                }
                if (typeArguments == null) {
                    typeArguments = parameterList.getTypeArguments();
                }
                if (types.size() == typeArguments.length) {
                    int typeArgumentsLength = typeArguments.length;
                    for (int i = 0; i < typeArgumentsLength; ++i) {
                        PsiWildcardType wildcardType;
                        PsiType bound;
                        PsiType typeArgument = typeArguments[i];
                        if (types.get(i) instanceof PsiWildcardType && (bound = (wildcardType = (PsiWildcardType)types.get(i)).getBound()) != null && (!wildcardType.isExtends() ? typeArgument.isAssignableFrom(bound) : bound.isAssignableFrom(typeArgument)) || typeArgument.equals(types.get(i))) continue;
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }

    public static PsiElement replaceExplicitWithDiamond(PsiElement psiElement) {
        if (psiElement instanceof PsiReferenceParameterList) {
            if (!FileModificationService.getInstance().prepareFileForWrite(psiElement.getContainingFile())) {
                return psiElement;
            }
            PsiNewExpression expression = (PsiNewExpression)JavaPsiFacade.getElementFactory(psiElement.getProject()).createExpressionFromText("new a<>()", psiElement);
            PsiJavaCodeReferenceElement classReference = expression.getClassReference();
            LOG.assertTrue(classReference != null);
            PsiReferenceParameterList parameterList = classReference.getParameterList();
            LOG.assertTrue(parameterList != null);
            return psiElement.replace(parameterList);
        }
        return psiElement;
    }

    public static PsiElement replaceDiamondWithExplicitTypes(PsiElement element) {
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiJavaCodeReferenceElement)) {
            return parent;
        }
        PsiJavaCodeReferenceElement javaCodeReferenceElement = (PsiJavaCodeReferenceElement)parent;
        StringBuilder text = new StringBuilder();
        text.append(javaCodeReferenceElement.getQualifiedName());
        text.append('<');
        PsiNewExpression newExpression = PsiTreeUtil.getParentOfType(element, PsiNewExpression.class);
        PsiDiamondType.DiamondInferenceResult result = PsiDiamondTypeImpl.resolveInferredTypesNoCheck(newExpression, newExpression);
        text.append(StringUtil.join(result.getInferredTypes(), new Function<PsiType, String>(){

            @Override
            public String fun(PsiType psiType) {
                return psiType.getCanonicalText();
            }
        }, ","));
        text.append('>');
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory(element.getProject());
        PsiJavaCodeReferenceElement newReference = elementFactory.createReferenceFromText(text.toString(), element);
        return CodeStyleManager.getInstance(javaCodeReferenceElement.getProject()).reformat(javaCodeReferenceElement.replace(newReference));
    }

    public static PsiExpression expandTopLevelDiamondsInside(PsiExpression expr) {
        PsiTypeElement[] typeParameterElements;
        PsiReferenceParameterList parameterList;
        PsiJavaCodeReferenceElement classReference;
        if (expr instanceof PsiNewExpression && (classReference = ((PsiNewExpression)expr).getClassReference()) != null && (parameterList = classReference.getParameterList()) != null && (typeParameterElements = parameterList.getTypeParameterElements()).length == 1 && typeParameterElements[0].getType() instanceof PsiDiamondType) {
            return (PsiExpression)PsiDiamondTypeUtil.replaceDiamondWithExplicitTypes(parameterList).getParent();
        }
        return expr;
    }

    public static String getCollapsedType(PsiType type, PsiElement context) {
        int idx;
        String typeText = type.getCanonicalText();
        if (PsiUtil.isLanguageLevel7OrHigher(context) && (idx = typeText.indexOf(60)) >= 0) {
            return typeText.substring(0, idx) + "<>";
        }
        return typeText;
    }

    public static boolean hasDiamond(PsiNewExpression expression) {
        return PsiDiamondTypeUtil.getDiamondType(expression) != null;
    }

    public static PsiDiamondType getDiamondType(PsiNewExpression expression) {
        PsiTypeElement[] parameterElements;
        PsiReferenceParameterList parameterList;
        PsiJavaCodeReferenceElement classReference;
        if (PsiUtil.isLanguageLevel7OrHigher(expression) && (classReference = expression.getClassOrAnonymousClassReference()) != null && (parameterList = classReference.getParameterList()) != null && (parameterElements = parameterList.getTypeParameterElements()).length == 1) {
            PsiType type = parameterElements[0].getType();
            return type instanceof PsiDiamondType ? (PsiDiamondType)type : null;
        }
        return null;
    }
}

