/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDiamondTypeImpl;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.augment.PsiAugmentProvider;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.PsiJavaParserFacadeImpl;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.impl.source.PsiDiamondTypeElementImpl;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiTypeElementImpl
extends CompositePsiElement
implements PsiTypeElement {
    private static final Class[] INTERMEDIATES = new Class[]{PsiComment.class, PsiWhiteSpace.class, PsiAnnotation.class, PsiTypeParameterList.class};

    public PsiTypeElementImpl() {
        this(JavaElementType.TYPE);
    }

    protected PsiTypeElementImpl(IElementType type) {
        super(type);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/source/PsiTypeElementImpl", "accept"));
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitTypeElement(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    @NotNull
    public PsiType getType() {
        PsiType psiType = CachedValuesManager.getCachedValue(this, new CachedValueProvider<PsiType>(){

            @Override
            @Nullable
            public CachedValueProvider.Result<PsiType> compute() {
                return CachedValueProvider.Result.create(PsiTypeElementImpl.this.calculateType(), PsiModificationTracker.MODIFICATION_COUNT);
            }
        });
        if (psiType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiTypeElementImpl", "getType"));
        }
        return psiType;
    }

    private PsiType calculateType() {
        PsiType inferredType = PsiAugmentProvider.getInferredType(this);
        if (inferredType != null) {
            return inferredType;
        }
        PsiType type = null;
        SmartList<PsiAnnotation> annotations = new SmartList<PsiAnnotation>();
        for (PsiElement child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            List<PsiType> types;
            if (child instanceof PsiComment || child instanceof PsiWhiteSpace) continue;
            if (child instanceof PsiAnnotation) {
                annotations.add((PsiAnnotation)child);
            } else if (child instanceof PsiTypeElement) {
                assert (type == null) : this;
                if (child instanceof PsiDiamondTypeElementImpl) {
                    type = new PsiDiamondTypeImpl(this.getManager(), this);
                    break;
                }
                type = ((PsiTypeElement)child).getType();
            } else if (PsiUtil.isJavaToken(child, ElementType.PRIMITIVE_TYPE_BIT_SET)) {
                assert (type == null) : this;
                this.addTypeUseCandidateAnnotations(annotations);
                String text = child.getText();
                type = annotations.isEmpty() ? PsiJavaParserFacadeImpl.getPrimitiveType(text) : new PsiPrimitiveType(text, PsiTypeElementImpl.filterTypeUse(annotations));
            } else if (child instanceof PsiJavaCodeReferenceElement) {
                assert (type == null) : this;
                this.addTypeUseCandidateAnnotations(annotations);
                type = new PsiClassReferenceType((PsiJavaCodeReferenceElement)child, null, PsiTypeElementImpl.filterTypeUse(annotations));
            } else if (PsiUtil.isJavaToken(child, JavaTokenType.LBRACKET)) {
                assert (type != null) : this;
                type = new PsiArrayType(type, PsiTypeElementImpl.filterTypeUse(annotations));
            } else if (PsiUtil.isJavaToken(child, JavaTokenType.ELLIPSIS)) {
                assert (type != null) : this;
                type = new PsiEllipsisType(type, PsiTypeElementImpl.filterTypeUse(annotations));
            }
            if (PsiUtil.isJavaToken(child, JavaTokenType.QUEST) || child instanceof ASTNode && ((ASTNode)((Object)child)).getElementType() == JavaElementType.DUMMY_ELEMENT && "any".equals(child.getText())) {
                assert (type == null) : this;
                PsiElement boundKind = PsiTreeUtil.skipSiblingsForward(child, PsiComment.class, PsiWhiteSpace.class);
                PsiElement boundType = PsiTreeUtil.skipSiblingsForward(boundKind, PsiComment.class, PsiWhiteSpace.class);
                type = PsiUtil.isJavaToken(boundKind, JavaTokenType.EXTENDS_KEYWORD) && boundType instanceof PsiTypeElement ? PsiWildcardType.createExtends(this.getManager(), ((PsiTypeElement)boundType).getType()) : (PsiUtil.isJavaToken(boundKind, JavaTokenType.SUPER_KEYWORD) && boundType instanceof PsiTypeElement ? PsiWildcardType.createSuper(this.getManager(), ((PsiTypeElement)boundType).getType()) : PsiWildcardType.createUnbounded(this.getManager()));
                type = ((PsiWildcardType)type).annotate(PsiTypeElementImpl.filterTypeUse(annotations));
                break;
            }
            if (PsiUtil.isJavaToken(child, JavaTokenType.AND)) {
                types = this.collectTypes();
                assert (!types.isEmpty()) : this;
                type = PsiIntersectionType.createIntersection(false, types.toArray(PsiType.createArray(types.size())));
                break;
            }
            if (!PsiUtil.isJavaToken(child, JavaTokenType.OR)) continue;
            types = this.collectTypes();
            assert (!types.isEmpty()) : this;
            type = PsiDisjunctionType.createDisjunction(types, this.getManager());
            break;
        }
        return type == null ? PsiType.NULL : type;
    }

    @NotNull
    private static TypeAnnotationProvider filterTypeUse(List<PsiAnnotation> annotations) {
        if (annotations.isEmpty()) {
            TypeAnnotationProvider typeAnnotationProvider = TypeAnnotationProvider.EMPTY;
            if (typeAnnotationProvider == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiTypeElementImpl", "filterTypeUse"));
            }
            return typeAnnotationProvider;
        }
        final ArrayList<PsiAnnotation> copy = ContainerUtil.newArrayList(annotations);
        annotations.clear();
        TypeAnnotationProvider typeAnnotationProvider = new TypeAnnotationProvider(){
            private volatile PsiAnnotation[] myCached;

            @Override
            @NotNull
            public PsiAnnotation[] getAnnotations() {
                PsiAnnotation[] result = this.myCached;
                if (result == null) {
                    List<PsiAnnotation> filtered = ContainerUtil.filter(copy, new Condition<PsiAnnotation>(){

                        @Override
                        public boolean value(PsiAnnotation annotation) {
                            return PsiImplUtil.isTypeAnnotation(annotation);
                        }
                    });
                    result = filtered.isEmpty() ? PsiAnnotation.EMPTY_ARRAY : filtered.toArray(new PsiAnnotation[filtered.size()]);
                    this.myCached = result;
                }
                if (result == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiTypeElementImpl$2", "getAnnotations"));
                }
                return result;
            }
        };
        if (typeAnnotationProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiTypeElementImpl", "filterTypeUse"));
        }
        return typeAnnotationProvider;
    }

    private void addTypeUseCandidateAnnotations(List<PsiAnnotation> annotations) {
        PsiElement parent = this;
        while (parent instanceof PsiTypeElement) {
            PsiElement left = PsiTreeUtil.skipSiblingsBackward(parent, INTERMEDIATES);
            if (left instanceof PsiModifierList) {
                Collections.addAll(annotations, ((PsiModifierList)left).getAnnotations());
                break;
            }
            if (left != null) break;
            parent = parent.getParent();
        }
    }

    private List<PsiType> collectTypes() {
        List<PsiTypeElement> typeElements = PsiTreeUtil.getChildrenOfTypeAsList(this, PsiTypeElement.class);
        return ContainerUtil.map(typeElements, new Function<PsiTypeElement, PsiType>(){

            @Override
            public PsiType fun(PsiTypeElement typeElement) {
                return typeElement.getType();
            }
        });
    }

    @Override
    public PsiJavaCodeReferenceElement getInnermostComponentReferenceElement() {
        TreeElement firstChildNode = this.getFirstChildNode();
        if (firstChildNode == null) {
            return null;
        }
        if (firstChildNode.getElementType() == JavaElementType.TYPE) {
            return ((PsiTypeElement)SourceTreeToPsiMap.treeToPsiNotNull(firstChildNode)).getInnermostComponentReferenceElement();
        }
        return this.getReferenceElement();
    }

    @Nullable
    private PsiJavaCodeReferenceElement getReferenceElement() {
        ASTNode ref = this.findChildByType(JavaElementType.JAVA_CODE_REFERENCE);
        if (ref == null) {
            return null;
        }
        return (PsiJavaCodeReferenceElement)SourceTreeToPsiMap.treeElementToPsi(ref);
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/source/PsiTypeElementImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/psi/impl/source/PsiTypeElementImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/psi/impl/source/PsiTypeElementImpl", "processDeclarations"));
        }
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, this);
        return true;
    }

    @Override
    @NotNull
    public PsiAnnotation[] getAnnotations() {
        PsiAnnotation[] annotations = (PsiAnnotation[])PsiTreeUtil.getChildrenOfType((PsiElement)this, PsiAnnotation.class);
        PsiAnnotation[] psiAnnotationArray = annotations != null ? annotations : PsiAnnotation.EMPTY_ARRAY;
        if (psiAnnotationArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiTypeElementImpl", "getAnnotations"));
        }
        return psiAnnotationArray;
    }

    @Override
    @NotNull
    public PsiAnnotation[] getApplicableAnnotations() {
        List<PsiAnnotation> annotations = PsiTreeUtil.getChildrenOfTypeAsList(this, PsiAnnotation.class);
        this.addTypeUseCandidateAnnotations(annotations);
        PsiAnnotation[] psiAnnotationArray = annotations.toArray(PsiAnnotation.ARRAY_FACTORY.create(annotations.size()));
        if (psiAnnotationArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiTypeElementImpl", "getApplicableAnnotations"));
        }
        return psiAnnotationArray;
    }

    @Override
    public PsiAnnotation findAnnotation(@NotNull @NonNls String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/psi/impl/source/PsiTypeElementImpl", "findAnnotation"));
        }
        return PsiImplUtil.findAnnotation(this, qualifiedName);
    }

    @Override
    @NotNull
    public PsiAnnotation addAnnotation(@NotNull @NonNls String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/psi/impl/source/PsiTypeElementImpl", "addAnnotation"));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/intellij/psi/impl/source/PsiTypeElementImpl", "replace"));
        }
        PsiImplUtil.markTypeAnnotations(this);
        PsiElement result = super.replace(newElement);
        PsiImplUtil.deleteTypeAnnotations((PsiTypeElement)result);
        return result;
    }

    @Override
    public String toString() {
        return "PsiTypeElement:" + this.getText();
    }
}

