/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;

public class ConfusingOctalEscapeInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getID() {
        if ("ConfusingOctalEscapeSequence" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/ConfusingOctalEscapeInspection", "getID"));
        }
        return "ConfusingOctalEscapeSequence";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("confusing.octal.escape.sequence.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/ConfusingOctalEscapeInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("confusing.octal.escape.sequence.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/ConfusingOctalEscapeInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ConfusingOctalEscapeVisitor();
    }

    private static class ConfusingOctalEscapeVisitor
    extends BaseInspectionVisitor {
        private ConfusingOctalEscapeVisitor() {
        }

        @Override
        public void visitLiteralExpression(@NotNull PsiLiteralExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/style/ConfusingOctalEscapeInspection$ConfusingOctalEscapeVisitor", "visitLiteralExpression"));
            }
            super.visitLiteralExpression(expression);
            if (!ExpressionUtils.hasStringType(expression)) {
                return;
            }
            String text = expression.getText();
            int escapeStart = -1;
            block0: while ((escapeStart = text.indexOf(92, escapeStart + 1)) >= 0) {
                int nextChar;
                if (escapeStart > 0 && text.charAt(escapeStart - 1) == '\\') continue;
                boolean isEscape = true;
                int textLength = text.length();
                for (nextChar = escapeStart + 1; nextChar < textLength && text.charAt(nextChar) == '\\'; ++nextChar) {
                    isEscape = !isEscape;
                }
                if (!isEscape) continue;
                escapeStart = nextChar - 1;
                int length = 1;
                boolean zeroToThree = false;
                while (true) {
                    char c;
                    if (escapeStart + length >= textLength || (c = text.charAt(escapeStart + length)) < '0' || c > '9') continue block0;
                    if (length == 1 && (c == '0' || c == '1' || c == '2' || c == '3')) {
                        zeroToThree = true;
                    }
                    if (c == '8' || c == '9' || length > 2 && !zeroToThree || length > 3) {
                        this.registerErrorAtOffset((PsiElement)expression, escapeStart, length, new Object[0]);
                        continue block0;
                    }
                    ++length;
                }
                break;
            }
            return;
        }
    }
}

