/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.ide.script;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ClassLoaderUtil;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringHash;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;
import org.jetbrains.ide.script.IdeScriptEngine;
import org.jetbrains.ide.script.IdeScriptEngineManager;
import org.jetbrains.ide.script.IdeScriptException;

class Jsr223IdeScriptEngineManagerImpl
extends IdeScriptEngineManager {
    private static final Logger LOG = Logger.getInstance(IdeScriptEngineManager.class);
    private final Future<ScriptEngineManager> myManagerFuture = PooledThreadExecutor.INSTANCE.submit(new Callable<ScriptEngineManager>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ScriptEngineManager call() {
            long start = System.currentTimeMillis();
            try {
                ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
                return scriptEngineManager;
            }
            finally {
                long end = System.currentTimeMillis();
                LOG.info(ScriptEngineManager.class.getName() + " initialized in " + (end - start) + " ms");
            }
        }
    });

    Jsr223IdeScriptEngineManagerImpl() {
    }

    @Override
    @NotNull
    public List<String> getLanguages() {
        List<String> list = ContainerUtil.map(this.getScriptEngineManager().getEngineFactories(), new Function<ScriptEngineFactory, String>(){

            @Override
            public String fun(ScriptEngineFactory factory) {
                return factory.getLanguageName();
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/ide/script/Jsr223IdeScriptEngineManagerImpl", "getLanguages"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<String> getFileExtensions(@Nullable String language) {
        ArrayList<String> extensions = ContainerUtil.newArrayList();
        List<ScriptEngineFactory> factories = this.getScriptEngineManager().getEngineFactories();
        for (ScriptEngineFactory factory : factories) {
            if (language != null && !factory.getLanguageName().equals(language)) continue;
            extensions.addAll(factory.getExtensions());
        }
        ArrayList<String> arrayList = extensions;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/ide/script/Jsr223IdeScriptEngineManagerImpl", "getFileExtensions"));
        }
        return arrayList;
    }

    @Override
    @Nullable
    public IdeScriptEngine getEngineForLanguage(final @NotNull String language, @Nullable ClassLoader loader) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "org/jetbrains/ide/script/Jsr223IdeScriptEngineManagerImpl", "getEngineForLanguage"));
        }
        ClassLoader l = ObjectUtils.notNull(loader, AllPluginsLoader.INSTANCE);
        return ClassLoaderUtil.runWithClassLoader(l, new Computable<IdeScriptEngine>(){

            @Override
            public IdeScriptEngine compute() {
                return Jsr223IdeScriptEngineManagerImpl.createIdeScriptEngine(Jsr223IdeScriptEngineManagerImpl.this.getScriptEngineManager().getEngineByName(language));
            }
        });
    }

    @Override
    @Nullable
    public IdeScriptEngine getEngineForFileExtension(final @NotNull String extension, @Nullable ClassLoader loader) {
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "org/jetbrains/ide/script/Jsr223IdeScriptEngineManagerImpl", "getEngineForFileExtension"));
        }
        ClassLoader l = ObjectUtils.notNull(loader, AllPluginsLoader.INSTANCE);
        return ClassLoaderUtil.runWithClassLoader(l, new Computable<IdeScriptEngine>(){

            @Override
            public IdeScriptEngine compute() {
                return Jsr223IdeScriptEngineManagerImpl.createIdeScriptEngine(Jsr223IdeScriptEngineManagerImpl.this.getScriptEngineManager().getEngineByExtension(extension));
            }
        });
    }

    @Override
    public boolean isInitialized() {
        return this.myManagerFuture.isDone();
    }

    @NotNull
    private ScriptEngineManager getScriptEngineManager() {
        ScriptEngineManager manager = null;
        try {
            manager = this.myManagerFuture.get();
        }
        catch (Exception e) {
            LOG.error(e);
        }
        ScriptEngineManager scriptEngineManager = ObjectUtils.assertNotNull(manager);
        if (scriptEngineManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/ide/script/Jsr223IdeScriptEngineManagerImpl", "getScriptEngineManager"));
        }
        return scriptEngineManager;
    }

    @Nullable
    private static IdeScriptEngine createIdeScriptEngine(@Nullable ScriptEngine engine) {
        return engine == null ? null : Jsr223IdeScriptEngineManagerImpl.redirectOutputToLog(new Jsr223IdeScriptEngine(engine));
    }

    private static IdeScriptEngine redirectOutputToLog(IdeScriptEngine engine) {
        engine.setStdOut(new MyAbstractWriter(){

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
                LOG.info(new String(cbuf, off, len));
            }
        });
        engine.setStdErr(new MyAbstractWriter(){

            @Override
            public void write(char[] cbuf, int off, int len) throws IOException {
                LOG.warn(new String(cbuf, off, len));
            }
        });
        return engine;
    }

    static class AllPluginsLoader
    extends ClassLoader {
        static final AllPluginsLoader INSTANCE = new AllPluginsLoader();
        final Map<Long, ClassLoader> myLuckyGuess = ContainerUtil.newConcurrentMap();

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            int p0 = name.indexOf("$");
            int p1 = p0 > 0 ? name.indexOf("$", p0 + 1) : -1;
            String base = p0 > 0 ? name.substring(0, Math.max(p0, p1)) : name;
            long hash = StringHash.calc(base);
            ClassLoader loader = this.myLuckyGuess.get(hash);
            if (loader == this) {
                throw new ClassNotFoundException(name);
            }
            Class<?> c = null;
            if (loader != null) {
                try {
                    c = loader.loadClass(name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (c == null) {
                boolean first = true;
                for (IdeaPluginDescriptor descriptor : PluginManagerCore.getPlugins()) {
                    ClassLoader l = descriptor.getPluginClassLoader();
                    if (l == null || l == loader) continue;
                    try {
                        l.loadClass(base);
                        if (first) {
                            this.myLuckyGuess.put(hash, l);
                        }
                        first = false;
                        try {
                            c = l.loadClass(name);
                        }
                        catch (ClassNotFoundException e) {
                            if (p0 > 0 || name.startsWith("java.")) break;
                            if (!name.startsWith("groovy.")) continue;
                        }
                        break;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                if (first && loader == null) {
                    this.myLuckyGuess.put(hash, this);
                }
            }
            if (c != null) {
                return c;
            }
            this.myLuckyGuess.put(StringHash.calc(name), this);
            throw new ClassNotFoundException(name);
        }

        @Override
        protected URL findResource(String name) {
            return this.getClass().getClassLoader().getResource(name);
        }

        @Override
        protected Enumeration<URL> findResources(String name) throws IOException {
            return this.getClass().getClassLoader().getResources(name);
        }
    }

    private static abstract class MyAbstractWriter
    extends Writer {
        private MyAbstractWriter() {
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }
    }

    static class Jsr223IdeScriptEngine
    implements IdeScriptEngine {
        private final ScriptEngine myEngine;
        private final ClassLoader myLoader;

        Jsr223IdeScriptEngine(ScriptEngine engine) {
            this.myEngine = engine;
            this.myLoader = Thread.currentThread().getContextClassLoader();
        }

        @Override
        public Object getBinding(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/ide/script/Jsr223IdeScriptEngineManagerImpl$Jsr223IdeScriptEngine", "getBinding"));
            }
            return this.myEngine.get(name);
        }

        @Override
        public void setBinding(@NotNull String name, Object value) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/ide/script/Jsr223IdeScriptEngineManagerImpl$Jsr223IdeScriptEngine", "setBinding"));
            }
            this.myEngine.put(name, value);
        }

        @Override
        @NotNull
        public Writer getStdOut() {
            Writer writer = this.myEngine.getContext().getWriter();
            if (writer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/ide/script/Jsr223IdeScriptEngineManagerImpl$Jsr223IdeScriptEngine", "getStdOut"));
            }
            return writer;
        }

        @Override
        public void setStdOut(@NotNull Writer writer) {
            if (writer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "writer", "org/jetbrains/ide/script/Jsr223IdeScriptEngineManagerImpl$Jsr223IdeScriptEngine", "setStdOut"));
            }
            this.myEngine.getContext().setWriter(writer);
        }

        @Override
        @NotNull
        public Writer getStdErr() {
            Writer writer = this.myEngine.getContext().getErrorWriter();
            if (writer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/ide/script/Jsr223IdeScriptEngineManagerImpl$Jsr223IdeScriptEngine", "getStdErr"));
            }
            return writer;
        }

        @Override
        public void setStdErr(@NotNull Writer writer) {
            if (writer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "writer", "org/jetbrains/ide/script/Jsr223IdeScriptEngineManagerImpl$Jsr223IdeScriptEngine", "setStdErr"));
            }
            this.myEngine.getContext().setErrorWriter(writer);
        }

        @Override
        @NotNull
        public Reader getStdIn() {
            Reader reader = this.myEngine.getContext().getReader();
            if (reader == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/ide/script/Jsr223IdeScriptEngineManagerImpl$Jsr223IdeScriptEngine", "getStdIn"));
            }
            return reader;
        }

        @Override
        public void setStdIn(@NotNull Reader reader) {
            if (reader == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "org/jetbrains/ide/script/Jsr223IdeScriptEngineManagerImpl$Jsr223IdeScriptEngine", "setStdIn"));
            }
            this.myEngine.getContext().setReader(reader);
        }

        @Override
        @NotNull
        public String getLanguage() {
            String string = this.myEngine.getFactory().getLanguageName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/ide/script/Jsr223IdeScriptEngineManagerImpl$Jsr223IdeScriptEngine", "getLanguage"));
            }
            return string;
        }

        @Override
        @NotNull
        public List<String> getFileExtensions() {
            List<String> list = this.myEngine.getFactory().getExtensions();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/ide/script/Jsr223IdeScriptEngineManagerImpl$Jsr223IdeScriptEngine", "getFileExtensions"));
            }
            return list;
        }

        @Override
        public Object eval(final @NotNull String script) throws IdeScriptException {
            if (script == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "org/jetbrains/ide/script/Jsr223IdeScriptEngineManagerImpl$Jsr223IdeScriptEngine", "eval"));
            }
            return ClassLoaderUtil.runWithClassLoader(this.myLoader, new ThrowableComputable<Object, IdeScriptException>(){

                @Override
                public Object compute() throws IdeScriptException {
                    try {
                        return Jsr223IdeScriptEngine.this.myEngine.eval(script);
                    }
                    catch (Throwable e) {
                        throw new IdeScriptException(e);
                    }
                }
            });
        }
    }
}

