/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LanguageLevelModuleExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.java.stubs.index.JavaMethodParameterTypesIndex;
import com.intellij.psi.impl.search.JavaFunctionalExpressionIndex;
import com.intellij.psi.impl.search.JavaSourceFilterScope;
import com.intellij.psi.impl.search.PsiSearchHelperImpl;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.FunctionalExpressionSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JavaFunctionalExpressionSearcher
extends QueryExecutorBase<PsiFunctionalExpression, FunctionalExpressionSearch.SearchParameters> {
    private static final Logger LOG = Logger.getInstance("#" + JavaFunctionalExpressionSearcher.class.getName());
    public static final int SMART_SEARCH_THRESHOLD = 5;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processQuery(@NotNull FunctionalExpressionSearch.SearchParameters queryParameters, @NotNull Processor<PsiFunctionalExpression> consumer) {
        boolean isVoid;
        int expectedFunExprParamsCount;
        GlobalSearchScope useScope;
        Project project;
        PsiClass aClass;
        if (queryParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "com/intellij/psi/impl/search/JavaFunctionalExpressionSearcher", "processQuery"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/JavaFunctionalExpressionSearcher", "processQuery"));
        }
        AccessToken token = ReadAction.start();
        try {
            aClass = queryParameters.getElementToSearch();
            if (!aClass.isValid() || !LambdaUtil.isFunctionalClass(aClass)) {
                return;
            }
            project = aClass.getProject();
            Set<Module> highLevelModules = JavaFunctionalExpressionSearcher.getJava8Modules(project);
            if (highLevelModules.isEmpty()) {
                return;
            }
            useScope = JavaFunctionalExpressionSearcher.convertToGlobalScope(project, queryParameters.getEffectiveSearchScope());
            PsiMethod functionalInterfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(aClass);
            LOG.assertTrue(functionalInterfaceMethod != null);
            expectedFunExprParamsCount = functionalInterfaceMethod.getParameterList().getParameters().length;
            isVoid = PsiType.VOID.equals(functionalInterfaceMethod.getReturnType());
        }
        finally {
            token.finish();
        }
        Set<VirtualFile> candidateFiles = JavaFunctionalExpressionSearcher.getFilesWithFunctionalExpressionsScope(project, new JavaSourceFilterScope(useScope));
        if (candidateFiles.size() < 5) {
            JavaFunctionalExpressionSearcher.searchInFiles(aClass, consumer, candidateFiles, expectedFunExprParamsCount, isVoid);
            return;
        }
        GlobalSearchScope candidateScope = GlobalSearchScope.filesScope(project, candidateFiles);
        Collection<PsiMethod> methodCandidates = JavaFunctionalExpressionSearcher.getCandidateMethodsWithSuitableParams(aClass, project, useScope, candidateFiles, candidateScope);
        LinkedHashSet<VirtualFile> filesToProcess = new LinkedHashSet<VirtualFile>();
        FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
        for (PsiMethod psiMethod : methodCandidates) {
            ApplicationManager.getApplication().runReadAction(() -> {
                if (!psiMethod.isValid()) {
                    return;
                }
                int parametersCount = psiMethod.getParameterList().getParametersCount();
                boolean varArgs = psiMethod.isVarArgs();
                PsiParameter[] parameters = psiMethod.getParameterList().getParameters();
                GlobalSearchScope methodUseScope = JavaFunctionalExpressionSearcher.convertToGlobalScope(project, psiMethod.getUseScope());
                LinkedHashMap<VirtualFile, Set<JavaFunctionalExpressionIndex.IndexHolder>> holders = new LinkedHashMap<VirtualFile, Set<JavaFunctionalExpressionIndex.IndexHolder>>();
                SuitableFilesProcessor processor = new SuitableFilesProcessor(holders, expectedFunExprParamsCount, parametersCount, varArgs, parameters);
                fileBasedIndex.processValues(JavaFunctionalExpressionIndex.JAVA_FUNCTIONAL_EXPRESSION_INDEX_ID, psiMethod.getName(), null, processor, useScope.intersectWith(methodUseScope));
                block0: for (Map.Entry<VirtualFile, Set<JavaFunctionalExpressionIndex.IndexHolder>> entry : holders.entrySet()) {
                    for (JavaFunctionalExpressionIndex.IndexHolder holder : entry.getValue()) {
                        if (!processor.canBeFunctional(holder)) continue;
                        filesToProcess.add(entry.getKey());
                        continue block0;
                    }
                }
            });
        }
        JavaFunctionalExpressionSearcher.collectFilesWithTypeOccurrencesAndFieldAssignments(aClass, candidateScope, filesToProcess);
        JavaFunctionalExpressionSearcher.searchInFiles(aClass, consumer, filesToProcess, expectedFunExprParamsCount, isVoid);
    }

    @NotNull
    private static Set<Module> getJava8Modules(Project project) {
        boolean projectLevelIsHigh = PsiUtil.getLanguageLevel(project).isAtLeast(LanguageLevel.JDK_1_8);
        com.intellij.util.containers.HashSet<Module> highLevelModules = new com.intellij.util.containers.HashSet<Module>();
        for (Module module : ModuleManager.getInstance(project).getModules()) {
            LanguageLevel level;
            LanguageLevelModuleExtension extension = ModuleRootManager.getInstance(module).getModuleExtension(LanguageLevelModuleExtension.class);
            if (extension == null || ((level = extension.getLanguageLevel()) != null || !projectLevelIsHigh) && (level == null || !level.isAtLeast(LanguageLevel.JDK_1_8))) continue;
            highLevelModules.add(module);
        }
        com.intellij.util.containers.HashSet<Module> hashSet = highLevelModules;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/JavaFunctionalExpressionSearcher", "getJava8Modules"));
        }
        return hashSet;
    }

    private static void searchInFiles(final PsiClass aClass, final Processor<PsiFunctionalExpression> consumer, Set<VirtualFile> filesToProcess, final int expectedFunExprParamsCount, final boolean isVoid) {
        LOG.info("#usage files: " + filesToProcess.size());
        ContainerUtil.process(filesToProcess, new ReadActionProcessor<VirtualFile>(){

            @Override
            public boolean processInReadAction(VirtualFile file) {
                return !file.isValid() || JavaFunctionalExpressionSearcher.processFileWithFunctionalInterfaces(aClass, expectedFunExprParamsCount, isVoid, consumer, file);
            }
        });
    }

    private static Collection<PsiMethod> getCandidateMethodsWithSuitableParams(final PsiClass aClass, final Project project, final GlobalSearchScope useScope, final Set<VirtualFile> candidateFiles, final GlobalSearchScope candidateScope) {
        return ApplicationManager.getApplication().runReadAction(new Computable<Collection<PsiMethod>>(){

            @Override
            public Collection<PsiMethod> compute() {
                if (!aClass.isValid()) {
                    return Collections.emptyList();
                }
                GlobalSearchScope visibleFromCandidates = JavaFunctionalExpressionSearcher.combineResolveScopes(project, candidateFiles);
                HashSet usedMethodNames = ContainerUtilRt.newHashSet();
                FileBasedIndex.getInstance().processAllKeys(JavaFunctionalExpressionIndex.JAVA_FUNCTIONAL_EXPRESSION_INDEX_ID, Processors.cancelableCollectProcessor(usedMethodNames), candidateScope, null);
                LinkedHashSet<PsiMethod> methods = ContainerUtil.newLinkedHashSet();
                Processor<PsiMethod> methodProcessor = method -> {
                    if (usedMethodNames.contains(method.getName())) {
                        methods.add((PsiMethod)method);
                    }
                    return true;
                };
                StubIndexKey<String, PsiMethod> key = JavaMethodParameterTypesIndex.getInstance().getKey();
                StubIndex index = StubIndex.getInstance();
                index.processElements(key, aClass.getName(), project, useScope.intersectWith(visibleFromCandidates), PsiMethod.class, methodProcessor);
                index.processElements(key, "$TYPE_PARAMETER$", project, visibleFromCandidates, PsiMethod.class, methodProcessor);
                LOG.info("#methods: " + methods.size());
                return methods;
            }
        });
    }

    @NotNull
    private static GlobalSearchScope combineResolveScopes(Project project, Set<VirtualFile> candidateFiles) {
        PsiManager psiManager = PsiManager.getInstance(project);
        LinkedHashSet<GlobalSearchScope> resolveScopes = ContainerUtil.newLinkedHashSet(ContainerUtil.mapNotNull(candidateFiles, file -> {
            PsiFile psiFile = file.isValid() ? psiManager.findFile((VirtualFile)file) : null;
            return psiFile == null ? null : psiFile.getResolveScope();
        }));
        GlobalSearchScope globalSearchScope = GlobalSearchScope.union(resolveScopes.toArray(new GlobalSearchScope[resolveScopes.size()]));
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/JavaFunctionalExpressionSearcher", "combineResolveScopes"));
        }
        return globalSearchScope;
    }

    @NotNull
    private static Set<VirtualFile> getFilesWithFunctionalExpressionsScope(Project project, GlobalSearchScope useScope) {
        LinkedHashSet<VirtualFile> files = ContainerUtil.newLinkedHashSet();
        PsiSearchHelperImpl helper = (PsiSearchHelperImpl)PsiSearchHelper.SERVICE.getInstance(project);
        Processor<VirtualFile> processor = Processors.cancelableCollectProcessor(files);
        helper.processFilesWithText(useScope, (short)1, true, "::", processor);
        helper.processFilesWithText(useScope, (short)1, true, "->", processor);
        LinkedHashSet<VirtualFile> linkedHashSet = files;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/JavaFunctionalExpressionSearcher", "getFilesWithFunctionalExpressionsScope"));
        }
        return linkedHashSet;
    }

    @NotNull
    private static GlobalSearchScope convertToGlobalScope(Project project, SearchScope useScope) {
        GlobalSearchScope scope;
        if (useScope instanceof GlobalSearchScope) {
            scope = (GlobalSearchScope)useScope;
        } else if (useScope instanceof LocalSearchScope) {
            com.intellij.util.containers.HashSet<VirtualFile> files = new com.intellij.util.containers.HashSet<VirtualFile>();
            ContainerUtil.addAllNotNull(files, ContainerUtil.map(((LocalSearchScope)useScope).getScope(), element -> PsiUtilCore.getVirtualFile(element)));
            scope = GlobalSearchScope.filesScope(project, files);
        } else {
            scope = new EverythingGlobalScope(project);
        }
        GlobalSearchScope globalSearchScope = scope;
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/JavaFunctionalExpressionSearcher", "convertToGlobalScope"));
        }
        return globalSearchScope;
    }

    private static void collectFilesWithTypeOccurrencesAndFieldAssignments(PsiClass aClass, GlobalSearchScope filesScope, final LinkedHashSet<VirtualFile> usageFiles) {
        LinkedHashSet fields = new LinkedHashSet();
        for (PsiReference reference : ReferencesSearch.search(aClass, filesScope)) {
            ApplicationManager.getApplication().runReadAction(() -> {
                PsiElement element = reference.getElement();
                if (element != null) {
                    PsiElement gParent;
                    ContainerUtil.addIfNotNull(usageFiles, PsiUtilCore.getVirtualFile(element));
                    PsiElement parent = element.getParent();
                    if (parent instanceof PsiTypeElement && (gParent = parent.getParent()) instanceof PsiField && !((PsiField)gParent).hasModifierProperty("private") && !((PsiField)gParent).hasModifierProperty("final")) {
                        fields.add((PsiField)gParent);
                    }
                }
            });
        }
        for (PsiField field : fields) {
            ReferencesSearch.search(field, filesScope).forEach((Processor<PsiReference>)new ReadActionProcessor<PsiReference>(){

                @Override
                public boolean processInReadAction(PsiReference fieldRef) {
                    PsiElement fieldElement = fieldRef.getElement();
                    PsiAssignmentExpression varElementParent = PsiTreeUtil.getParentOfType(fieldElement, PsiAssignmentExpression.class);
                    if (varElementParent != null && PsiTreeUtil.isAncestor(varElementParent.getLExpression(), fieldElement, false)) {
                        ContainerUtil.addIfNotNull(usageFiles, PsiUtilCore.getVirtualFile(fieldElement));
                    }
                    return true;
                }
            });
        }
    }

    private static boolean processFileWithFunctionalInterfaces(final PsiClass aClass, final int expectedParamCount, final boolean isVoid, final Processor<PsiFunctionalExpression> consumer, VirtualFile file) {
        PsiFile psiFile = aClass.getManager().findFile(file);
        if (psiFile != null) {
            final Ref<Boolean> ref = new Ref<Boolean>(true);
            psiFile.accept(new JavaRecursiveElementWalkingVisitor(){

                @Override
                public void visitElement(PsiElement element) {
                    if (!((Boolean)ref.get()).booleanValue()) {
                        return;
                    }
                    super.visitElement(element);
                }

                private void visitFunctionalExpression(PsiFunctionalExpression expression) {
                    PsiType functionalInterfaceType = expression.getFunctionalInterfaceType();
                    if (InheritanceUtil.isInheritorOrSelf(PsiUtil.resolveClassInType(functionalInterfaceType), aClass, true) && !consumer.process(expression)) {
                        ref.set(false);
                    }
                }

                @Override
                public void visitLambdaExpression(PsiLambdaExpression expression) {
                    super.visitLambdaExpression(expression);
                    if (expression.getParameterList().getParametersCount() == expectedParamCount) {
                        PsiElement body;
                        if (isVoid && (body = expression.getBody()) instanceof PsiCodeBlock) {
                            PsiReturnStatement[] statements;
                            for (PsiReturnStatement statement : statements = PsiUtil.findReturnStatements((PsiCodeBlock)body)) {
                                if (statement.getReturnValue() == null) continue;
                                return;
                            }
                        }
                        this.visitFunctionalExpression(expression);
                    }
                }

                @Override
                public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression) {
                    super.visitMethodReferenceExpression(expression);
                    this.visitFunctionalExpression(expression);
                }
            });
            if (!ref.get().booleanValue()) {
                return false;
            }
        }
        return true;
    }

    private static class SuitableFilesProcessor
    implements FileBasedIndex.ValueProcessor<Collection<JavaFunctionalExpressionIndex.IndexHolder>> {
        private final Map<VirtualFile, Set<JavaFunctionalExpressionIndex.IndexHolder>> myHolders;
        private final int myExpectedFunExprParamsCount;
        private final int myParametersCount;
        private final boolean myVarArgs;
        private final PsiParameter[] myParameters;

        public SuitableFilesProcessor(Map<VirtualFile, Set<JavaFunctionalExpressionIndex.IndexHolder>> holders, int expectedFunExprParamsCount, int parametersCount, boolean varArgs, PsiParameter[] parameters) {
            this.myHolders = holders;
            this.myExpectedFunExprParamsCount = expectedFunExprParamsCount;
            this.myParametersCount = parametersCount;
            this.myVarArgs = varArgs;
            this.myParameters = parameters;
        }

        @Override
        public boolean process(VirtualFile file, Collection<JavaFunctionalExpressionIndex.IndexHolder> holders) {
            Set<JavaFunctionalExpressionIndex.IndexHolder> savedHolders = this.myHolders.get(file);
            for (JavaFunctionalExpressionIndex.IndexHolder holder : holders) {
                boolean suitableParamNumbers;
                int lambdaParamsNumber = holder.getLambdaParamsNumber();
                if (lambdaParamsNumber != this.myExpectedFunExprParamsCount && lambdaParamsNumber != -1) continue;
                if (this.myVarArgs) {
                    suitableParamNumbers = holder.getMethodArgsLength() >= this.myParametersCount - 1;
                } else {
                    boolean bl = suitableParamNumbers = holder.getMethodArgsLength() == this.myParametersCount;
                }
                if (!suitableParamNumbers) continue;
                if (savedHolders == null) {
                    savedHolders = new LinkedHashSet<JavaFunctionalExpressionIndex.IndexHolder>();
                    this.myHolders.put(file, savedHolders);
                }
                savedHolders.add(holder);
                break;
            }
            return true;
        }

        private boolean canBeFunctional(JavaFunctionalExpressionIndex.IndexHolder holder) {
            PsiClass functionalCandidate;
            int paramIdx = holder.getFunctionExpressionIndex();
            PsiType paramType = this.myParameters[paramIdx >= this.myParametersCount ? this.myParametersCount - 1 : paramIdx].getType();
            if (paramType instanceof PsiEllipsisType) {
                paramType = ((PsiEllipsisType)paramType).getComponentType();
            }
            return (functionalCandidate = PsiUtil.resolveClassInClassTypeOnly(paramType)) instanceof PsiTypeParameter || LambdaUtil.isFunctionalClass(functionalCandidate);
        }
    }
}

