/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.ArgumentFixerActionFactory;
import com.intellij.codeInsight.daemon.impl.quickfix.MethodArgumentFix;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WrapLongWithMathToIntExactFix
extends LocalQuickFixAndIntentionActionOnPsiElement
implements HighPriorityAction {
    public static final MyMethodArgumentFixerFactory REGISTAR = new MyMethodArgumentFixerFactory();
    private final PsiType myType;

    public WrapLongWithMathToIntExactFix(PsiType type, @NotNull PsiExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/daemon/impl/quickfix/WrapLongWithMathToIntExactFix", "<init>"));
        }
        super(expression);
        this.myType = type;
    }

    @Override
    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/WrapLongWithMathToIntExactFix", "getText"));
        }
        return string;
    }

    @Override
    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable(value="is null when called from inspection") Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/WrapLongWithMathToIntExactFix", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/quickfix/WrapLongWithMathToIntExactFix", "invoke"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/codeInsight/daemon/impl/quickfix/WrapLongWithMathToIntExactFix", "invoke"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/codeInsight/daemon/impl/quickfix/WrapLongWithMathToIntExactFix", "invoke"));
        }
        startElement.replace(WrapLongWithMathToIntExactFix.getModifiedExpression(startElement));
    }

    @Override
    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/WrapLongWithMathToIntExactFix", "isAvailable"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/quickfix/WrapLongWithMathToIntExactFix", "isAvailable"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/codeInsight/daemon/impl/quickfix/WrapLongWithMathToIntExactFix", "isAvailable"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/codeInsight/daemon/impl/quickfix/WrapLongWithMathToIntExactFix", "isAvailable"));
        }
        return startElement.isValid() && startElement.getManager().isInProject(startElement) && PsiUtil.isLanguageLevel8OrHigher(startElement) && WrapLongWithMathToIntExactFix.areSameTypes(this.myType, PsiType.INT) && WrapLongWithMathToIntExactFix.areSameTypes(((PsiExpression)startElement).getType(), PsiType.LONG);
    }

    private static boolean areSameTypes(@Nullable PsiType type, @NotNull PsiPrimitiveType expected) {
        if (expected == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expected", "com/intellij/codeInsight/daemon/impl/quickfix/WrapLongWithMathToIntExactFix", "areSameTypes"));
        }
        return type != null && type.isValid() && (type.equals(expected) || expected.getBoxedTypeName().equals(type.getCanonicalText(false)));
    }

    @Override
    @Nls
    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("wrap.long.with.math.to.int.text", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/WrapLongWithMathToIntExactFix", "getFamilyName"));
        }
        return string;
    }

    private static PsiElement getModifiedExpression(PsiElement expression) {
        return JavaPsiFacade.getElementFactory(expression.getProject()).createExpressionFromText("java.lang.Math.toIntExact(" + expression.getText() + ")", expression);
    }

    public static class MyMethodArgumentFixerFactory
    extends ArgumentFixerActionFactory {
        @Override
        @Nullable
        protected PsiExpression getModifiedArgument(PsiExpression expression, PsiType toType) throws IncorrectOperationException {
            return WrapLongWithMathToIntExactFix.areSameTypes(toType, PsiType.INT) ? (PsiExpression)WrapLongWithMathToIntExactFix.getModifiedExpression(expression) : null;
        }

        @Override
        public boolean areTypesConvertible(@NotNull PsiType exprType, @NotNull PsiType parameterType, @NotNull PsiElement context) {
            if (exprType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exprType", "com/intellij/codeInsight/daemon/impl/quickfix/WrapLongWithMathToIntExactFix$MyMethodArgumentFixerFactory", "areTypesConvertible"));
            }
            if (parameterType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterType", "com/intellij/codeInsight/daemon/impl/quickfix/WrapLongWithMathToIntExactFix$MyMethodArgumentFixerFactory", "areTypesConvertible"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/daemon/impl/quickfix/WrapLongWithMathToIntExactFix$MyMethodArgumentFixerFactory", "areTypesConvertible"));
            }
            return parameterType.isConvertibleFrom(exprType) || WrapLongWithMathToIntExactFix.areSameTypes(parameterType, PsiType.INT) && WrapLongWithMathToIntExactFix.areSameTypes(exprType, PsiType.LONG);
        }

        @Override
        public MethodArgumentFix createFix(PsiExpressionList list, int i, PsiType toType) {
            return new MyMethodArgumentFix(list, i, toType, this);
        }
    }

    private static class MyMethodArgumentFix
    extends MethodArgumentFix
    implements HighPriorityAction {
        protected MyMethodArgumentFix(@NotNull PsiExpressionList list, int i, @NotNull PsiType toType, @NotNull ArgumentFixerActionFactory fixerActionFactory) {
            if (list == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/codeInsight/daemon/impl/quickfix/WrapLongWithMathToIntExactFix$MyMethodArgumentFix", "<init>"));
            }
            if (toType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toType", "com/intellij/codeInsight/daemon/impl/quickfix/WrapLongWithMathToIntExactFix$MyMethodArgumentFix", "<init>"));
            }
            if (fixerActionFactory == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fixerActionFactory", "com/intellij/codeInsight/daemon/impl/quickfix/WrapLongWithMathToIntExactFix$MyMethodArgumentFix", "<init>"));
            }
            super(list, i, toType, fixerActionFactory);
        }

        @Override
        @Nls
        @NotNull
        public String getText() {
            String string = this.myArgList.getExpressions().length == 1 ? QuickFixBundle.message("wrap.long.with.math.to.int.parameter.single.text", new Object[0]) : QuickFixBundle.message("wrap.long.with.math.to.int.parameter.multiple.text", this.myIndex + 1);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/WrapLongWithMathToIntExactFix$MyMethodArgumentFix", "getText"));
            }
            return string;
        }

        @Override
        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/WrapLongWithMathToIntExactFix$MyMethodArgumentFix", "isAvailable"));
            }
            return PsiUtil.isLanguageLevel8OrHigher(file) && super.isAvailable(project, editor, file);
        }
    }
}

