/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.miscGenerics;

import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GenericsInspectionToolBase
extends BaseJavaBatchLocalInspectionTool
implements CleanupLocalInspectionTool {
    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/miscGenerics/GenericsInspectionToolBase", "buildVisitor"));
        }
        PsiFile file = holder.getFile();
        if (!PsiUtil.isLanguageLevel5OrHigher(file)) {
            PsiElementVisitor psiElementVisitor = new PsiElementVisitor(){};
            if (psiElementVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/miscGenerics/GenericsInspectionToolBase", "buildVisitor"));
            }
            return psiElementVisitor;
        }
        PsiElementVisitor psiElementVisitor = super.buildVisitor(holder, isOnTheFly);
        if (psiElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/miscGenerics/GenericsInspectionToolBase", "buildVisitor"));
        }
        return psiElementVisitor;
    }

    @Override
    public ProblemDescriptor[] checkClass(@NotNull PsiClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInspection/miscGenerics/GenericsInspectionToolBase", "checkClass"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/miscGenerics/GenericsInspectionToolBase", "checkClass"));
        }
        PsiClassInitializer[] initializers = aClass.getInitializers();
        if (initializers.length == 0) {
            return null;
        }
        ArrayList descriptors = new ArrayList();
        for (PsiClassInitializer initializer : initializers) {
            ProblemDescriptor[] localDescriptions = this.getDescriptions(initializer, manager, isOnTheFly);
            if (localDescriptions == null) continue;
            ContainerUtil.addAll(descriptors, localDescriptions);
        }
        if (descriptors.isEmpty()) {
            return null;
        }
        return descriptors.toArray(new ProblemDescriptor[descriptors.size()]);
    }

    @Override
    public ProblemDescriptor[] checkField(@NotNull PsiField field, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/codeInspection/miscGenerics/GenericsInspectionToolBase", "checkField"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/miscGenerics/GenericsInspectionToolBase", "checkField"));
        }
        PsiExpression initializer = field.getInitializer();
        if (initializer != null) {
            return this.getDescriptions(initializer, manager, isOnTheFly);
        }
        if (field instanceof PsiEnumConstant) {
            return this.getDescriptions(field, manager, isOnTheFly);
        }
        return null;
    }

    @Override
    public ProblemDescriptor[] checkMethod(@NotNull PsiMethod psiMethod, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/codeInspection/miscGenerics/GenericsInspectionToolBase", "checkMethod"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/miscGenerics/GenericsInspectionToolBase", "checkMethod"));
        }
        PsiCodeBlock body = psiMethod.getBody();
        if (body != null) {
            return this.getDescriptions(body, manager, isOnTheFly);
        }
        return null;
    }

    @Nullable
    public abstract ProblemDescriptor[] getDescriptions(@NotNull PsiElement var1, @NotNull InspectionManager var2, boolean var3);
}

