/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.javaee.ExternalResourceManager;
import com.intellij.javaee.ExternalResourceManagerEx;
import com.intellij.javaee.UriUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.ex.http.HttpFileSystem;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.actions.validate.ErrorReporter;
import com.intellij.xml.actions.validate.ValidateXmlActionHandler;
import com.intellij.xml.index.XmlNamespaceIndex;
import com.intellij.xml.util.XmlUtil;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlResourceResolver
implements XMLEntityResolver {
    private static final Logger LOG = Logger.getInstance("#com.intellij.xml.util.XmlResourceResolver");
    private final XmlFile myFile;
    private final Project myProject;
    private final Map<String, String> myExternalResourcesMap = new HashMap<String, String>(1);
    private boolean myStopOnUnDeclaredResource;
    @NonNls
    public static final String HONOUR_ALL_SCHEMA_LOCATIONS_PROPERTY_KEY = "idea.xml.honour.all.schema.locations";
    private final ErrorReporter myErrorReporter;

    public XmlResourceResolver(XmlFile _xmlFile, Project _project, ErrorReporter errorReporter) {
        this.myFile = _xmlFile;
        this.myProject = _project;
        this.myErrorReporter = errorReporter;
    }

    public String getPathByPublicId(String baseId) {
        return this.myExternalResourcesMap.get(baseId);
    }

    public String[] getResourcePaths() {
        return this.myExternalResourcesMap.values().toArray(new String[this.myExternalResourcesMap.size()]);
    }

    @Nullable
    public PsiFile resolve(@Nullable String baseSystemId, String _systemId) {
        VirtualFile file;
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: resolveEntity(baseSystemId='" + baseSystemId + "' systemId='" + _systemId + "," + this.toString() + "')");
        }
        if (_systemId == null) {
            return null;
        }
        if (this.myStopOnUnDeclaredResource && ExternalResourceManagerEx.getInstanceEx().isIgnoredResource(_systemId)) {
            throw new IgnoredResourceException();
        }
        int length = XmlUtil.getPrefixLength(_systemId);
        String systemId = _systemId.substring(length);
        Computable<PsiFile> action = () -> {
            XmlFile file;
            String resource;
            XmlTag rootTag;
            PsiFile baseFile = null;
            if (baseSystemId != null) {
                baseFile = this.getBaseFile(baseSystemId);
            }
            if (baseFile == null) {
                baseFile = this.myFile;
            }
            String version = null;
            String tagName = null;
            if (baseFile == this.myFile && (rootTag = this.myFile.getRootTag()) != null) {
                tagName = rootTag.getLocalName();
                version = rootTag.getAttributeValue("version");
            }
            if ((resource = ((ExternalResourceManagerEx)ExternalResourceManager.getInstance()).getUserResource(this.myProject, systemId, version)) != null && (file = XmlUtil.findXmlFile(this.myFile, resource)) != null) {
                return file;
            }
            PsiFile byLocation = XmlResourceResolver.resolveByLocation(this.myFile, systemId);
            if (byLocation != null) {
                return byLocation;
            }
            PsiFile psiFile = ExternalResourceManager.getInstance().getResourceLocation(systemId, baseFile, version);
            if (psiFile == null) {
                psiFile = XmlUtil.findXmlFile(baseFile, systemId);
            }
            if (psiFile == null && (psiFile = XmlNamespaceIndex.guessSchema(systemId, tagName, version, null, this.myFile)) == null) {
                psiFile = XmlNamespaceIndex.guessDtd(systemId, this.myFile);
            }
            if (psiFile == null && baseSystemId != null) {
                String fullUrl = baseSystemId.substring(0, baseSystemId.lastIndexOf(47) + 1) + systemId;
                psiFile = XmlUtil.findXmlFile(baseFile, fullUrl);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("before relative file checking:" + psiFile + "," + systemId + "," + baseSystemId + ")");
            }
            if (psiFile == null && baseSystemId == null) {
                File workingFile = new File("");
                String workingDir = workingFile.getAbsoluteFile().getAbsolutePath().replace(File.separatorChar, '/') + "/";
                String relativePath = StringUtil.replace(systemId, workingDir, "");
                if (relativePath.equals(systemId)) {
                    relativePath = systemId.substring(systemId.lastIndexOf(47) + 1);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("next to relative file checking:" + relativePath + "," + this.myExternalResourcesMap.size() + ")");
                }
                for (String path : this.getResourcePaths()) {
                    VirtualFile file2;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Finding file by url:" + path);
                    }
                    if ((file2 = VirtualFileManager.getInstance().findFileByUrl(path)) == null) continue;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Finding " + relativePath + " relative to:" + file2.getPath());
                    }
                    VirtualFile relativeFile = UriUtil.findRelativeFile(relativePath, file2);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Found " + (relativeFile != null ? relativeFile.getPath() : "null"));
                    }
                    if (relativeFile != null && (psiFile = PsiManager.getInstance(this.myProject).findFile(relativeFile)) != null) break;
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("resolveEntity: psiFile='" + (psiFile != null ? psiFile.getVirtualFile() : null) + "'");
            }
            return psiFile;
        };
        PsiFile psiFile = ApplicationManager.getApplication().runReadAction(action);
        if (psiFile != null && (file = psiFile.getVirtualFile()) != null) {
            String url = file.getUrl();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding external resource ref:" + systemId + "," + url + "," + this.toString());
            }
            this.myExternalResourcesMap.put(systemId, url);
        }
        return psiFile;
    }

    private PsiFile getBaseFile(String baseSystemId) {
        PsiFile baseFile = this.resolve(null, baseSystemId);
        if (baseFile != null) {
            return baseFile;
        }
        File workingFile = new File("");
        String workingDir = workingFile.getAbsoluteFile().getAbsolutePath().replace(File.separatorChar, '/');
        String id = StringUtil.replace(baseSystemId, workingDir, this.myFile.getVirtualFile().getParent().getPath());
        VirtualFile vFile = UriUtil.findRelative(id, this.myFile);
        if (vFile == null) {
            vFile = UriUtil.findRelative(baseSystemId, this.myFile);
        }
        if (vFile == null) {
            try {
                vFile = VirtualFileManager.getInstance().findFileByUrl(VfsUtilCore.convertFromUrl(new URL(baseSystemId)));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (vFile != null && !vFile.isDirectory() && !(vFile.getFileSystem() instanceof HttpFileSystem)) {
            baseFile = PsiManager.getInstance(this.myProject).findFile(vFile);
        }
        return baseFile;
    }

    @Nullable
    public XMLInputSource resolveEntity(XMLResourceIdentifier xmlResourceIdentifier) throws XNIException, IOException {
        VirtualFile virtualFile;
        XMLInputSource source;
        PsiFile psiFile;
        String publicId;
        String string = publicId = xmlResourceIdentifier.getLiteralSystemId() != null ? xmlResourceIdentifier.getLiteralSystemId() : xmlResourceIdentifier.getNamespace();
        if (publicId != null) {
            try {
                String userDir = new File(System.getProperty("user.dir")).toURI().getPath();
                String publicIdPath = new URI(publicId).getPath();
                if (publicIdPath.startsWith(userDir)) {
                    publicId = publicIdPath.substring(publicIdPath.indexOf(userDir) + userDir.length());
                }
            }
            catch (Exception userDir) {
                // empty catch block
            }
        }
        if ((psiFile = this.resolve(xmlResourceIdentifier.getBaseSystemId(), publicId)) == null && xmlResourceIdentifier.getBaseSystemId() != null) {
            psiFile = ExternalResourceManager.getInstance().getResourceLocation(xmlResourceIdentifier.getBaseSystemId(), this.myFile, null);
        }
        if (psiFile == null && xmlResourceIdentifier.getLiteralSystemId() != null && xmlResourceIdentifier.getNamespace() != null) {
            publicId = xmlResourceIdentifier.getNamespace();
            psiFile = this.resolve(xmlResourceIdentifier.getBaseSystemId(), publicId);
        }
        if (psiFile == null) {
            if (publicId != null && publicId.contains(":/")) {
                try {
                    this.myErrorReporter.processError(new SAXParseException(XmlErrorMessages.message("xml.validate.external.resource.is.not.registered", publicId), publicId, null, 0, 0), ValidateXmlActionHandler.ProblemType.ERROR);
                }
                catch (SAXException publicIdPath) {
                    // empty catch block
                }
                source = new XMLInputSource(xmlResourceIdentifier);
                source.setPublicId(publicId);
                source.setCharacterStream((Reader)new StringReader(""));
                return source;
            }
            return null;
        }
        source = new XMLInputSource(xmlResourceIdentifier);
        if (xmlResourceIdentifier.getLiteralSystemId() == null && (virtualFile = psiFile.getVirtualFile()) != null) {
            String url = VfsUtilCore.fixIDEAUrl(virtualFile.getUrl());
            source.setBaseSystemId(url);
            source.setSystemId(url);
        }
        source.setPublicId(publicId);
        source.setCharacterStream((Reader)new StringReader(psiFile.getText()));
        return source;
    }

    private static PsiFile resolveByLocation(PsiFile baseFile, String location) {
        XmlAttributeValue element;
        XmlAttribute attribute;
        XmlTag tag;
        if (baseFile instanceof XmlFile && (tag = ((XmlFile)baseFile).getRootTag()) != null && (attribute = tag.getAttribute("schemaLocation", "http://www.w3.org/2001/XMLSchema-instance")) != null && (element = attribute.getValueElement()) != null) {
            PsiReference[] references;
            for (PsiReference reference : references = element.getReferences()) {
                if (!location.equals(reference.getCanonicalText())) continue;
                PsiElement resolve = reference.resolve();
                return resolve instanceof PsiFile ? (PsiFile)resolve : null;
            }
        }
        return null;
    }

    public void setStopOnUnDeclaredResource(boolean stopOnUnDeclaredResource) {
        this.myStopOnUnDeclaredResource = stopOnUnDeclaredResource;
    }

    public static class IgnoredResourceException
    extends RuntimeException {
    }
}

