/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ReplaceAssignmentFromVoidWithStatementIntentionAction
implements IntentionAction {
    private final PsiElement myParent;
    private final PsiExpression myLExpr;

    public ReplaceAssignmentFromVoidWithStatementIntentionAction(PsiElement parent, PsiExpression lExpr) {
        this.myParent = parent;
        this.myLExpr = lExpr;
    }

    @Override
    @Nls
    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/ReplaceAssignmentFromVoidWithStatementIntentionAction", "getText"));
        }
        return string;
    }

    @Override
    @Nls
    @NotNull
    public String getFamilyName() {
        if ("Remove left side of assignment" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/ReplaceAssignmentFromVoidWithStatementIntentionAction", "getFamilyName"));
        }
        return "Remove left side of assignment";
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/ReplaceAssignmentFromVoidWithStatementIntentionAction", "isAvailable"));
        }
        return true;
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/ReplaceAssignmentFromVoidWithStatementIntentionAction", "invoke"));
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        this.myParent.replace(this.myLExpr);
    }

    @Override
    public boolean startInWriteAction() {
        return true;
    }
}

