/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.style;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ComparisonUtils;
import org.jetbrains.annotations.NotNull;

public class ChainedEqualityInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getID() {
        if ("ChainedEqualityComparisons" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/ChainedEqualityInspection", "getID"));
        }
        return "ChainedEqualityComparisons";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("chained.equality.comparisons.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/ChainedEqualityInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("chained.equality.comparisons.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/style/ChainedEqualityInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ChainedEqualityVisitor();
    }

    private static class ChainedEqualityVisitor
    extends BaseInspectionVisitor {
        private ChainedEqualityVisitor() {
        }

        @Override
        public void visitPolyadicExpression(PsiPolyadicExpression expression) {
            super.visitPolyadicExpression(expression);
            if (!ComparisonUtils.isEqualityComparison(expression)) {
                return;
            }
            PsiElement parent = expression.getParent();
            if (parent instanceof PsiExpression && ComparisonUtils.isEqualityComparison((PsiExpression)parent)) {
                return;
            }
            PsiExpression[] operands = expression.getOperands();
            if (operands.length >= 3) {
                this.registerError((PsiElement)expression, new Object[0]);
            } else {
                for (PsiExpression operand : operands) {
                    if (!ComparisonUtils.isEqualityComparison(operand)) continue;
                    this.registerError((PsiElement)expression, new Object[0]);
                    break;
                }
            }
        }
    }
}

