/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView;

import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.navigation.ColoredItemPresentation;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationWithSeparator;
import com.intellij.navigation.LocationPresentation;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.FontUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.update.ComparableObject;
import com.intellij.util.ui.update.ComparableObjectCheck;
import java.awt.Color;
import java.awt.Font;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PresentationData
implements ColoredItemPresentation,
ComparableObject,
LocationPresentation {
    protected final List<PresentableNodeDescriptor.ColoredFragment> myColoredText = ContainerUtil.createLockFreeCopyOnWriteList();
    private Icon myIcon;
    private String myLocationString;
    private String myPresentableText;
    private String myTooltip;
    private TextAttributesKey myAttributesKey;
    private Color myForcedTextForeground;
    private Font myFont;
    private boolean mySeparatorAbove = false;
    private boolean myChanged;
    private String myLocationPrefix;
    private String myLocationSuffix;

    public PresentationData(String presentableText, String locationString, Icon icon, @Nullable TextAttributesKey attributesKey) {
        this.myIcon = icon;
        this.myLocationString = locationString;
        this.myPresentableText = presentableText;
        this.myAttributesKey = attributesKey;
    }

    public PresentationData(String presentableText, String locationString, Icon openIcon, Icon closedIcon, @Nullable TextAttributesKey attributesKey) {
        this(presentableText, locationString, closedIcon, attributesKey);
    }

    public PresentationData() {
    }

    @Override
    public Icon getIcon(boolean open) {
        return this.myIcon;
    }

    @Nullable
    public Color getForcedTextForeground() {
        return this.myForcedTextForeground;
    }

    public void setForcedTextForeground(@Nullable Color forcedTextForeground) {
        this.myForcedTextForeground = forcedTextForeground;
    }

    @Override
    public String getLocationString() {
        return this.myLocationString;
    }

    @Override
    public String getPresentableText() {
        return this.myPresentableText;
    }

    public void setIcon(Icon icon) {
        this.myIcon = icon;
    }

    public void setLocationString(String locationString) {
        this.myLocationString = locationString;
    }

    public void setPresentableText(String presentableText) {
        this.myPresentableText = presentableText;
    }

    public void setClosedIcon(Icon closedIcon) {
        this.setIcon(closedIcon);
    }

    @Deprecated
    public void setOpenIcon(Icon openIcon) {
    }

    public void setIcons(Icon icon) {
        this.setIcon(icon);
    }

    public void updateFrom(ItemPresentation presentation) {
        this.setIcon(presentation.getIcon(false));
        this.setPresentableText(presentation.getPresentableText());
        this.setLocationString(presentation.getLocationString());
        if (presentation instanceof ColoredItemPresentation) {
            this.setAttributesKey(((ColoredItemPresentation)presentation).getTextAttributesKey());
        }
        this.setSeparatorAbove(presentation instanceof ItemPresentationWithSeparator);
        if (presentation instanceof LocationPresentation) {
            this.myLocationPrefix = ((LocationPresentation)((Object)presentation)).getLocationPrefix();
            this.myLocationSuffix = ((LocationPresentation)((Object)presentation)).getLocationSuffix();
        }
    }

    public boolean hasSeparatorAbove() {
        return this.mySeparatorAbove;
    }

    public void setSeparatorAbove(boolean b) {
        this.mySeparatorAbove = b;
    }

    @Override
    public TextAttributesKey getTextAttributesKey() {
        return this.myAttributesKey;
    }

    public void setAttributesKey(TextAttributesKey attributesKey) {
        this.myAttributesKey = attributesKey;
    }

    public String getTooltip() {
        return this.myTooltip;
    }

    public void setTooltip(@Nullable String tooltip) {
        this.myTooltip = tooltip;
    }

    public boolean isChanged() {
        return this.myChanged;
    }

    public void setChanged(boolean changed) {
        this.myChanged = changed;
    }

    @NotNull
    public List<PresentableNodeDescriptor.ColoredFragment> getColoredText() {
        List<PresentableNodeDescriptor.ColoredFragment> list = this.myColoredText;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/PresentationData", "getColoredText"));
        }
        return list;
    }

    public void addText(PresentableNodeDescriptor.ColoredFragment coloredFragment) {
        this.myColoredText.add(coloredFragment);
    }

    public void addText(String text, SimpleTextAttributes attributes) {
        this.myColoredText.add(new PresentableNodeDescriptor.ColoredFragment(text, attributes));
    }

    public void clearText() {
        this.myColoredText.clear();
    }

    public void clear() {
        this.myIcon = null;
        this.clearText();
        this.myAttributesKey = null;
        this.myFont = null;
        this.myForcedTextForeground = null;
        this.myLocationString = null;
        this.myPresentableText = null;
        this.myTooltip = null;
        this.myChanged = false;
        this.mySeparatorAbove = false;
        this.myLocationSuffix = null;
        this.myLocationPrefix = null;
    }

    @Override
    @NotNull
    public Object[] getEqualityObjects() {
        Object[] objectArray = new Object[]{this.myIcon, this.myColoredText, this.myAttributesKey, this.myFont, this.myForcedTextForeground, this.myPresentableText, this.myLocationString, this.mySeparatorAbove, this.myLocationPrefix, this.myLocationSuffix};
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/PresentationData", "getEqualityObjects"));
        }
        return objectArray;
    }

    public int hashCode() {
        return ComparableObjectCheck.hashCode(this, super.hashCode());
    }

    public boolean equals(Object obj) {
        return ComparableObjectCheck.equals(this, obj);
    }

    public void copyFrom(PresentationData from) {
        if (from == this) {
            return;
        }
        this.myAttributesKey = from.myAttributesKey;
        this.myIcon = from.myIcon;
        this.clearText();
        this.myColoredText.addAll(from.myColoredText);
        this.myFont = from.myFont;
        this.myForcedTextForeground = from.myForcedTextForeground;
        this.myLocationString = from.myLocationString;
        this.myPresentableText = from.myPresentableText;
        this.myTooltip = from.myTooltip;
        this.mySeparatorAbove = from.mySeparatorAbove;
        this.myLocationPrefix = from.myLocationPrefix;
        this.myLocationSuffix = from.myLocationSuffix;
    }

    public PresentationData clone() {
        PresentationData clone = new PresentationData();
        clone.copyFrom(this);
        return clone;
    }

    public void applyFrom(PresentationData from) {
        this.myAttributesKey = PresentationData.getValue(this.myAttributesKey, from.myAttributesKey);
        this.myIcon = PresentationData.getValue(this.myIcon, from.myIcon);
        if (this.myColoredText.isEmpty()) {
            this.myColoredText.addAll(from.myColoredText);
        }
        this.myFont = PresentationData.getValue(this.myFont, from.myFont);
        this.myForcedTextForeground = PresentationData.getValue(this.myForcedTextForeground, from.myForcedTextForeground);
        this.myLocationString = PresentationData.getValue(this.myLocationString, from.myLocationString);
        this.myPresentableText = PresentationData.getValue(this.myPresentableText, from.myPresentableText);
        this.myTooltip = PresentationData.getValue(this.myTooltip, from.myTooltip);
        this.mySeparatorAbove = this.mySeparatorAbove || from.mySeparatorAbove;
        this.myLocationPrefix = PresentationData.getValue(this.myLocationPrefix, from.myLocationPrefix);
        this.myLocationSuffix = PresentationData.getValue(this.myLocationSuffix, from.myLocationSuffix);
    }

    private static <T> T getValue(T ownValue, T fromValue) {
        return ownValue != null ? ownValue : fromValue;
    }

    @Override
    public String getLocationPrefix() {
        return this.myLocationPrefix == null ? FontUtil.spaceAndThinSpace() : this.myLocationPrefix;
    }

    @Override
    public String getLocationSuffix() {
        return StringUtil.notNullize(this.myLocationSuffix, "");
    }
}

