/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.quickfix.QuickFixAction;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.source.resolve.DefaultParameterTypeInferencePolicy;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeTypeArgumentsFix
implements IntentionAction,
HighPriorityAction {
    private static final Logger LOG = Logger.getInstance("#" + ChangeTypeArgumentsFix.class.getName());
    private final PsiMethod myTargetMethod;
    private final PsiClass myPsiClass;
    private final PsiExpression[] myExpressions;
    private final PsiNewExpression myNewExpression;

    ChangeTypeArgumentsFix(@NotNull PsiMethod targetMethod, PsiClass psiClass, @NotNull PsiExpression[] expressions, @NotNull PsiElement context) {
        if (targetMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetMethod", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeTypeArgumentsFix", "<init>"));
        }
        if (expressions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressions", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeTypeArgumentsFix", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeTypeArgumentsFix", "<init>"));
        }
        this.myTargetMethod = targetMethod;
        this.myPsiClass = psiClass;
        this.myExpressions = expressions;
        this.myNewExpression = PsiTreeUtil.getParentOfType(context, PsiNewExpression.class);
    }

    @Override
    @NotNull
    public String getText() {
        PsiSubstitutor substitutor = this.inferTypeArguments();
        String string = "Change type arguments to <" + StringUtil.join(this.myPsiClass.getTypeParameters(), typeParameter -> {
            PsiType substituted = substitutor.substitute((PsiTypeParameter)typeParameter);
            return substituted != null ? substituted.getPresentableText() : "java.lang.Object";
        }, ", ") + ">";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeTypeArgumentsFix", "getText"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        if ("Change type arguments" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeTypeArgumentsFix", "getFamilyName"));
        }
        return "Change type arguments";
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        PsiReferenceParameterList parameterList;
        PsiJavaCodeReferenceElement reference;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeTypeArgumentsFix", "isAvailable"));
        }
        PsiTypeParameter[] typeParameters = this.myPsiClass.getTypeParameters();
        if (typeParameters.length > 0 && this.myNewExpression != null && this.myNewExpression.isValid() && this.myNewExpression.getArgumentList() != null && (reference = this.myNewExpression.getClassOrAnonymousClassReference()) != null && (parameterList = reference.getParameterList()) != null) {
            PsiSubstitutor substitutor = this.inferTypeArguments();
            PsiParameter[] parameters = this.myTargetMethod.getParameterList().getParameters();
            if (parameters.length != this.myExpressions.length) {
                return false;
            }
            int length = parameters.length;
            for (int i = 0; i < length; ++i) {
                PsiParameter parameter = parameters[i];
                PsiType expectedType = substitutor.substitute(parameter.getType());
                if (!this.myExpressions[i].isValid()) {
                    return false;
                }
                PsiType actualType = this.myExpressions[i].getType();
                if (expectedType != null && actualType != null && TypeConversionUtil.isAssignable(expectedType, actualType)) continue;
                return false;
            }
            for (PsiTypeParameter parameter : typeParameters) {
                if (substitutor.substitute(parameter) != null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeTypeArgumentsFix", "invoke"));
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        PsiTypeParameter[] typeParameters = this.myPsiClass.getTypeParameters();
        PsiSubstitutor psiSubstitutor = this.inferTypeArguments();
        PsiJavaCodeReferenceElement reference = this.myNewExpression.getClassOrAnonymousClassReference();
        LOG.assertTrue(reference != null, this.myNewExpression);
        PsiReferenceParameterList parameterList = reference.getParameterList();
        LOG.assertTrue(parameterList != null, this.myNewExpression);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory(project);
        PsiTypeElement[] elements = parameterList.getTypeParameterElements();
        for (int i = elements.length - 1; i >= 0; --i) {
            PsiType typeArg = ObjectUtils.assertNotNull(psiSubstitutor.substitute(typeParameters[i]));
            PsiElement replaced = elements[i].replace(factory.createTypeElement(typeArg));
            JavaCodeStyleManager.getInstance(file.getProject()).shortenClassReferences(replaced);
        }
    }

    private PsiSubstitutor inferTypeArguments() {
        JavaPsiFacade facade = JavaPsiFacade.getInstance(this.myNewExpression.getProject());
        PsiResolveHelper resolveHelper = facade.getResolveHelper();
        PsiParameter[] parameters = this.myTargetMethod.getParameterList().getParameters();
        PsiExpressionList argumentList = this.myNewExpression.getArgumentList();
        LOG.assertTrue(argumentList != null);
        PsiExpression[] expressions = argumentList.getExpressions();
        return resolveHelper.inferTypeArguments(this.myPsiClass.getTypeParameters(), parameters, expressions, PsiSubstitutor.EMPTY, this.myNewExpression.getParent(), DefaultParameterTypeInferencePolicy.INSTANCE);
    }

    public static void registerIntentions(@NotNull JavaResolveResult[] candidates, @NotNull PsiExpressionList list, @Nullable HighlightInfo highlightInfo, PsiClass psiClass) {
        if (candidates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidates", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeTypeArgumentsFix", "registerIntentions"));
        }
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeTypeArgumentsFix", "registerIntentions"));
        }
        if (candidates.length == 0) {
            return;
        }
        PsiExpression[] expressions = list.getExpressions();
        for (JavaResolveResult candidate : candidates) {
            ChangeTypeArgumentsFix.registerIntention(expressions, highlightInfo, psiClass, candidate, list);
        }
    }

    private static void registerIntention(@NotNull PsiExpression[] expressions, @Nullable HighlightInfo highlightInfo, PsiClass psiClass, @NotNull JavaResolveResult candidate, @NotNull PsiElement context) {
        if (expressions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expressions", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeTypeArgumentsFix", "registerIntention"));
        }
        if (candidate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeTypeArgumentsFix", "registerIntention"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/daemon/impl/quickfix/ChangeTypeArgumentsFix", "registerIntention"));
        }
        if (!candidate.isStaticsScopeCorrect()) {
            return;
        }
        PsiMethod method = (PsiMethod)candidate.getElement();
        if (method != null && context.getManager().isInProject(method)) {
            ChangeTypeArgumentsFix fix = new ChangeTypeArgumentsFix(method, psiClass, expressions, context);
            QuickFixAction.registerQuickFixAction(highlightInfo, null, fix);
        }
    }

    @Override
    public boolean startInWriteAction() {
        return true;
    }
}

