/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CachedSingletonsRegistry;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.WrappedProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.ThrowableComputable;
import gnu.trove.THashSet;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProgressManager
extends ProgressIndicatorProvider {
    private static ProgressManager ourInstance = CachedSingletonsRegistry.markCachedField(ProgressManager.class);

    @NotNull
    public static ProgressManager getInstance() {
        ProgressManager result = ourInstance;
        if (result == null) {
            result = ServiceManager.getService(ProgressManager.class);
            if (result == null) {
                throw new AssertionError((Object)("ProgressManager is null; " + ApplicationManager.getApplication()));
            }
            ourInstance = result;
        }
        ProgressManager progressManager = result;
        if (progressManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/ProgressManager", "getInstance"));
        }
        return progressManager;
    }

    public abstract boolean hasProgressIndicator();

    public abstract boolean hasModalProgressIndicator();

    public abstract boolean hasUnsafeProgressIndicator();

    public abstract void runProcess(@NotNull Runnable var1, ProgressIndicator var2) throws ProcessCanceledException;

    public abstract <T> T runProcess(@NotNull Computable<T> var1, ProgressIndicator var2) throws ProcessCanceledException;

    @Override
    public ProgressIndicator getProgressIndicator() {
        return null;
    }

    public static void progress(@NotNull String text) throws ProcessCanceledException {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/progress/ProgressManager", "progress"));
        }
        ProgressManager.progress(text, "");
    }

    public static void progress2(@NotNull String text) throws ProcessCanceledException {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/progress/ProgressManager", "progress2"));
        }
        ProgressIndicator pi = ProgressManager.getInstance().getProgressIndicator();
        if (pi != null) {
            pi.checkCanceled();
            pi.setText2(text);
        }
    }

    public static void progress(@NotNull String text, @Nullable String text2) throws ProcessCanceledException {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/progress/ProgressManager", "progress"));
        }
        ProgressIndicator pi = ProgressManager.getInstance().getProgressIndicator();
        if (pi != null) {
            pi.checkCanceled();
            pi.setText(text);
            pi.setText2(text2 == null ? "" : text2);
        }
    }

    public abstract void executeNonCancelableSection(@NotNull Runnable var1);

    public abstract void setCancelButtonText(String var1);

    public abstract boolean runProcessWithProgressSynchronously(@NotNull Runnable var1, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String var2, boolean var3, @Nullable Project var4);

    public abstract <T, E extends Exception> T runProcessWithProgressSynchronously(@NotNull ThrowableComputable<T, E> var1, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String var2, boolean var3, @Nullable Project var4) throws E;

    public abstract boolean runProcessWithProgressSynchronously(@NotNull Runnable var1, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String var2, boolean var3, @Nullable Project var4, @Nullable JComponent var5);

    public abstract void runProcessWithProgressAsynchronously(@NotNull Project var1, @NotNull @Nls String var2, @NotNull Runnable var3, @Nullable Runnable var4, @Nullable Runnable var5);

    public abstract void runProcessWithProgressAsynchronously(@NotNull Project var1, @NotNull @Nls String var2, @NotNull Runnable var3, @Nullable Runnable var4, @Nullable Runnable var5, @NotNull PerformInBackgroundOption var6);

    public abstract void run(@NotNull Task var1);

    public <T, E extends Exception> T run(@NotNull Task.WithResult<T, E> task) throws E {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/progress/ProgressManager", "run"));
        }
        this.run((Task)task);
        return task.getResult();
    }

    public abstract void runProcessWithProgressAsynchronously(@NotNull Task.Backgroundable var1, @NotNull ProgressIndicator var2);

    protected void indicatorCanceled(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/progress/ProgressManager", "indicatorCanceled"));
        }
    }

    public static void canceled(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/progress/ProgressManager", "canceled"));
        }
        ProgressManager.getInstance().indicatorCanceled(indicator);
    }

    public static void checkCanceled() throws ProcessCanceledException {
        ProgressManager.getInstance().doCheckCanceled();
    }

    public abstract void executeProcessUnderProgress(@NotNull Runnable var1, @Nullable ProgressIndicator var2) throws ProcessCanceledException;

    public static void assertNotCircular(@NotNull ProgressIndicator original) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/intellij/openapi/progress/ProgressManager", "assertNotCircular"));
        }
        Set wrappedParents = null;
        ProgressIndicator i = original;
        while (i instanceof WrappedProgressIndicator) {
            if (wrappedParents == null) {
                wrappedParents = new THashSet();
            }
            if (!wrappedParents.add(i)) {
                throw new IllegalArgumentException(i + " wraps itself");
            }
            i = ((WrappedProgressIndicator)i).getOriginalProgressIndicator();
        }
    }
}

