/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference.constraints;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceBound;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.SubtypingConstraint;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.util.HashSet;
import java.util.List;

public class StrictSubtypingConstraint
implements ConstraintFormula {
    private PsiType myS;
    private PsiType myT;

    public StrictSubtypingConstraint(PsiType t, PsiType s) {
        this.myT = t;
        this.myS = s;
    }

    @Override
    public void apply(PsiSubstitutor substitutor, boolean cache) {
        this.myT = substitutor.substitute(this.myT);
        this.myS = substitutor.substitute(this.myS);
    }

    @Override
    public boolean reduce(InferenceSession session, List<ConstraintFormula> constraints) {
        HashSet<InferenceVariable> dependencies = new HashSet<InferenceVariable>();
        boolean reduceResult = this.doReduce(session, dependencies, constraints);
        if (!reduceResult) {
            session.registerIncompatibleErrorMessage(dependencies, session.getPresentableText(this.myS) + " conforms to " + session.getPresentableText(this.myT));
        }
        return reduceResult;
    }

    private boolean doReduce(InferenceSession session, HashSet<InferenceVariable> dependencies, List<ConstraintFormula> constraints) {
        if (!session.collectDependencies(this.myS, dependencies) && !session.collectDependencies(this.myT, dependencies)) {
            if (this.myT == null) {
                return this.myS == null || this.myS.equalsToText("java.lang.Object");
            }
            if (this.myS == null) {
                return true;
            }
            return TypeConversionUtil.isAssignable(this.myT, this.myS);
        }
        if (PsiType.NULL.equals(this.myT) || this.myT == null) {
            return false;
        }
        if (PsiType.NULL.equals(this.myS) || this.myS == null || this.myT.equalsToText("java.lang.Object")) {
            return true;
        }
        if (PsiType.VOID.equals(this.myS) ^ PsiType.VOID.equals(this.myT)) {
            return false;
        }
        InferenceVariable inferenceVariable = session.getInferenceVariable(this.myS);
        if (inferenceVariable != null) {
            InferenceVariable.addBound(this.myS, this.myT, InferenceBound.UPPER, session);
            return true;
        }
        inferenceVariable = session.getInferenceVariable(this.myT);
        if (inferenceVariable != null) {
            InferenceVariable.addBound(this.myT, this.myS, InferenceBound.LOWER, session);
            return true;
        }
        if (this.myT instanceof PsiArrayType) {
            PsiType upperBound;
            PsiType sType = this.myS;
            if (this.myS instanceof PsiCapturedWildcardType && (upperBound = ((PsiCapturedWildcardType)this.myS).getUpperBound()) instanceof PsiArrayType) {
                sType = upperBound;
            }
            if (!(sType instanceof PsiArrayType)) {
                return false;
            }
            PsiType tComponentType = ((PsiArrayType)this.myT).getComponentType();
            PsiType sComponentType = ((PsiArrayType)sType).getComponentType();
            if (!(tComponentType instanceof PsiPrimitiveType) && !(sComponentType instanceof PsiPrimitiveType)) {
                constraints.add(new StrictSubtypingConstraint(tComponentType, sComponentType));
                return true;
            }
            return sComponentType instanceof PsiPrimitiveType && sComponentType.equals(tComponentType);
        }
        if (this.myT instanceof PsiClassType) {
            PsiClassType.ClassResolveResult TResult = ((PsiClassType)this.myT).resolveGenerics();
            PsiClass CClass = TResult.getElement();
            if (CClass != null) {
                if (CClass instanceof PsiTypeParameter) {
                    PsiType lowerBound;
                    if (this.myS instanceof PsiIntersectionType) {
                        for (PsiType conjunct : ((PsiIntersectionType)this.myS).getConjuncts()) {
                            if (!this.myT.equals(conjunct)) continue;
                            return true;
                        }
                    }
                    if ((lowerBound = InferenceSession.getLowerBound(CClass)) != null) {
                        constraints.add(new StrictSubtypingConstraint(lowerBound, this.myS));
                        return true;
                    }
                    return false;
                }
                PsiClassType sType = null;
                if (this.myS instanceof PsiIntersectionType) {
                    for (PsiType psiType : ((PsiIntersectionType)this.myS).getConjuncts()) {
                        PsiClassType.ClassResolveResult conjunctResult;
                        if (!(psiType instanceof PsiClassType) || !InheritanceUtil.isInheritorOrSelf((conjunctResult = ((PsiClassType)psiType).resolveGenerics()).getElement(), CClass, true)) continue;
                        sType = (PsiClassType)psiType;
                        break;
                    }
                } else if (this.myS instanceof PsiClassType) {
                    sType = (PsiClassType)this.myS;
                } else {
                    PsiType upperBound;
                    if (this.myS instanceof PsiArrayType) {
                        return this.myT.isAssignableFrom(this.myS);
                    }
                    if (this.myS instanceof PsiCapturedWildcardType && (upperBound = ((PsiCapturedWildcardType)this.myS).getUpperBound()) instanceof PsiClassType) {
                        sType = (PsiClassType)upperBound;
                    }
                }
                if (sType == null) {
                    return false;
                }
                PsiClassType.ClassResolveResult SResult = sType.resolveGenerics();
                PsiClass SClass = SResult.getElement();
                if (SClass == null) {
                    return false;
                }
                PsiSubstitutor substitutor = SResult.getSubstitutor();
                for (PsiTypeParameter typeParameter : SClass.getTypeParameters()) {
                    substitutor = substitutor.put(typeParameter, substitutor.substituteWithBoundsPromotion(typeParameter));
                }
                if (((PsiClassType)this.myT).isRaw()) {
                    return InheritanceUtil.isInheritorOrSelf(SClass, CClass, true);
                }
                PsiSubstitutor psiSubstitutor = TResult.getSubstitutor();
                PsiSubstitutor sSubstitutor = TypeConversionUtil.getClassSubstitutor(CClass, SClass, substitutor);
                if (sSubstitutor != null) {
                    for (PsiTypeParameter parameter : CClass.getTypeParameters()) {
                        PsiType sSubstituted;
                        PsiType tSubstituted = psiSubstitutor.substitute(parameter);
                        if (tSubstituted == null ^ (sSubstituted = sSubstitutor.substitute(parameter)) == null) {
                            return false;
                        }
                        constraints.add(new SubtypingConstraint(tSubstituted, sSubstituted));
                    }
                    return true;
                }
            }
            return false;
        }
        if (this.myT instanceof PsiIntersectionType) {
            for (PsiType conjunct : ((PsiIntersectionType)this.myT).getConjuncts()) {
                constraints.add(new StrictSubtypingConstraint(conjunct, this.myS));
            }
            return true;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StrictSubtypingConstraint that = (StrictSubtypingConstraint)o;
        if (this.myS != null ? !this.myS.equals(that.myS) : that.myS != null) {
            return false;
        }
        return !(this.myT != null ? !this.myT.equals(that.myT) : that.myT != null);
    }

    public int hashCode() {
        int result = this.myS != null ? this.myS.hashCode() : 0;
        result = 31 * result + (this.myT != null ? this.myT.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.myT.getPresentableText() + " < " + this.myS.getPresentableText();
    }
}

