/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class GoToSymbolFix
implements IntentionAction {
    private final SmartPsiElementPointer<NavigatablePsiElement> myPointer;
    private final String myMessage;

    public GoToSymbolFix(@NotNull NavigatablePsiElement symbol, @NotNull @Nls String message) {
        if (symbol == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "com/intellij/codeInsight/daemon/impl/quickfix/GoToSymbolFix", "<init>"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/codeInsight/daemon/impl/quickfix/GoToSymbolFix", "<init>"));
        }
        this.myPointer = SmartPointerManager.getInstance(symbol.getProject()).createSmartPsiElementPointer(symbol);
        this.myMessage = message;
    }

    @Override
    @Nls
    @NotNull
    public String getText() {
        String string = this.myMessage;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/GoToSymbolFix", "getText"));
        }
        return string;
    }

    @Override
    @Nls
    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/GoToSymbolFix", "getFamilyName"));
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/GoToSymbolFix", "isAvailable"));
        }
        return this.myPointer.getElement() != null;
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/GoToSymbolFix", "invoke"));
        }
        NavigatablePsiElement e = this.myPointer.getElement();
        if (e != null && e.isValid()) {
            e.navigate(true);
        }
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }
}

