/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.openapi.util.TextRange;
import com.intellij.util.text.CharArrayCharSequence;
import com.intellij.util.text.CharArrayExternalizable;
import com.intellij.util.text.CharSequenceBackedByArray;
import com.intellij.util.text.CharSequenceReader;
import com.intellij.util.text.ImmutableCharSequence;
import com.intellij.util.text.ImmutableText;
import com.intellij.util.text.UnsyncCharArrayReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CharArrayUtil {
    private static final int GET_CHARS_THRESHOLD = 10;

    private CharArrayUtil() {
    }

    public static void getChars(@NotNull CharSequence src, @NotNull char[] dst, int dstOffset) {
        if (src == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "src", "com/intellij/util/text/CharArrayUtil", "getChars"));
        }
        if (dst == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dst", "com/intellij/util/text/CharArrayUtil", "getChars"));
        }
        CharArrayUtil.getChars(src, dst, dstOffset, src.length());
    }

    public static void getChars(@NotNull CharSequence src, @NotNull char[] dst, int dstOffset, int len) {
        if (src == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "src", "com/intellij/util/text/CharArrayUtil", "getChars"));
        }
        if (dst == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dst", "com/intellij/util/text/CharArrayUtil", "getChars"));
        }
        CharArrayUtil.getChars(src, dst, 0, dstOffset, len);
    }

    public static void getChars(@NotNull CharSequence src, @NotNull char[] dst, int srcOffset, int dstOffset, int len) {
        if (src == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "src", "com/intellij/util/text/CharArrayUtil", "getChars"));
        }
        if (dst == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dst", "com/intellij/util/text/CharArrayUtil", "getChars"));
        }
        if (src instanceof CharArrayExternalizable) {
            ((CharArrayExternalizable)src).getChars(srcOffset, srcOffset + len, dst, dstOffset);
            return;
        }
        if (len >= 10) {
            if (src instanceof String) {
                ((String)src).getChars(srcOffset, srcOffset + len, dst, dstOffset);
                return;
            }
            if (src instanceof CharBuffer) {
                CharBuffer buffer = (CharBuffer)src;
                int i2 = buffer.position();
                buffer.position(i2 + srcOffset);
                buffer.get(dst, dstOffset, len);
                buffer.position(i2);
                return;
            }
            if (src instanceof CharSequenceBackedByArray) {
                ((CharSequenceBackedByArray)src.subSequence(srcOffset, srcOffset + len)).getChars(dst, dstOffset);
                return;
            }
            if (src instanceof StringBuffer) {
                ((StringBuffer)src).getChars(srcOffset, srcOffset + len, dst, dstOffset);
                return;
            }
            if (src instanceof StringBuilder) {
                ((StringBuilder)src).getChars(srcOffset, srcOffset + len, dst, dstOffset);
                return;
            }
        }
        int i3 = 0;
        int max = srcOffset + len;
        for (int j = srcOffset; j < max && i3 < dst.length; ++i3, ++j) {
            dst[i3 + dstOffset] = src.charAt(j);
        }
    }

    @NotNull
    public static char[] fromSequenceStrict(@NotNull CharSequence seq) {
        if (seq == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "seq", "com/intellij/util/text/CharArrayUtil", "fromSequenceStrict"));
        }
        char[] cArray = CharArrayUtil.fromSequence(seq);
        if (cArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/CharArrayUtil", "fromSequenceStrict"));
        }
        return cArray;
    }

    @Nullable
    public static char[] fromSequenceWithoutCopying(@Nullable CharSequence seq) {
        CharBuffer buffer;
        if (seq instanceof CharSequenceBackedByArray) {
            return ((CharSequenceBackedByArray)seq).getChars();
        }
        if (seq instanceof CharBuffer && (buffer = (CharBuffer)seq).hasArray() && !buffer.isReadOnly() && buffer.arrayOffset() == 0 && buffer.position() == 0) {
            return buffer.array();
        }
        return null;
    }

    @NotNull
    public static char[] fromSequence(@NotNull CharSequence seq) {
        if (seq == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "seq", "com/intellij/util/text/CharArrayUtil", "fromSequence"));
        }
        char[] underlying = CharArrayUtil.fromSequenceWithoutCopying(seq);
        char[] cArray = underlying != null ? Arrays.copyOf(underlying, underlying.length) : CharArrayUtil.fromSequence(seq, 0, seq.length());
        if (cArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/CharArrayUtil", "fromSequence"));
        }
        return cArray;
    }

    @NotNull
    public static char[] fromSequence(@NotNull CharSequence seq, int start, int end) {
        if (seq == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "seq", "com/intellij/util/text/CharArrayUtil", "fromSequence"));
        }
        char[] result = new char[end - start];
        CharArrayUtil.getChars(seq, result, start, 0, end - start);
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/CharArrayUtil", "fromSequence"));
        }
        return result;
    }

    public static int shiftForward(@NotNull CharSequence buffer, int offset, @NotNull String chars) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/util/text/CharArrayUtil", "shiftForward"));
        }
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/util/text/CharArrayUtil", "shiftForward"));
        }
        return CharArrayUtil.shiftForward(buffer, offset, buffer.length(), chars);
    }

    public static int shiftForward(@NotNull CharSequence buffer, int startOffset, int endOffset, @NotNull String chars) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/util/text/CharArrayUtil", "shiftForward"));
        }
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/util/text/CharArrayUtil", "shiftForward"));
        }
        int limit = Math.min(endOffset, buffer.length());
        for (int offset = startOffset; offset < limit; ++offset) {
            int i2;
            char c = buffer.charAt(offset);
            for (i2 = 0; i2 < chars.length() && c != chars.charAt(i2); ++i2) {
            }
            if (i2 < chars.length()) continue;
            return offset;
        }
        return endOffset;
    }

    public static int shiftForwardCarefully(@NotNull CharSequence buffer, int offset, @NotNull String chars) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/util/text/CharArrayUtil", "shiftForwardCarefully"));
        }
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/util/text/CharArrayUtil", "shiftForwardCarefully"));
        }
        if (offset + 1 >= buffer.length()) {
            return offset;
        }
        if (!CharArrayUtil.isSuitable(chars, buffer.charAt(offset))) {
            return offset;
        }
        ++offset;
        while (offset < buffer.length()) {
            char c = buffer.charAt(offset);
            if (!CharArrayUtil.isSuitable(chars, c)) {
                return offset - 1;
            }
            ++offset;
        }
        return offset - 1;
    }

    private static boolean isSuitable(@NotNull String chars, char c) {
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/util/text/CharArrayUtil", "isSuitable"));
        }
        for (int i2 = 0; i2 < chars.length(); ++i2) {
            if (c != chars.charAt(i2)) continue;
            return true;
        }
        return false;
    }

    public static int shiftForward(@NotNull char[] buffer, int offset, @NotNull String chars) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/util/text/CharArrayUtil", "shiftForward"));
        }
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/util/text/CharArrayUtil", "shiftForward"));
        }
        return CharArrayUtil.shiftForward(new CharArrayCharSequence(buffer), offset, chars);
    }

    public static int shiftBackward(@NotNull CharSequence buffer, int offset, @NotNull String chars) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/util/text/CharArrayUtil", "shiftBackward"));
        }
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/util/text/CharArrayUtil", "shiftBackward"));
        }
        return CharArrayUtil.shiftBackward(buffer, 0, offset, chars);
    }

    public static int shiftBackward(@NotNull CharSequence buffer, int minOffset, int maxOffset, @NotNull String chars) {
        int offset;
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/util/text/CharArrayUtil", "shiftBackward"));
        }
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/util/text/CharArrayUtil", "shiftBackward"));
        }
        if (maxOffset >= buffer.length()) {
            return maxOffset;
        }
        for (offset = maxOffset; offset >= minOffset; --offset) {
            int i2;
            char c = buffer.charAt(offset);
            for (i2 = 0; i2 < chars.length() && c != chars.charAt(i2); ++i2) {
            }
            if (i2 == chars.length()) break;
        }
        return offset;
    }

    public static int shiftBackward(@NotNull char[] buffer, int offset, @NotNull String chars) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/util/text/CharArrayUtil", "shiftBackward"));
        }
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/util/text/CharArrayUtil", "shiftBackward"));
        }
        return CharArrayUtil.shiftBackward(new CharArrayCharSequence(buffer), offset, chars);
    }

    public static int shiftForwardUntil(@NotNull CharSequence buffer, int offset, @NotNull String chars) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/util/text/CharArrayUtil", "shiftForwardUntil"));
        }
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/util/text/CharArrayUtil", "shiftForwardUntil"));
        }
        while (offset < buffer.length()) {
            int i2;
            char c = buffer.charAt(offset);
            for (i2 = 0; i2 < chars.length() && c != chars.charAt(i2); ++i2) {
            }
            if (i2 < chars.length()) break;
            ++offset;
        }
        return offset;
    }

    public static int shiftBackwardUntil(@NotNull CharSequence buffer, int offset, @NotNull String chars) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/util/text/CharArrayUtil", "shiftBackwardUntil"));
        }
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/util/text/CharArrayUtil", "shiftBackwardUntil"));
        }
        if (offset >= buffer.length()) {
            return offset;
        }
        while (offset >= 0) {
            int i2;
            char c = buffer.charAt(offset);
            for (i2 = 0; i2 < chars.length() && c != chars.charAt(i2); ++i2) {
            }
            if (i2 < chars.length()) break;
            --offset;
        }
        return offset;
    }

    public static boolean regionMatches(@NotNull char[] buffer, int start, int end, @NotNull CharSequence s) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/util/text/CharArrayUtil", "regionMatches"));
        }
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/util/text/CharArrayUtil", "regionMatches"));
        }
        int len = s.length();
        if (start + len > end) {
            return false;
        }
        if (start < 0) {
            return false;
        }
        for (int i2 = 0; i2 < len; ++i2) {
            if (buffer[start + i2] == s.charAt(i2)) continue;
            return false;
        }
        return true;
    }

    public static boolean regionMatches(@NotNull CharSequence buffer, int start, int end, @NotNull CharSequence s) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/util/text/CharArrayUtil", "regionMatches"));
        }
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/util/text/CharArrayUtil", "regionMatches"));
        }
        int len = s.length();
        if (start + len > end) {
            return false;
        }
        if (start < 0) {
            return false;
        }
        for (int i2 = 0; i2 < len; ++i2) {
            if (buffer.charAt(start + i2) == s.charAt(i2)) continue;
            return false;
        }
        return true;
    }

    public static boolean regionMatches(@NotNull CharSequence s1, int start1, int end1, @NotNull CharSequence s2, int start2, int end2) {
        if (s1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s1", "com/intellij/util/text/CharArrayUtil", "regionMatches"));
        }
        if (s2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s2", "com/intellij/util/text/CharArrayUtil", "regionMatches"));
        }
        if (end1 - start1 != end2 - start2) {
            return false;
        }
        int i2 = start1;
        int j = start2;
        while (i2 < end1) {
            if (s1.charAt(i2) != s2.charAt(j)) {
                return false;
            }
            ++i2;
            ++j;
        }
        return true;
    }

    public static boolean regionMatches(@NotNull CharSequence buffer, int offset, @NotNull CharSequence s) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/util/text/CharArrayUtil", "regionMatches"));
        }
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/util/text/CharArrayUtil", "regionMatches"));
        }
        if (offset + s.length() > buffer.length()) {
            return false;
        }
        if (offset < 0) {
            return false;
        }
        for (int i2 = 0; i2 < s.length(); ++i2) {
            if (buffer.charAt(offset + i2) == s.charAt(i2)) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(@NotNull char[] buffer1, int start1, int end1, @NotNull char[] buffer2, int start2, int end2) {
        if (buffer1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer1", "com/intellij/util/text/CharArrayUtil", "equals"));
        }
        if (buffer2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer2", "com/intellij/util/text/CharArrayUtil", "equals"));
        }
        if (end1 - start1 != end2 - start2) {
            return false;
        }
        for (int i2 = start1; i2 < end1; ++i2) {
            if (buffer1[i2] == buffer2[i2 - start1 + start2]) continue;
            return false;
        }
        return true;
    }

    public static int indexOf(@NotNull char[] buffer, @NotNull String pattern, int fromIndex) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/util/text/CharArrayUtil", "indexOf"));
        }
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/util/text/CharArrayUtil", "indexOf"));
        }
        char[] chars = pattern.toCharArray();
        int limit = buffer.length - chars.length + 1;
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        block0: for (int i2 = fromIndex; i2 < limit; ++i2) {
            for (int j = 0; j < chars.length; ++j) {
                if (chars[j] != buffer[i2 + j]) continue block0;
            }
            return i2;
        }
        return -1;
    }

    public static int indexOf(@NotNull CharSequence buffer, @NotNull CharSequence pattern, int fromIndex) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/util/text/CharArrayUtil", "indexOf"));
        }
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/util/text/CharArrayUtil", "indexOf"));
        }
        return CharArrayUtil.indexOf(buffer, pattern, fromIndex, buffer.length());
    }

    public static int indexOf(@NotNull CharSequence buffer, @NotNull CharSequence pattern, int fromIndex, int toIndex) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/util/text/CharArrayUtil", "indexOf"));
        }
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/util/text/CharArrayUtil", "indexOf"));
        }
        int patternLength = pattern.length();
        int limit = toIndex - patternLength + 1;
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        block0: for (int i2 = fromIndex; i2 < limit; ++i2) {
            for (int j = 0; j < patternLength; ++j) {
                if (pattern.charAt(j) != buffer.charAt(i2 + j)) continue block0;
            }
            return i2;
        }
        return -1;
    }

    public static int indexOf(@NotNull char[] buffer, char symbol, int fromIndex, int toIndex) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/util/text/CharArrayUtil", "indexOf"));
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        for (int i2 = fromIndex; i2 < toIndex; ++i2) {
            if (buffer[i2] != symbol) continue;
            return i2;
        }
        return -1;
    }

    public static int lastIndexOf(@NotNull char[] buffer, char symbol, int fromIndex, int toIndex) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/util/text/CharArrayUtil", "lastIndexOf"));
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        for (int i2 = toIndex - 1; i2 >= fromIndex; --i2) {
            if (buffer[i2] != symbol) continue;
            return i2;
        }
        return -1;
    }

    public static int lastIndexOf(@NotNull CharSequence buffer, @NotNull String pattern, int maxIndex) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/util/text/CharArrayUtil", "lastIndexOf"));
        }
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/util/text/CharArrayUtil", "lastIndexOf"));
        }
        char[] chars = pattern.toCharArray();
        int end = buffer.length() - chars.length;
        if (maxIndex > end) {
            maxIndex = end;
        }
        block0: for (int i2 = maxIndex; i2 >= 0; --i2) {
            for (int j = 0; j < chars.length; ++j) {
                if (chars[j] != buffer.charAt(i2 + j)) continue block0;
            }
            return i2;
        }
        return -1;
    }

    public static int lastIndexOf(@NotNull char[] buffer, @NotNull String pattern, int maxIndex) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/util/text/CharArrayUtil", "lastIndexOf"));
        }
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/intellij/util/text/CharArrayUtil", "lastIndexOf"));
        }
        char[] chars = pattern.toCharArray();
        int end = buffer.length - chars.length;
        if (maxIndex > end) {
            maxIndex = end;
        }
        block0: for (int i2 = maxIndex; i2 >= 0; --i2) {
            for (int j = 0; j < chars.length; ++j) {
                if (chars[j] != buffer[i2 + j]) continue block0;
            }
            return i2;
        }
        return -1;
    }

    @NotNull
    public static byte[] toByteArray(@NotNull char[] chars) throws IOException {
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/util/text/CharArrayUtil", "toByteArray"));
        }
        byte[] byArray = CharArrayUtil.toByteArray(chars, chars.length);
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/CharArrayUtil", "toByteArray"));
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static byte[] toByteArray(@NotNull char[] chars, int size) throws IOException {
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/util/text/CharArrayUtil", "toByteArray"));
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter(out);
        try {
            writer.write(chars, 0, size);
        }
        finally {
            writer.close();
        }
        byte[] byArray = out.toByteArray();
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/CharArrayUtil", "toByteArray"));
        }
        return byArray;
    }

    public static boolean containsOnlyWhiteSpaces(@Nullable CharSequence chars) {
        if (chars == null) {
            return true;
        }
        for (int i2 = 0; i2 < chars.length(); ++i2) {
            char c = chars.charAt(i2);
            if (c == ' ' || c == '\t' || c == '\n' || c == '\r') continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static TextRange[] getIndents(@NotNull CharSequence charsSequence, int shift) {
        if (charsSequence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charsSequence", "com/intellij/util/text/CharArrayUtil", "getIndents"));
        }
        List result = new ArrayList<TextRange>();
        int whitespaceEnd = -1;
        int lastTextFound = 0;
        for (int i2 = charsSequence.length() - 1; i2 >= 0; --i2) {
            char charAt = charsSequence.charAt(i2);
            boolean isWhitespace = Character.isWhitespace(charAt);
            if (charAt == '\n') {
                result.add(new TextRange(i2, (whitespaceEnd >= 0 ? whitespaceEnd : i2) + 1).shiftRight(shift));
                whitespaceEnd = -1;
                continue;
            }
            if (whitespaceEnd >= 0) {
                if (isWhitespace) continue;
                lastTextFound = result.size();
                whitespaceEnd = -1;
                continue;
            }
            if (isWhitespace) {
                whitespaceEnd = i2;
                continue;
            }
            lastTextFound = result.size();
        }
        if (whitespaceEnd > 0) {
            result.add(new TextRange(0, whitespaceEnd + 1).shiftRight(shift));
        }
        if (lastTextFound < result.size()) {
            result = result.subList(0, lastTextFound);
        }
        TextRange[] textRangeArray = result.toArray(new TextRange[result.size()]);
        if (textRangeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/CharArrayUtil", "getIndents"));
        }
        return textRangeArray;
    }

    public static boolean containLineBreaks(@NotNull CharSequence seq) {
        if (seq == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "seq", "com/intellij/util/text/CharArrayUtil", "containLineBreaks"));
        }
        return CharArrayUtil.containLineBreaks(seq, 0, seq.length());
    }

    public static boolean containLineBreaks(@Nullable CharSequence seq, int fromOffset, int endOffset) {
        if (seq == null) {
            return false;
        }
        for (int i2 = fromOffset; i2 < endOffset; ++i2) {
            char c = seq.charAt(i2);
            if (c != '\n' && c != '\r') continue;
            return true;
        }
        return false;
    }

    public static boolean isEmptyOrSpaces(@NotNull CharSequence text, int start, int end) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/util/text/CharArrayUtil", "isEmptyOrSpaces"));
        }
        for (int i2 = start; i2 < end; ++i2) {
            char c = text.charAt(i2);
            if (c == ' ' || c == '\t' || c == '\n') continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static Reader readerFromCharSequence(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/util/text/CharArrayUtil", "readerFromCharSequence"));
        }
        char[] chars = CharArrayUtil.fromSequenceWithoutCopying(text);
        Reader reader = chars == null ? new CharSequenceReader(text.toString()) : new UnsyncCharArrayReader(chars, 0, text.length());
        if (reader == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/CharArrayUtil", "readerFromCharSequence"));
        }
        return reader;
    }

    @NotNull
    public static ImmutableCharSequence createImmutableCharSequence(@NotNull CharSequence sequence) {
        if (sequence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/util/text/CharArrayUtil", "createImmutableCharSequence"));
        }
        ImmutableText immutableText = ImmutableText.valueOf((Object)sequence);
        if (immutableText == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/CharArrayUtil", "createImmutableCharSequence"));
        }
        return immutableText;
    }
}

