/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiThisExpression;
import org.jetbrains.annotations.NotNull;

class ThisPassedAsArgumentVisitor
extends JavaRecursiveElementWalkingVisitor {
    private boolean passed;

    ThisPassedAsArgumentVisitor() {
    }

    @Override
    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/bugs/ThisPassedAsArgumentVisitor", "visitElement"));
        }
        if (!this.passed) {
            super.visitElement(element);
        }
    }

    @Override
    public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
        PsiExpression[] arguments;
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/siyeh/ig/bugs/ThisPassedAsArgumentVisitor", "visitMethodCallExpression"));
        }
        if (this.passed) {
            return;
        }
        super.visitMethodCallExpression(call);
        PsiExpressionList argumentList = call.getArgumentList();
        for (PsiExpression argument : arguments = argumentList.getExpressions()) {
            if (!ThisPassedAsArgumentVisitor.isThisExpression(argument)) continue;
            this.passed = true;
            break;
        }
    }

    @Override
    public void visitNewExpression(@NotNull PsiNewExpression newExpression) {
        PsiExpression[] arguments;
        if (newExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newExpression", "com/siyeh/ig/bugs/ThisPassedAsArgumentVisitor", "visitNewExpression"));
        }
        if (this.passed) {
            return;
        }
        super.visitNewExpression(newExpression);
        PsiExpressionList argumentList = newExpression.getArgumentList();
        if (argumentList == null) {
            return;
        }
        for (PsiExpression argument : arguments = argumentList.getExpressions()) {
            if (!ThisPassedAsArgumentVisitor.isThisExpression(argument)) continue;
            this.passed = true;
            break;
        }
    }

    private static boolean isThisExpression(PsiExpression expression) {
        if (expression instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression;
            return ThisPassedAsArgumentVisitor.isThisExpression(parenthesizedExpression.getExpression());
        }
        return expression instanceof PsiThisExpression;
    }

    public boolean isPassed() {
        return this.passed;
    }
}

