/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import gnu.trove.THashSet;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class UnnecessaryExplicitNumericCastInspection
extends BaseInspection {
    private static final Set<IElementType> binaryPromotionOperators = new THashSet();

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.explicit.numeric.cast.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/UnnecessaryExplicitNumericCastInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiExpression expression = (PsiExpression)infos[0];
        String string = InspectionGadgetsBundle.message("unnecessary.explicit.numeric.cast.problem.descriptor", expression.getText());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/UnnecessaryExplicitNumericCastInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnnecessaryExplicitNumericCastFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryExplicitNumericCastVisitor();
    }

    public static boolean isPrimitiveNumericCastNecessary(PsiTypeCastExpression expression) {
        PsiType expectedType;
        PsiType castType = expression.getType();
        if (castType == null) {
            return true;
        }
        PsiExpression operand = expression.getOperand();
        if (operand == null) {
            return true;
        }
        PsiType operandType = operand.getType();
        if (operandType == null) {
            return true;
        }
        PsiElement parent = expression.getParent();
        while (parent instanceof PsiParenthesizedExpression) {
            parent = parent.getParent();
        }
        if (parent instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)parent;
            IElementType tokenType = polyadicExpression.getOperationTokenType();
            if (binaryPromotionOperators.contains(tokenType)) {
                if (TypeUtils.isNarrowingConversion(operandType, castType)) {
                    return true;
                }
                if (PsiType.INT.equals(castType)) {
                    if (PsiType.CHAR.equals(operandType) && TypeUtils.getStringType(polyadicExpression).equals(polyadicExpression.getType())) {
                        return true;
                    }
                    return PsiType.LONG.equals(operandType) || PsiType.FLOAT.equals(operandType) || PsiType.DOUBLE.equals(operandType);
                }
                if (PsiType.LONG.equals(castType) || PsiType.FLOAT.equals(castType) || PsiType.DOUBLE.equals(castType)) {
                    PsiExpression[] operands;
                    for (PsiExpression operand1 : operands = polyadicExpression.getOperands()) {
                        PsiType type;
                        if (PsiTreeUtil.isAncestor(operand1, expression, false) || !castType.equals(type = operand1.getType())) continue;
                        return false;
                    }
                }
            } else if (JavaTokenType.GTGT.equals(tokenType) || JavaTokenType.GTGTGT.equals(tokenType) || JavaTokenType.LTLT.equals(tokenType)) {
                PsiExpression firstOperand = polyadicExpression.getOperands()[0];
                if (!PsiTreeUtil.isAncestor(firstOperand, expression, false)) {
                    return false;
                }
                return PsiType.LONG.equals(castType) || !UnnecessaryExplicitNumericCastInspection.isLegalWideningConversion(operand, PsiType.INT);
            }
            return true;
        }
        if (parent instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
            PsiType lhsType = assignmentExpression.getType();
            return !castType.equals(lhsType) || !UnnecessaryExplicitNumericCastInspection.isLegalAssignmentConversion(operand, lhsType);
        }
        if (parent instanceof PsiVariable) {
            PsiVariable variable = (PsiVariable)parent;
            PsiType lhsType = variable.getType();
            return !castType.equals(lhsType) || !UnnecessaryExplicitNumericCastInspection.isLegalAssignmentConversion(operand, lhsType);
        }
        if (parent instanceof PsiExpressionList) {
            PsiExpressionList expressionList = (PsiExpressionList)parent;
            PsiElement grandParent = expressionList.getParent();
            if (!(grandParent instanceof PsiCallExpression)) {
                return true;
            }
            PsiCallExpression callExpression = (PsiCallExpression)grandParent;
            PsiMethod targetMethod = callExpression.resolveMethod();
            if (targetMethod == null || targetMethod != MethodCallUtils.findMethodWithReplacedArgument(callExpression, expression, operand)) {
                return true;
            }
        }
        return !castType.equals(expectedType = ExpectedTypeUtils.findExpectedType(expression, false)) || !UnnecessaryExplicitNumericCastInspection.isLegalWideningConversion(operand, castType);
    }

    static boolean isLegalWideningConversion(PsiExpression expression, PsiType requiredType) {
        PsiType operandType = expression.getType();
        return PsiType.DOUBLE.equals(requiredType) ? PsiType.FLOAT.equals(operandType) || PsiType.LONG.equals(operandType) || PsiType.INT.equals(operandType) || PsiType.CHAR.equals(operandType) || PsiType.SHORT.equals(operandType) || PsiType.BYTE.equals(operandType) : (PsiType.FLOAT.equals(requiredType) ? PsiType.LONG.equals(operandType) || PsiType.INT.equals(operandType) || PsiType.CHAR.equals(operandType) || PsiType.SHORT.equals(operandType) || PsiType.BYTE.equals(operandType) : (PsiType.LONG.equals(requiredType) ? PsiType.INT.equals(operandType) || PsiType.CHAR.equals(operandType) || PsiType.SHORT.equals(operandType) || PsiType.BYTE.equals(operandType) : PsiType.INT.equals(requiredType) && (PsiType.CHAR.equals(operandType) || PsiType.SHORT.equals(operandType) || PsiType.BYTE.equals(operandType))));
    }

    static boolean isLegalAssignmentConversion(PsiExpression expression, PsiType assignmentType) {
        if (UnnecessaryExplicitNumericCastInspection.isLegalWideningConversion(expression, assignmentType)) {
            return true;
        }
        if (PsiType.SHORT.equals(assignmentType)) {
            return UnnecessaryExplicitNumericCastInspection.canValueBeContained(expression, Short.MIN_VALUE, Short.MAX_VALUE);
        }
        if (PsiType.CHAR.equals(assignmentType)) {
            return UnnecessaryExplicitNumericCastInspection.canValueBeContained(expression, 0, 65535);
        }
        if (PsiType.BYTE.equals(assignmentType)) {
            return UnnecessaryExplicitNumericCastInspection.canValueBeContained(expression, -128, 127);
        }
        return false;
    }

    private static boolean canValueBeContained(PsiExpression expression, int lowerBound, int upperBound) {
        PsiType expressionType = expression.getType();
        if (!PsiType.INT.equals(expressionType)) {
            return false;
        }
        Object constant = ExpressionUtils.computeConstantExpression(expression);
        if (!(constant instanceof Integer)) {
            return false;
        }
        int i2 = (Integer)constant;
        return i2 >= lowerBound && i2 <= upperBound;
    }

    static {
        binaryPromotionOperators.add(JavaTokenType.ASTERISK);
        binaryPromotionOperators.add(JavaTokenType.DIV);
        binaryPromotionOperators.add(JavaTokenType.PERC);
        binaryPromotionOperators.add(JavaTokenType.PLUS);
        binaryPromotionOperators.add(JavaTokenType.MINUS);
        binaryPromotionOperators.add(JavaTokenType.LT);
        binaryPromotionOperators.add(JavaTokenType.LE);
        binaryPromotionOperators.add(JavaTokenType.GT);
        binaryPromotionOperators.add(JavaTokenType.GE);
        binaryPromotionOperators.add(JavaTokenType.EQEQ);
        binaryPromotionOperators.add(JavaTokenType.NE);
        binaryPromotionOperators.add(JavaTokenType.AND);
        binaryPromotionOperators.add(JavaTokenType.XOR);
        binaryPromotionOperators.add(JavaTokenType.OR);
    }

    private static class UnnecessaryExplicitNumericCastVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryExplicitNumericCastVisitor() {
        }

        @Override
        public void visitTypeCastExpression(PsiTypeCastExpression expression) {
            super.visitTypeCastExpression(expression);
            PsiType castType = expression.getType();
            if (!ClassUtils.isPrimitiveNumericType(castType)) {
                return;
            }
            PsiExpression operand = expression.getOperand();
            if (operand == null) {
                return;
            }
            PsiType operandType = operand.getType();
            if (castType.equals(operandType) || UnnecessaryExplicitNumericCastInspection.isPrimitiveNumericCastNecessary(expression)) {
                return;
            }
            PsiTypeElement typeElement = expression.getCastType();
            if (typeElement != null) {
                this.registerError((PsiElement)typeElement, ProblemHighlightType.LIKE_UNUSED_SYMBOL, operand);
            }
        }
    }

    private static class UnnecessaryExplicitNumericCastFix
    extends InspectionGadgetsFix {
        private UnnecessaryExplicitNumericCastFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("unnecessary.explicit.numeric.cast.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/numeric/UnnecessaryExplicitNumericCastInspection$UnnecessaryExplicitNumericCastFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiTypeCastExpression)) {
                return;
            }
            PsiTypeCastExpression typeCastExpression = (PsiTypeCastExpression)parent;
            if (UnnecessaryExplicitNumericCastInspection.isPrimitiveNumericCastNecessary(typeCastExpression)) {
                return;
            }
            PsiExpression operand = typeCastExpression.getOperand();
            if (operand == null) {
                typeCastExpression.delete();
            } else {
                typeCastExpression.replace(operand);
            }
        }
    }
}

