/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ReplaceWithObjectsEqualsFix
implements LocalQuickFix {
    private final String myQualifierText;
    private final String myReplacementText;

    private ReplaceWithObjectsEqualsFix(String qualifierText, String replacementText) {
        this.myQualifierText = qualifierText;
        this.myReplacementText = replacementText;
    }

    @Override
    @Nls
    @NotNull
    public String getName() {
        String string = "Replace '" + this.myQualifierText + ".equals(...)' with 'Objects.equals(" + this.myReplacementText + ", ...)'";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ReplaceWithObjectsEqualsFix", "getName"));
        }
        return string;
    }

    @Override
    @Nls
    @NotNull
    public String getFamilyName() {
        if ("Replace '.equals()' with 'Objects.equals()'" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ReplaceWithObjectsEqualsFix", "getFamilyName"));
        }
        return "Replace '.equals()' with 'Objects.equals()'";
    }

    @Override
    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/dataFlow/ReplaceWithObjectsEqualsFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/dataFlow/ReplaceWithObjectsEqualsFix", "applyFix"));
        }
        PsiMethodCallExpression call = PsiTreeUtil.getParentOfType(descriptor.getPsiElement(), PsiMethodCallExpression.class);
        if (call == null || !FileModificationService.getInstance().prepareFileForWrite(call.getContainingFile())) {
            return;
        }
        PsiExpression[] args = call.getArgumentList().getExpressions();
        if (args.length != 1) {
            return;
        }
        String replacementText = "java.util.Objects.equals(" + this.myReplacementText + ", " + args[0].getText() + ")";
        PsiElement replaced = call.replace(JavaPsiFacade.getElementFactory(project).createExpressionFromText(replacementText, call));
        JavaCodeStyleManager.getInstance(project).shortenClassReferences(((PsiMethodCallExpression)replaced).getMethodExpression());
    }

    @Nullable
    static ReplaceWithObjectsEqualsFix createFix(@NotNull PsiMethodCallExpression call, @NotNull PsiReferenceExpression methodExpression) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/codeInspection/dataFlow/ReplaceWithObjectsEqualsFix", "createFix"));
        }
        if (methodExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodExpression", "com/intellij/codeInspection/dataFlow/ReplaceWithObjectsEqualsFix", "createFix"));
        }
        if (!"equals".equals(methodExpression.getReferenceName()) || call.getArgumentList().getExpressions().length != 1 || !PsiUtil.getLanguageLevel(call).isAtLeast(LanguageLevel.JDK_1_7)) {
            return null;
        }
        PsiExpression qualifier = methodExpression.getQualifierExpression();
        PsiExpression noParens = PsiUtil.skipParenthesizedExprDown(qualifier);
        if (noParens == null) {
            return null;
        }
        PsiMethod method = call.resolveMethod();
        if (method != null && method.getParameterList().getParametersCount() == 1 && method.getParameterList().getParameters()[0].getType().equalsToText("java.lang.Object")) {
            return new ReplaceWithObjectsEqualsFix(qualifier.getText(), noParens.getText());
        }
        return null;
    }
}

