/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaReference;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiFieldStub;
import com.intellij.psi.impl.source.JavaStubPsiElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.ui.RowIcon;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class PsiEnumConstantImpl
extends JavaStubPsiElement<PsiFieldStub>
implements PsiEnumConstant {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.PsiEnumConstantImpl");
    private final MyReference myReference = new MyReference();

    public PsiEnumConstantImpl(PsiFieldStub stub) {
        super(stub, JavaStubElementTypes.ENUM_CONSTANT);
    }

    public PsiEnumConstantImpl(ASTNode node) {
        super(node);
    }

    @Override
    public String toString() {
        return "PsiEnumConstant:" + this.getName();
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/source/PsiEnumConstantImpl", "accept"));
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitEnumConstant(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public PsiExpressionList getArgumentList() {
        return (PsiExpressionList)this.calcTreeElement().findChildByRoleAsPsiElement(73);
    }

    @Override
    public PsiEnumConstantInitializer getInitializingClass() {
        return (PsiEnumConstantInitializer)this.getStubOrPsiChild(JavaStubElementTypes.ENUM_CONSTANT_INITIALIZER);
    }

    @Override
    @NotNull
    public PsiEnumConstantInitializer getOrCreateInitializingClass() {
        PsiEnumConstantInitializer initializingClass = this.getInitializingClass();
        if (initializingClass != null) {
            PsiEnumConstantInitializer psiEnumConstantInitializer = initializingClass;
            if (psiEnumConstantInitializer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiEnumConstantImpl", "getOrCreateInitializingClass"));
            }
            return psiEnumConstantInitializer;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory(this.getProject());
        PsiEnumConstantInitializer initializer = factory.createEnumConstantFromText("foo{}", null).getInitializingClass();
        LOG.assertTrue(initializer != null);
        PsiExpressionList argumentList = this.getArgumentList();
        if (argumentList != null) {
            PsiEnumConstantInitializer psiEnumConstantInitializer = (PsiEnumConstantInitializer)this.addAfter(initializer, argumentList);
            if (psiEnumConstantInitializer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiEnumConstantImpl", "getOrCreateInitializingClass"));
            }
            return psiEnumConstantInitializer;
        }
        PsiEnumConstantInitializer psiEnumConstantInitializer = (PsiEnumConstantInitializer)this.addAfter(initializer, this.getNameIdentifier());
        if (psiEnumConstantInitializer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiEnumConstantImpl", "getOrCreateInitializingClass"));
        }
        return psiEnumConstantInitializer;
    }

    @Override
    public PsiClass getContainingClass() {
        PsiElement parent = this.getParent();
        return parent instanceof PsiClass ? (PsiClass)parent : null;
    }

    @Override
    public PsiElement getContext() {
        PsiClass cc = this.getContainingClass();
        return cc != null ? cc : super.getContext();
    }

    @Override
    public PsiModifierList getModifierList() {
        return this.getStubOrPsiChild(JavaStubElementTypes.MODIFIER_LIST);
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/source/PsiEnumConstantImpl", "hasModifierProperty"));
        }
        return "public".equals(name) || "static".equals(name) || "final".equals(name);
    }

    @Override
    @NotNull
    public PsiType getType() {
        PsiClassType psiClassType = JavaPsiFacade.getInstance(this.getProject()).getElementFactory().createType(this.getContainingClass());
        if (psiClassType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiEnumConstantImpl", "getType"));
        }
        return psiClassType;
    }

    @Override
    public PsiTypeElement getTypeElement() {
        return null;
    }

    @Override
    public PsiExpression getInitializer() {
        return null;
    }

    @Override
    public boolean hasInitializer() {
        return true;
    }

    @Override
    public void normalizeDeclaration() throws IncorrectOperationException {
    }

    @Override
    public Object computeConstantValue() {
        return this;
    }

    @Override
    public PsiMethod resolveMethod() {
        PsiClass containingClass = this.getContainingClass();
        LOG.assertTrue(containingClass != null);
        JavaPsiFacade facade = JavaPsiFacade.getInstance(this.getProject());
        JavaResolveResult resolveResult = facade.getResolveHelper().resolveConstructor(facade.getElementFactory().createType(containingClass), this.getArgumentList(), this);
        return (PsiMethod)resolveResult.getElement();
    }

    @Override
    @NotNull
    public JavaResolveResult resolveMethodGenerics() {
        PsiClass containingClass = this.getContainingClass();
        LOG.assertTrue(containingClass != null);
        JavaPsiFacade facade = JavaPsiFacade.getInstance(this.getProject());
        JavaResolveResult javaResolveResult = facade.getResolveHelper().resolveConstructor(facade.getElementFactory().createType(containingClass), this.getArgumentList(), this);
        if (javaResolveResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiEnumConstantImpl", "resolveMethodGenerics"));
        }
        return javaResolveResult;
    }

    @Override
    @NotNull
    public PsiIdentifier getNameIdentifier() {
        PsiIdentifier psiIdentifier = (PsiIdentifier)this.calcTreeElement().findChildByRoleAsPsiElement(9);
        if (psiIdentifier == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiEnumConstantImpl", "getNameIdentifier"));
        }
        return psiIdentifier;
    }

    @Override
    @NotNull
    public String getName() {
        PsiFieldStub stub = (PsiFieldStub)this.getGreenStub();
        if (stub != null) {
            String string = stub.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiEnumConstantImpl", "getName"));
            }
            return string;
        }
        String string = this.getNameIdentifier().getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiEnumConstantImpl", "getName"));
        }
        return string;
    }

    @Override
    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/source/PsiEnumConstantImpl", "setName"));
        }
        PsiImplUtil.setName(this.getNameIdentifier(), name);
        return this;
    }

    @Override
    public PsiDocComment getDocComment() {
        return (PsiDocComment)this.calcTreeElement().findChildByRoleAsPsiElement(7);
    }

    @Override
    public boolean isDeprecated() {
        PsiFieldStub stub = (PsiFieldStub)this.getGreenStub();
        if (stub != null) {
            return stub.isDeprecated();
        }
        PsiDocComment docComment = this.getDocComment();
        return docComment != null && docComment.findTagByName("deprecated") != null || this.getModifierList().findAnnotation("java.lang.Deprecated") != null;
    }

    @Override
    public PsiReference getReference() {
        return this.myReference;
    }

    @Override
    public PsiMethod resolveConstructor() {
        return this.resolveMethod();
    }

    @Override
    public Icon getElementIcon(int flags) {
        RowIcon baseIcon = ElementPresentationUtil.createLayeredIcon(PlatformIcons.FIELD_ICON, this, false);
        return ElementPresentationUtil.addVisibilityIcon(this, flags, baseIcon);
    }

    @Override
    protected boolean isVisibilitySupported() {
        return true;
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation(this);
    }

    @Override
    public void setInitializer(PsiExpression initializer) throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        return PsiClassImplUtil.isFieldEquivalentTo(this, another);
    }

    private class MyReference
    implements PsiJavaReference {
        private MyReference() {
        }

        @Override
        public PsiElement getElement() {
            return PsiEnumConstantImpl.this;
        }

        @Override
        public TextRange getRangeInElement() {
            PsiIdentifier nameIdentifier = PsiEnumConstantImpl.this.getNameIdentifier();
            int startOffsetInParent = nameIdentifier.getStartOffsetInParent();
            return new TextRange(startOffsetInParent, startOffsetInParent + nameIdentifier.getTextLength());
        }

        @Override
        public boolean isSoft() {
            return false;
        }

        @Override
        public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
            return this.getElement();
        }

        @Override
        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/PsiEnumConstantImpl$MyReference", "bindToElement"));
            }
            throw new IncorrectOperationException("Invalid operation");
        }

        @Override
        @NotNull
        public Object[] getVariants() {
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiEnumConstantImpl$MyReference", "getVariants"));
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }

        @Override
        public void processVariants(@NotNull PsiScopeProcessor processor) {
            if (processor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/source/PsiEnumConstantImpl$MyReference", "processVariants"));
            }
        }

        @Override
        @NotNull
        public JavaResolveResult[] multiResolve(boolean incompleteCode) {
            JavaPsiFacade facade = JavaPsiFacade.getInstance(PsiEnumConstantImpl.this.getProject());
            PsiClassType type = facade.getElementFactory().createType(PsiEnumConstantImpl.this.getContainingClass());
            JavaResolveResult[] javaResolveResultArray = facade.getResolveHelper().multiResolveConstructor(type, PsiEnumConstantImpl.this.getArgumentList(), this.getElement());
            if (javaResolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiEnumConstantImpl$MyReference", "multiResolve"));
            }
            return javaResolveResultArray;
        }

        @Override
        @NotNull
        public JavaResolveResult advancedResolve(boolean incompleteCode) {
            JavaResolveResult[] results = this.multiResolve(incompleteCode);
            if (results.length == 1) {
                JavaResolveResult javaResolveResult = results[0];
                if (javaResolveResult == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiEnumConstantImpl$MyReference", "advancedResolve"));
                }
                return javaResolveResult;
            }
            JavaResolveResult javaResolveResult = JavaResolveResult.EMPTY;
            if (javaResolveResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiEnumConstantImpl$MyReference", "advancedResolve"));
            }
            return javaResolveResult;
        }

        @Override
        public PsiElement resolve() {
            return this.advancedResolve(false).getElement();
        }

        @Override
        @NotNull
        public String getCanonicalText() {
            String string = PsiEnumConstantImpl.this.getContainingClass().getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiEnumConstantImpl$MyReference", "getCanonicalText"));
            }
            return string;
        }

        @Override
        public boolean isReferenceTo(PsiElement element) {
            return element instanceof PsiMethod && ((PsiMethod)element).isConstructor() && ((PsiMethod)element).getContainingClass() == PsiEnumConstantImpl.this.getContainingClass() && PsiEnumConstantImpl.this.getManager().areElementsEquivalent(this.resolve(), element);
        }
    }
}

