/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator;

import com.intellij.dupLocator.DupInfo;
import com.intellij.dupLocator.DuplocateVisitor;
import com.intellij.dupLocator.DuplocatorState;
import com.intellij.dupLocator.PsiElementRole;
import com.intellij.dupLocator.treeHash.FragmentsCollector;
import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.lang.Language;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.PsiElement;
import com.intellij.util.indexing.FileContent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DuplicatesProfile {
    public static final ExtensionPointName<DuplicatesProfile> EP_NAME = ExtensionPointName.create("com.intellij.duplicates.profile");
    private static final int FACTOR = 2;
    private static final int MAX_COST = 7000;

    @NotNull
    public abstract DuplocateVisitor createVisitor(@NotNull FragmentsCollector var1);

    @NotNull
    public DuplocateVisitor createVisitor(@NotNull FragmentsCollector collector, boolean forIndexing) {
        if (collector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collector", "com/intellij/dupLocator/DuplicatesProfile", "createVisitor"));
        }
        DuplocateVisitor duplocateVisitor = this.createVisitor(collector);
        if (duplocateVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/DuplicatesProfile", "createVisitor"));
        }
        return duplocateVisitor;
    }

    public abstract boolean isMyLanguage(@NotNull Language var1);

    @NotNull
    public abstract DuplocatorState getDuplocatorState(@NotNull Language var1);

    @Nullable
    public String getComment(@NotNull DupInfo info, int index) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/dupLocator/DuplicatesProfile", "getComment"));
        }
        return null;
    }

    public abstract boolean isMyDuplicate(@NotNull DupInfo var1, int var2);

    public boolean supportIndex() {
        return true;
    }

    public boolean supportDuplicatesIndex() {
        return false;
    }

    public boolean acceptsContentForIndexing(FileContent fileContent) {
        return true;
    }

    public boolean shouldPutInIndex(PsiFragment fragment, int cost, DuplocatorState state) {
        int lowerBound = state.getLowerBound();
        return cost >= 2 * lowerBound && cost <= 7000;
    }

    @Nullable
    public static DuplicatesProfile findProfileForLanguage(@NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/dupLocator/DuplicatesProfile", "findProfileForLanguage"));
        }
        return DuplicatesProfile.findProfileForLanguage(EP_NAME.getExtensions(), language);
    }

    @NotNull
    public static DuplicatesProfile[] getAllProfiles() {
        DuplicatesProfile[] duplicatesProfileArray = Extensions.getExtensions(EP_NAME);
        if (duplicatesProfileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/DuplicatesProfile", "getAllProfiles"));
        }
        return duplicatesProfileArray;
    }

    @Nullable
    public static DuplicatesProfile findProfileForLanguage(DuplicatesProfile[] profiles, @NotNull Language language) {
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/dupLocator/DuplicatesProfile", "findProfileForLanguage"));
        }
        for (DuplicatesProfile profile : profiles) {
            if (!profile.isMyLanguage(language)) continue;
            return profile;
        }
        return null;
    }

    @NotNull
    public Language getLanguage(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/dupLocator/DuplicatesProfile", "getLanguage"));
        }
        Language language = element.getLanguage();
        if (language == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/DuplicatesProfile", "getLanguage"));
        }
        return language;
    }

    @Nullable
    public PsiElementRole getRole(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/dupLocator/DuplicatesProfile", "getRole"));
        }
        return null;
    }
}

