/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pom.xml.impl;

import com.intellij.pom.PomModel;
import com.intellij.pom.PomModelAspect;
import com.intellij.pom.event.PomChangeSet;
import com.intellij.pom.xml.XmlAspect;
import com.intellij.pom.xml.XmlChangeSet;
import com.intellij.pom.xml.events.XmlChange;
import com.intellij.psi.xml.XmlFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlAspectChangeSetImpl
implements XmlChangeSet {
    private final PomModel myModel;
    private final List<XmlChange> myChanges = new ArrayList<XmlChange>();
    private final List<XmlFile> myChangedFiles = new ArrayList<XmlFile>();

    public XmlAspectChangeSetImpl(PomModel model) {
        this.myModel = model;
    }

    public XmlAspectChangeSetImpl(PomModel model, @Nullable XmlFile xmlFile) {
        this(model);
        if (xmlFile != null) {
            this.addChangedFile(xmlFile);
        }
    }

    @Override
    public List<XmlChange> getChanges() {
        return Collections.unmodifiableList(this.myChanges);
    }

    @Override
    @NotNull
    public PomModelAspect getAspect() {
        XmlAspect xmlAspect = this.myModel.getModelAspect(XmlAspect.class);
        if (xmlAspect == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/pom/xml/impl/XmlAspectChangeSetImpl", "getAspect"));
        }
        return xmlAspect;
    }

    @Override
    public void merge(@NotNull PomChangeSet blocked) {
        if (blocked == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "blocked", "com/intellij/pom/xml/impl/XmlAspectChangeSetImpl", "merge"));
        }
        List<XmlChange> changes = ((XmlAspectChangeSetImpl)blocked).myChanges;
        for (XmlChange xmlChange : changes) {
            this.add(xmlChange);
        }
    }

    @Override
    public void add(XmlChange xmlChange) {
        this.myChanges.add(xmlChange);
    }

    @Override
    public void clear() {
        this.myChanges.clear();
    }

    @Override
    @NotNull
    public Iterable<XmlFile> getChangedFiles() {
        List<XmlFile> list = this.myChangedFiles;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/pom/xml/impl/XmlAspectChangeSetImpl", "getChangedFiles"));
        }
        return list;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        Iterator<XmlChange> iterator = this.myChanges.iterator();
        while (iterator.hasNext()) {
            XmlChange xmlChange = iterator.next();
            buffer.append("(");
            buffer.append(xmlChange);
            buffer.append(")");
            if (!iterator.hasNext()) continue;
            buffer.append(", ");
        }
        return buffer.toString();
    }

    @Override
    public void addChangedFile(@NotNull XmlFile xmlFile) {
        if (xmlFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlFile", "com/intellij/pom/xml/impl/XmlAspectChangeSetImpl", "addChangedFile"));
        }
        this.myChangedFiles.add(xmlFile);
    }
}

