/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.PsiJavaModuleReference;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiJavaModuleReferenceElementImpl
extends CompositePsiElement
implements PsiJavaModuleReferenceElement {
    public PsiJavaModuleReferenceElementImpl() {
        super(JavaElementType.MODULE_REFERENCE);
    }

    @Override
    @NotNull
    public String getReferenceText() {
        StringBuilder sb = new StringBuilder();
        for (PsiElement e = this.getFirstChild(); e != null; e = e.getNextSibling()) {
            if (e instanceof PsiWhiteSpace || e instanceof PsiComment) continue;
            sb.append(e.getText());
        }
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiJavaModuleReferenceElementImpl", "getReferenceText"));
        }
        return string;
    }

    @Override
    public PsiPolyVariantReference getReference() {
        return CachedValuesManager.getCachedValue(this, new CachedValueProvider<PsiJavaModuleReference>(){

            @Override
            @Nullable
            public CachedValueProvider.Result<PsiJavaModuleReference> compute() {
                PsiJavaModuleReferenceElementImpl refElement = PsiJavaModuleReferenceElementImpl.this;
                PsiJavaModuleReference ref = refElement.getParent() instanceof PsiJavaModule ? null : new PsiJavaModuleReference(refElement);
                return CachedValueProvider.Result.create(ref, refElement);
            }
        });
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/source/PsiJavaModuleReferenceElementImpl", "accept"));
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitModuleReferenceElement(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiJavaModuleReference";
    }
}

