/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.folding.impl.JavaFoldingBuilderBase;
import com.intellij.codeInsight.generation.OverrideImplementExploreUtil;
import com.intellij.lang.folding.NamedFoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ClosureFolding {
    @NotNull
    private final PsiAnonymousClass myAnonymousClass;
    @NotNull
    private final PsiNewExpression myNewExpression;
    @Nullable
    private final PsiClass myBaseClass;
    @NotNull
    private final JavaFoldingBuilderBase myBuilder;
    @NotNull
    private final PsiMethod myMethod;
    @NotNull
    final PsiCodeBlock methodBody;
    private final boolean myQuick;

    private ClosureFolding(@NotNull PsiAnonymousClass anonymousClass, @NotNull PsiNewExpression newExpression, boolean quick, @Nullable PsiClass baseClass, @NotNull JavaFoldingBuilderBase builder, @NotNull PsiMethod method, @NotNull PsiCodeBlock methodBody) {
        if (anonymousClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anonymousClass", "com/intellij/codeInsight/folding/impl/ClosureFolding", "<init>"));
        }
        if (newExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newExpression", "com/intellij/codeInsight/folding/impl/ClosureFolding", "<init>"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/codeInsight/folding/impl/ClosureFolding", "<init>"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/folding/impl/ClosureFolding", "<init>"));
        }
        if (methodBody == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodBody", "com/intellij/codeInsight/folding/impl/ClosureFolding", "<init>"));
        }
        this.myAnonymousClass = anonymousClass;
        this.myNewExpression = newExpression;
        this.myQuick = quick;
        this.myBaseClass = baseClass;
        this.myBuilder = builder;
        this.myMethod = method;
        this.methodBody = methodBody;
    }

    @Nullable
    List<NamedFoldingDescriptor> process(Document document) {
        int rangeEnd;
        PsiJavaToken lbrace = this.methodBody.getLBrace();
        PsiJavaToken rbrace = this.methodBody.getRBrace();
        PsiElement classRBrace = this.myAnonymousClass.getRBrace();
        if (lbrace == null || rbrace == null || classRBrace == null) {
            return null;
        }
        CharSequence seq = document.getCharsSequence();
        int rangeStart = lbrace.getTextRange().getEndOffset();
        String contents = ClosureFolding.getClosureContents(rangeStart, rangeEnd = ClosureFolding.getContentRangeEnd(document, rbrace, classRBrace), seq);
        if (contents == null) {
            return null;
        }
        String header = this.getFoldingHeader();
        if (this.showSingleLineFolding(document, contents, header)) {
            return this.createDescriptors(classRBrace, ClosureFolding.trimStartSpaces(seq, rangeStart), ClosureFolding.trimTailSpaces(seq, rangeEnd), header + " ", " }");
        }
        return this.createDescriptors(classRBrace, rangeStart, rangeEnd, header, "}");
    }

    private static int trimStartSpaces(CharSequence seq, int rangeStart) {
        return CharArrayUtil.shiftForward(seq, rangeStart, " \n\t");
    }

    private static int trimTailSpaces(CharSequence seq, int rangeEnd) {
        return CharArrayUtil.shiftBackward(seq, rangeEnd - 1, " \n\t") + 1;
    }

    private static int getContentRangeEnd(Document document, PsiJavaToken rbrace, PsiElement classRBrace) {
        int rangeEnd;
        int methodEndLine;
        int methodEndLineStart;
        CharSequence seq = document.getCharsSequence();
        if ("}".equals(seq.subSequence(methodEndLineStart = document.getLineStartOffset(methodEndLine = document.getLineNumber(rangeEnd = rbrace.getTextRange().getStartOffset())), document.getLineEndOffset(methodEndLine)).toString().trim())) {
            int classEndStart = classRBrace.getTextRange().getStartOffset();
            int classEndCol = classEndStart - document.getLineStartOffset(document.getLineNumber(classEndStart));
            return classEndCol + methodEndLineStart;
        }
        return rangeEnd;
    }

    private boolean showSingleLineFolding(Document document, String contents, String header) {
        return contents.indexOf(10) < 0 && this.myBuilder.fitsRightMargin(this.myAnonymousClass, document, this.getClosureStartOffset(), this.getClosureEndOffset(), header.length() + contents.length() + 5);
    }

    private int getClosureEndOffset() {
        return this.myNewExpression.getTextRange().getEndOffset();
    }

    private int getClosureStartOffset() {
        return this.myNewExpression.getTextRange().getStartOffset();
    }

    @Nullable
    private List<NamedFoldingDescriptor> createDescriptors(PsiElement classRBrace, int rangeStart, int rangeEnd, String header, String footer) {
        if (rangeStart >= rangeEnd) {
            return null;
        }
        FoldingGroup group = FoldingGroup.newGroup("lambda");
        ArrayList<NamedFoldingDescriptor> foldElements = new ArrayList<NamedFoldingDescriptor>();
        foldElements.add(new NamedFoldingDescriptor(this.myNewExpression, this.getClosureStartOffset(), rangeStart, group, header));
        if (rangeEnd + 1 < this.getClosureEndOffset()) {
            foldElements.add(new NamedFoldingDescriptor(classRBrace, rangeEnd, this.getClosureEndOffset(), group, footer));
        }
        return foldElements;
    }

    @Nullable
    private static String getClosureContents(int rangeStart, int rangeEnd, CharSequence seq) {
        int lastLineEnd;
        int firstLineStart = CharArrayUtil.shiftForward(seq, rangeStart, " \t");
        if (firstLineStart < seq.length() - 1 && seq.charAt(firstLineStart) == '\n') {
            ++firstLineStart;
        }
        if ((lastLineEnd = CharArrayUtil.shiftBackward(seq, rangeEnd - 1, " \t")) > 0 && seq.charAt(lastLineEnd) == '\n') {
            --lastLineEnd;
        }
        if (lastLineEnd < firstLineStart) {
            return null;
        }
        return seq.subSequence(firstLineStart, lastLineEnd).toString();
    }

    private String getFoldingHeader() {
        String methodName = this.shouldShowMethodName() ? this.myMethod.getName() : "";
        String type = this.myQuick ? "" : this.getOptionalLambdaType();
        String params = StringUtil.join(this.myMethod.getParameterList().getParameters(), new Function<PsiParameter, String>(){

            @Override
            public String fun(PsiParameter psiParameter) {
                return psiParameter.getName();
            }
        }, ", ");
        return type + methodName + "(" + params + ") " + this.myBuilder.rightArrow() + " {";
    }

    @Nullable
    static ClosureFolding prepare(PsiAnonymousClass anonymousClass, boolean quick, JavaFoldingBuilderBase builder) {
        PsiElement parent = anonymousClass.getParent();
        if (parent instanceof PsiNewExpression && ClosureFolding.hasNoArguments((PsiNewExpression)parent)) {
            PsiMethod method;
            PsiCodeBlock body;
            PsiClass baseClass = quick ? null : anonymousClass.getBaseClassType().resolve();
            if (ClosureFolding.hasOnlyOneLambdaMethod(anonymousClass, !quick) && (quick || ClosureFolding.seemsLikeLambda(baseClass, anonymousClass)) && (body = (method = anonymousClass.getMethods()[0]).getBody()) != null) {
                return new ClosureFolding(anonymousClass, (PsiNewExpression)parent, quick, baseClass, builder, method, body);
            }
        }
        return null;
    }

    private static boolean hasNoArguments(PsiNewExpression expression) {
        PsiExpressionList argumentList = expression.getArgumentList();
        return argumentList != null && argumentList.getExpressions().length == 0;
    }

    private static boolean hasOnlyOneLambdaMethod(@NotNull PsiAnonymousClass anonymousClass, boolean checkResolve) {
        if (anonymousClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anonymousClass", "com/intellij/codeInsight/folding/impl/ClosureFolding", "hasOnlyOneLambdaMethod"));
        }
        PsiField[] fields = anonymousClass.getFields();
        if (!(fields.length == 0 || fields.length == 1 && "serialVersionUID".equals(fields[0].getName()) && fields[0].hasModifierProperty("static"))) {
            return false;
        }
        if (anonymousClass.getInitializers().length != 0 || anonymousClass.getInnerClasses().length != 0 || anonymousClass.getMethods().length != 1) {
            return false;
        }
        PsiMethod method = anonymousClass.getMethods()[0];
        if (method.hasModifierProperty("synchronized")) {
            return false;
        }
        if (checkResolve) {
            for (PsiClassType type : method.getThrowsList().getReferencedTypes()) {
                if (type.resolve() != null) continue;
                return false;
            }
        }
        return true;
    }

    static boolean seemsLikeLambda(@Nullable PsiClass baseClass, @NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/folding/impl/ClosureFolding", "seemsLikeLambda"));
        }
        if (baseClass == null || !PsiUtil.hasDefaultConstructor(baseClass, true)) {
            return false;
        }
        return !PsiUtil.isLanguageLevel8OrHigher(context) || !LambdaUtil.isFunctionalClass(baseClass);
    }

    private String getOptionalLambdaType() {
        String baseClassName;
        if (this.myBuilder.shouldShowExplicitLambdaType(this.myAnonymousClass, this.myNewExpression) && (baseClassName = ObjectUtils.assertNotNull(this.myAnonymousClass.getBaseClassType().resolve()).getName()) != null) {
            return "(" + baseClassName + ") ";
        }
        return "";
    }

    private boolean shouldShowMethodName() {
        if (this.myBaseClass == null || !this.myBaseClass.hasModifierProperty("abstract")) {
            return true;
        }
        for (PsiMethod method : this.myBaseClass.getMethods()) {
            if (!method.hasModifierProperty("abstract")) continue;
            return false;
        }
        try {
            return OverrideImplementExploreUtil.getMethodSignaturesToImplement(this.myBaseClass).isEmpty();
        }
        catch (IndexNotReadyException e) {
            return true;
        }
    }
}

