/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.compiled;

import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.impl.compiled.ClsElementImpl;
import com.intellij.psi.impl.compiled.ClsJavaModuleReferenceElementImpl;
import com.intellij.psi.impl.compiled.ClsRepositoryPsiElement;
import com.intellij.psi.impl.java.stubs.PsiRequiresStatementStub;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClsRequiresStatementImpl
extends ClsRepositoryPsiElement<PsiRequiresStatementStub>
implements PsiRequiresStatement {
    private final NotNullLazyValue<PsiJavaModuleReferenceElement> myModuleReference = new AtomicNotNullLazyValue<PsiJavaModuleReferenceElement>(){

        @Override
        @NotNull
        protected PsiJavaModuleReferenceElement compute() {
            ClsJavaModuleReferenceElementImpl clsJavaModuleReferenceElementImpl = new ClsJavaModuleReferenceElementImpl(ClsRequiresStatementImpl.this, ((PsiRequiresStatementStub)ClsRequiresStatementImpl.this.getStub()).getModuleName());
            if (clsJavaModuleReferenceElementImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/compiled/ClsRequiresStatementImpl$1", "compute"));
            }
            return clsJavaModuleReferenceElementImpl;
        }
    };

    public ClsRequiresStatementImpl(PsiRequiresStatementStub stub) {
        super(stub);
    }

    @Override
    @Nullable
    public PsiJavaModuleReferenceElement getReferenceElement() {
        return this.myModuleReference.getValue();
    }

    @Override
    @Nullable
    public String getModuleName() {
        return ((PsiRequiresStatementStub)this.getStub()).getModuleName();
    }

    @Override
    public boolean isPublic() {
        return ((PsiRequiresStatementStub)this.getStub()).isPublic();
    }

    @Override
    public void appendMirrorText(int indentLevel, @NotNull StringBuilder buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/psi/impl/compiled/ClsRequiresStatementImpl", "appendMirrorText"));
        }
        StringUtil.repeatSymbol(buffer, ' ', indentLevel);
        PsiRequiresStatementStub stub = (PsiRequiresStatementStub)this.getStub();
        buffer.append("requires ");
        if (stub.isPublic()) {
            buffer.append("public ");
        }
        if (stub.isStatic()) {
            buffer.append("static ");
        }
        buffer.append(stub.getModuleName()).append(";\n");
    }

    @Override
    public void setMirror(@NotNull TreeElement element) throws ClsElementImpl.InvalidMirrorException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/compiled/ClsRequiresStatementImpl", "setMirror"));
        }
        this.setMirrorCheckingType(element, JavaElementType.REQUIRES_STATEMENT);
    }

    @Override
    public String toString() {
        return "PsiRequiresStatement";
    }
}

