/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InvalidComparatorMethodReferenceInspection
extends BaseJavaBatchLocalInspectionTool {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/InvalidComparatorMethodReferenceInspection", "buildVisitor"));
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            @Override
            public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression) {
                PsiElement referenceNameElement = expression.getReferenceNameElement();
                if (referenceNameElement == null) {
                    return;
                }
                String name = referenceNameElement.getText();
                if (!name.equals("min") && !name.equals("max")) {
                    return;
                }
                String className = InvalidComparatorMethodReferenceInspection.getMethodReferenceClassName(expression);
                if (!"java.lang.Integer".equals(className) && !"java.lang.Math".equals(className)) {
                    return;
                }
                String functionalInterface = InvalidComparatorMethodReferenceInspection.getFunctionalInterfaceClassName(expression);
                if (!"java.util.Comparator".equals(functionalInterface)) {
                    return;
                }
                holder.registerProblem((PsiElement)expression, "Method reference mapped to Comparator interface does not fulfill the Comparator contract", new ReplaceWithComparatorQuickFix(name.equals("min")));
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/InvalidComparatorMethodReferenceInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    @Nullable
    static String getFunctionalInterfaceClassName(PsiMethodReferenceExpression expression) {
        PsiType functionalInterfaceType = expression.getFunctionalInterfaceType();
        if (!(functionalInterfaceType instanceof PsiClassType)) {
            return null;
        }
        PsiClass targetType = ((PsiClassType)functionalInterfaceType).resolve();
        if (targetType == null) {
            return null;
        }
        return targetType.getQualifiedName();
    }

    @Nullable
    static String getMethodReferenceClassName(PsiMethodReferenceExpression expression) {
        PsiExpression qualifierExpression = expression.getQualifierExpression();
        if (!(qualifierExpression instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiElement refType = ((PsiReference)((Object)qualifierExpression)).resolve();
        if (!(refType instanceof PsiClass)) {
            return null;
        }
        return ((PsiClass)refType).getQualifiedName();
    }

    private static class ReplaceWithComparatorQuickFix
    implements LocalQuickFix {
        private final boolean reverse;

        public ReplaceWithComparatorQuickFix(boolean reverse) {
            this.reverse = reverse;
        }

        @Override
        @Nls
        @NotNull
        public String getName() {
            String string = "Replace with " + (this.reverse ? "Comparator.reverseOrder()" : "Comparator.naturalOrder()");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/InvalidComparatorMethodReferenceInspection$ReplaceWithComparatorQuickFix", "getName"));
            }
            return string;
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Replace with comparator" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/InvalidComparatorMethodReferenceInspection$ReplaceWithComparatorQuickFix", "getFamilyName"));
            }
            return "Replace with comparator";
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/InvalidComparatorMethodReferenceInspection$ReplaceWithComparatorQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/InvalidComparatorMethodReferenceInspection$ReplaceWithComparatorQuickFix", "applyFix"));
            }
            PsiElement element = descriptor.getPsiElement();
            if (!FileModificationService.getInstance().preparePsiElementForWrite(element)) {
                return;
            }
            PsiElement parent = element.getParent();
            if (parent != null) {
                PsiExpression newMethodExpression = JavaPsiFacade.getElementFactory(project).createExpressionFromText("java.util.Comparator." + (this.reverse ? "reverseOrder()" : "naturalOrder()"), parent);
                element.replace(newMethodExpression);
                JavaCodeStyleManager.getInstance(project).shortenClassReferences(parent);
            }
        }
    }
}

