/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis.asm;

import com.intellij.codeInspection.bytecodeAnalysis.asm.ControlFlowGraph;
import com.intellij.codeInspection.bytecodeAnalysis.asm.LiteFramelessAnalyzer;
import gnu.trove.TIntArrayList;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;

final class LiteControlFlowBuilder
extends LiteFramelessAnalyzer {
    final String className;
    final MethodNode methodNode;
    final TIntArrayList[] transitions;
    final Set<ControlFlowGraph.Edge> errorTransitions;
    private final boolean[] errors;
    private int edgeCount;

    LiteControlFlowBuilder(String className, MethodNode methodNode) {
        this.className = className;
        this.methodNode = methodNode;
        this.transitions = new TIntArrayList[methodNode.instructions.size()];
        this.errors = new boolean[methodNode.instructions.size()];
        for (int i2 = 0; i2 < this.transitions.length; ++i2) {
            this.transitions[i2] = new TIntArrayList();
        }
        this.errorTransitions = new HashSet<ControlFlowGraph.Edge>();
    }

    final ControlFlowGraph buildCFG() throws AnalyzerException {
        if ((this.methodNode.access & 0x500) == 0) {
            this.analyze(this.methodNode);
        }
        int[][] resultTransitions = new int[this.transitions.length][];
        for (int i2 = 0; i2 < resultTransitions.length; ++i2) {
            resultTransitions[i2] = this.transitions[i2].toNativeArray();
        }
        return new ControlFlowGraph(this.className, this.methodNode, resultTransitions, this.edgeCount, this.errors, this.errorTransitions);
    }

    @Override
    protected final void newControlFlowEdge(int insn, int successor) {
        if (!this.transitions[insn].contains(successor)) {
            this.transitions[insn].add(successor);
            ++this.edgeCount;
        }
    }

    @Override
    protected final boolean newControlFlowExceptionEdge(int insn, int successor) {
        if (!this.transitions[insn].contains(successor)) {
            this.transitions[insn].add(successor);
            ++this.edgeCount;
            this.errorTransitions.add(new ControlFlowGraph.Edge(insn, successor));
            this.errors[successor] = true;
        }
        return true;
    }
}

