/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class AssertsWithoutMessagesInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("asserts.without.messages.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/AssertsWithoutMessagesInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getID() {
        if ("MessageMissingOnJUnitAssertion" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/AssertsWithoutMessagesInspection", "getID"));
        }
        return "MessageMissingOnJUnitAssertion";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("asserts.without.messages.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/AssertsWithoutMessagesInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new AssertionsWithoutMessagesVisitor();
    }

    private static class AssertionsWithoutMessagesVisitor
    extends BaseInspectionVisitor {
        @NonNls
        private static final Set<String> s_assertMethods = new HashSet<String>(8);

        private AssertionsWithoutMessagesVisitor() {
        }

        @Override
        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/junit/AssertsWithoutMessagesInspection$AssertionsWithoutMessagesVisitor", "visitMethodCallExpression"));
            }
            super.visitMethodCallExpression(expression);
            PsiReferenceExpression methodExpression = expression.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (methodName == null || !s_assertMethods.contains(methodName)) {
                return;
            }
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (!InheritanceUtil.isInheritor(containingClass, "junit.framework.Assert") && !InheritanceUtil.isInheritor(containingClass, "org.junit.Assert")) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            int parameterCount = parameterList.getParametersCount();
            if (parameterCount < 2 && methodName.startsWith("assert")) {
                this.registerMethodCallError(expression, new Object[0]);
                return;
            }
            if (parameterCount < 1) {
                this.registerMethodCallError(expression, new Object[0]);
                return;
            }
            PsiClassType stringType = TypeUtils.getStringType(expression);
            PsiParameter[] parameters = parameterList.getParameters();
            PsiType parameterType1 = parameters[0].getType();
            if (!parameterType1.equals(stringType)) {
                this.registerMethodCallError(expression, new Object[0]);
                return;
            }
            if (parameters.length != 2) {
                return;
            }
            PsiType parameterType2 = parameters[1].getType();
            if (!parameterType2.equals(stringType)) {
                return;
            }
            this.registerMethodCallError(expression, new Object[0]);
        }

        static {
            s_assertMethods.add("assertArrayEquals");
            s_assertMethods.add("assertEquals");
            s_assertMethods.add("assertFalse");
            s_assertMethods.add("assertNotNull");
            s_assertMethods.add("assertNotSame");
            s_assertMethods.add("assertNull");
            s_assertMethods.add("assertSame");
            s_assertMethods.add("assertThat");
            s_assertMethods.add("assertTrue");
            s_assertMethods.add("fail");
        }
    }
}

