/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.BaseActionRunnable;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.RunResult;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.psi.PsiFile;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class WriteCommandAction<T>
extends BaseActionRunnable<T> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.command.WriteCommandAction");
    private final String myCommandName;
    private final String myGroupID;
    private final Project myProject;
    private final PsiFile[] myPsiFiles;

    protected WriteCommandAction(@Nullable Project project, PsiFile ... files) {
        this(project, "Undefined", files);
    }

    protected WriteCommandAction(@Nullable Project project, @Nullable String commandName, PsiFile ... files) {
        this(project, commandName, (String)null, files);
    }

    protected WriteCommandAction(@Nullable Project project, @Nullable String commandName, @Nullable String groupID, PsiFile ... files) {
        this.myCommandName = commandName;
        this.myGroupID = groupID;
        this.myProject = project;
        if (files == null) {
            LOG.warn("'files' parameter must not be null", new Throwable());
        }
        this.myPsiFiles = files == null || files.length == 0 ? PsiFile.EMPTY_ARRAY : files;
    }

    public final Project getProject() {
        return this.myProject;
    }

    public final String getCommandName() {
        return this.myCommandName;
    }

    public String getGroupID() {
        return this.myGroupID;
    }

    @Override
    @NotNull
    public RunResult<T> execute() {
        Application application = ApplicationManager.getApplication();
        boolean dispatchThread = application.isDispatchThread();
        if (!dispatchThread && application.isReadAccessAllowed()) {
            LOG.error("Must not start write action from within read action in the other thread - deadlock is coming");
            throw new IllegalStateException();
        }
        final RunResult result = new RunResult(this);
        if (dispatchThread) {
            this.performWriteCommandAction(result);
        } else {
            try {
                TransactionGuard.getInstance().submitTransactionAndWait(new Runnable(){

                    @Override
                    public void run() {
                        WriteCommandAction.this.performWriteCommandAction(result);
                    }
                });
            }
            catch (ProcessCanceledException processCanceledException) {
                // empty catch block
            }
        }
        RunResult runResult = result;
        if (runResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/command/WriteCommandAction", "execute"));
        }
        return runResult;
    }

    private void performWriteCommandAction(@NotNull RunResult<T> result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/command/WriteCommandAction", "performWriteCommandAction"));
        }
        if (!FileModificationService.getInstance().preparePsiElementsForWrite(Arrays.asList(this.myPsiFiles))) {
            return;
        }
        final RunResult[] results = new RunResult[]{result};
        this.doExecuteCommand(new Runnable(){

            @Override
            public void run() {
                AccessToken token = ApplicationManager.getApplication().acquireWriteActionLock(WriteCommandAction.this.getClass());
                try {
                    results[0].run();
                    results[0] = null;
                }
                finally {
                    token.finish();
                }
            }
        });
    }

    protected boolean isGlobalUndoAction() {
        return false;
    }

    protected UndoConfirmationPolicy getUndoConfirmationPolicy() {
        return UndoConfirmationPolicy.DO_NOT_REQUEST_CONFIRMATION;
    }

    protected boolean shouldRecordActionForActiveDocument() {
        return true;
    }

    public void performCommand() throws Throwable {
        final RunResult[] results = new RunResult[]{new RunResult(this)};
        final Ref exception = new Ref();
        this.doExecuteCommand(new Runnable(){

            @Override
            public void run() {
                exception.set(results[0].run().getThrowable());
                results[0] = null;
            }
        });
        Throwable throwable = (Throwable)exception.get();
        if (throwable != null) {
            throw throwable;
        }
    }

    private void doExecuteCommand(final Runnable runnable) {
        Runnable wrappedRunnable = new Runnable(){

            @Override
            public void run() {
                if (WriteCommandAction.this.isGlobalUndoAction()) {
                    CommandProcessor.getInstance().markCurrentCommandAsGlobal(WriteCommandAction.this.getProject());
                }
                runnable.run();
            }
        };
        CommandProcessor.getInstance().executeCommand(this.getProject(), wrappedRunnable, this.getCommandName(), (Object)this.getGroupID(), this.getUndoConfirmationPolicy(), this.shouldRecordActionForActiveDocument());
    }

    public static void runWriteCommandAction(Project project, @NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/command/WriteCommandAction", "runWriteCommandAction"));
        }
        WriteCommandAction.runWriteCommandAction(project, "Undefined", null, runnable, new PsiFile[0]);
    }

    public static void runWriteCommandAction(Project project, @Nullable String commandName, @Nullable String groupID, final @NotNull Runnable runnable, PsiFile ... files) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/command/WriteCommandAction", "runWriteCommandAction"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/command/WriteCommandAction", "runWriteCommandAction"));
        }
        new Simple(project, commandName, groupID, files){

            @Override
            protected void run() throws Throwable {
                runnable.run();
            }
        }.execute();
    }

    public static <T> T runWriteCommandAction(Project project, final @NotNull Computable<T> computable) {
        if (computable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computable", "com/intellij/openapi/command/WriteCommandAction", "runWriteCommandAction"));
        }
        return new WriteCommandAction<T>(project, new PsiFile[0]){

            @Override
            protected void run(@NotNull Result<T> result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/command/WriteCommandAction$6", "run"));
                }
                result.setResult(computable.compute());
            }
        }.execute().getResultObject();
    }

    public static <T, E extends Throwable> T runWriteCommandAction(Project project, final @NotNull ThrowableComputable<T, E> computable) throws E {
        if (computable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computable", "com/intellij/openapi/command/WriteCommandAction", "runWriteCommandAction"));
        }
        RunResult<T> result = new WriteCommandAction<T>(project, "", new PsiFile[0]){

            @Override
            protected void run(@NotNull Result<T> result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/command/WriteCommandAction$7", "run"));
                }
                result.setResult(computable.compute());
            }
        }.execute();
        Throwable t = result.getThrowable();
        if (t != null) {
            Throwable e = t;
            throw e;
        }
        return result.throwException().getResultObject();
    }

    public static boolean ensureFilesWritable(@NotNull Project project, @NotNull Collection<PsiFile> psiFiles) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/command/WriteCommandAction", "ensureFilesWritable"));
        }
        if (psiFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFiles", "com/intellij/openapi/command/WriteCommandAction", "ensureFilesWritable"));
        }
        return FileModificationService.getInstance().preparePsiElementsForWrite(psiFiles);
    }

    public static abstract class Simple<T>
    extends WriteCommandAction<T> {
        protected Simple(Project project, PsiFile ... files) {
            super(project, files);
        }

        protected Simple(Project project, String commandName, PsiFile ... files) {
            super(project, commandName, files);
        }

        protected Simple(Project project, String name, String groupID, PsiFile ... files) {
            super(project, name, groupID, files);
        }

        @Override
        protected void run(@NotNull Result<T> result) throws Throwable {
            if (result == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/command/WriteCommandAction$Simple", "run"));
            }
            this.run();
        }

        protected abstract void run() throws Throwable;
    }
}

