/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.javadoc;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaDocumentedElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.javadoc.PsiDocToken;
import com.intellij.psi.javadoc.PsiInlineDocTag;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.MethodUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class UnnecessaryInheritDocInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("unnecessary.inherit.doc.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/javadoc/UnnecessaryInheritDocInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        switch ((WarningType)((Object)infos[0])) {
            case CLASS: {
                String string = InspectionGadgetsBundle.message("unnecessary.inherit.doc.class.invalid.problem.descriptor", new Object[0]);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/javadoc/UnnecessaryInheritDocInspection", "buildErrorString"));
                }
                return string;
            }
            case FIELD: {
                String string = InspectionGadgetsBundle.message("unnecessary.inherit.doc.field.invalid.problem.descriptor", new Object[0]);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/javadoc/UnnecessaryInheritDocInspection", "buildErrorString"));
                }
                return string;
            }
            case CONSTRUCTOR: {
                String string = InspectionGadgetsBundle.message("unnecessary.inherit.doc.constructor.invalid.problem.descriptor", new Object[0]);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/javadoc/UnnecessaryInheritDocInspection", "buildErrorString"));
                }
                return string;
            }
            case NO_SUPER: {
                String string = InspectionGadgetsBundle.message("unnecessary.inherit.doc.constructor.no.super.problem.descriptor", new Object[0]);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/javadoc/UnnecessaryInheritDocInspection", "buildErrorString"));
                }
                return string;
            }
            case EMPTY: {
                String string = InspectionGadgetsBundle.message("unnecessary.inherit.doc.problem.descriptor", new Object[0]);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/javadoc/UnnecessaryInheritDocInspection", "buildErrorString"));
                }
                return string;
            }
        }
        throw new AssertionError();
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new UnnecessaryInheritDocFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UnnecessaryInheritDocVisitor();
    }

    private static class UnnecessaryInheritDocVisitor
    extends BaseInspectionVisitor {
        private UnnecessaryInheritDocVisitor() {
        }

        @Override
        public void visitInlineDocTag(PsiInlineDocTag tag) {
            PsiDocTag docTag;
            String docTagName;
            String name = tag.getName();
            if (!"inheritDoc".equals(name)) {
                return;
            }
            PsiDocComment docComment = tag.getContainingComment();
            if (docComment == null) {
                return;
            }
            PsiJavaDocumentedElement owner = docComment.getOwner();
            if (owner instanceof PsiField) {
                this.registerError((PsiElement)tag, new Object[]{WarningType.FIELD});
                return;
            }
            if (owner instanceof PsiClass) {
                this.registerError((PsiElement)tag, new Object[]{WarningType.CLASS});
                return;
            }
            if (owner instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)owner;
                if (method.isConstructor()) {
                    this.registerError((PsiElement)tag, new Object[]{WarningType.CONSTRUCTOR});
                    return;
                }
                if (!MethodUtils.hasSuper(method)) {
                    this.registerError((PsiElement)tag, new Object[]{WarningType.NO_SUPER});
                    return;
                }
            } else {
                return;
            }
            PsiElement parent = tag.getParent();
            if (parent instanceof PsiDocTag && ((docTagName = (docTag = (PsiDocTag)parent).getName()).equals("throws") || docTagName.equals("exception")) && !UnnecessaryInheritDocVisitor.isCheckExceptionAndPresentInThrowsList((PsiMethod)owner, docTag)) {
                return;
            }
            PsiDocToken[] docTokens = (PsiDocToken[])PsiTreeUtil.getChildrenOfType((PsiElement)parent, PsiDocToken.class);
            if (docTokens == null) {
                return;
            }
            for (PsiDocToken docToken : docTokens) {
                IElementType tokenType = docToken.getTokenType();
                if (!JavaDocTokenType.DOC_COMMENT_DATA.equals(tokenType) || StringUtil.isEmptyOrSpaces(docToken.getText())) continue;
                return;
            }
            this.registerError((PsiElement)tag, new Object[]{WarningType.EMPTY});
        }

        private static boolean isCheckExceptionAndPresentInThrowsList(PsiMethod method, PsiDocTag docTag) {
            PsiDocTagValue valueElement = docTag.getValueElement();
            PsiJavaCodeReferenceElement referenceElement = PsiTreeUtil.findChildOfType(valueElement, PsiJavaCodeReferenceElement.class);
            if (referenceElement != null) {
                PsiElement target = referenceElement.resolve();
                if (!(target instanceof PsiClass)) {
                    return false;
                }
                PsiClass aClass = (PsiClass)target;
                if (!InheritanceUtil.isInheritor(aClass, "java.lang.Exception") || InheritanceUtil.isInheritor(aClass, "java.lang.RuntimeException")) {
                    return false;
                }
                PsiReferenceList throwsList = method.getThrowsList();
                PsiJavaCodeReferenceElement[] elements = throwsList.getReferenceElements();
                boolean found = false;
                for (PsiJavaCodeReferenceElement element : elements) {
                    if (!target.equals(element.resolve())) continue;
                    found = true;
                }
                if (!found) {
                    return false;
                }
            }
            return true;
        }
    }

    private static class UnnecessaryInheritDocFix
    extends InspectionGadgetsFix {
        private UnnecessaryInheritDocFix() {
        }

        @Override
        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("unnecessary.inherit.doc.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/javadoc/UnnecessaryInheritDocInspection$UnnecessaryInheritDocFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiDocTag)) {
                return;
            }
            PsiDocTag docTag = (PsiDocTag)element;
            PsiElement parent = docTag.getParent();
            if (parent instanceof PsiDocComment) {
                PsiDocComment docComment = (PsiDocComment)parent;
                PsiDocTag[] docTags = docComment.getTags();
                if (docTags.length > 0) {
                    element.delete();
                    return;
                }
                PsiDocToken[] docTokens = (PsiDocToken[])PsiTreeUtil.getChildrenOfType((PsiElement)parent, PsiDocToken.class);
                if (docTokens != null) {
                    for (PsiDocToken docToken : docTokens) {
                        IElementType tokenType = docToken.getTokenType();
                        if (!JavaDocTokenType.DOC_COMMENT_DATA.equals(tokenType) || StringUtil.isEmptyOrSpaces(docToken.getText())) continue;
                        element.delete();
                        return;
                    }
                }
            }
            parent.delete();
        }
    }

    static enum WarningType {
        CLASS,
        FIELD,
        CONSTRUCTOR,
        EMPTY,
        NO_SUPER;

    }
}

