/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInspection.dataFlow.ControlFlow;
import com.intellij.codeInspection.dataFlow.ControlTransferInstruction;
import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.ExceptionTransfer;
import com.intellij.codeInspection.dataFlow.HardcodedContracts;
import com.intellij.codeInspection.dataFlow.InstructionTransfer;
import com.intellij.codeInspection.dataFlow.InstructionVisitor;
import com.intellij.codeInspection.dataFlow.LiveVariablesAnalyzer;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.ReturnTransfer;
import com.intellij.codeInspection.dataFlow.StandardInstructionVisitor;
import com.intellij.codeInspection.dataFlow.Trap;
import com.intellij.codeInspection.dataFlow.instructions.AssignInstruction;
import com.intellij.codeInspection.dataFlow.instructions.BinopInstruction;
import com.intellij.codeInspection.dataFlow.instructions.CheckReturnValueInstruction;
import com.intellij.codeInspection.dataFlow.instructions.ConditionalGotoInstruction;
import com.intellij.codeInspection.dataFlow.instructions.DupInstruction;
import com.intellij.codeInspection.dataFlow.instructions.EmptyInstruction;
import com.intellij.codeInspection.dataFlow.instructions.EmptyStackInstruction;
import com.intellij.codeInspection.dataFlow.instructions.FieldReferenceInstruction;
import com.intellij.codeInspection.dataFlow.instructions.FinishElementInstruction;
import com.intellij.codeInspection.dataFlow.instructions.FlushVariableInstruction;
import com.intellij.codeInspection.dataFlow.instructions.GotoInstruction;
import com.intellij.codeInspection.dataFlow.instructions.InstanceofInstruction;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.instructions.LambdaInstruction;
import com.intellij.codeInspection.dataFlow.instructions.MethodCallInstruction;
import com.intellij.codeInspection.dataFlow.instructions.NotInstruction;
import com.intellij.codeInspection.dataFlow.instructions.PopInstruction;
import com.intellij.codeInspection.dataFlow.instructions.PushInstruction;
import com.intellij.codeInspection.dataFlow.instructions.ReturnInstruction;
import com.intellij.codeInspection.dataFlow.instructions.SwapInstruction;
import com.intellij.codeInspection.dataFlow.instructions.TypeCastInstruction;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaUnknownValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiConstructorCall;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionCodeFragment;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FList;
import com.siyeh.ig.numeric.UnnecessaryExplicitNumericCastInspection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ControlFlowAnalyzer
extends JavaElementVisitor {
    private static final Logger LOG = Logger.getInstance("#com.intellij.codeInspection.dataFlow.ControlFlowAnalyzer");
    public static final String ORG_JETBRAINS_ANNOTATIONS_CONTRACT = Contract.class.getName();
    private final PsiElement myCodeFragment;
    private boolean myIgnoreAssertions;
    private final Project myProject;
    private final DfaValueFactory myFactory;
    private ControlFlow myCurrentFlow;
    private FList<Trap> myTrapStack;
    private final ExceptionTransfer myRuntimeException;
    private final ExceptionTransfer myError;
    private final PsiType myNpe;
    private final PsiType myAssertionError;

    ControlFlowAnalyzer(DfaValueFactory valueFactory, @NotNull PsiElement codeFragment, boolean ignoreAssertions) {
        if (codeFragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codeFragment", "com/intellij/codeInspection/dataFlow/ControlFlowAnalyzer", "<init>"));
        }
        this.myTrapStack = FList.emptyList();
        this.myFactory = valueFactory;
        this.myCodeFragment = codeFragment;
        this.myProject = codeFragment.getProject();
        this.myIgnoreAssertions = ignoreAssertions;
        GlobalSearchScope scope = codeFragment.getResolveScope();
        this.myRuntimeException = new ExceptionTransfer(this.myFactory.createTypeValue(this.createClassType(scope, "java.lang.RuntimeException"), Nullness.NOT_NULL));
        this.myError = new ExceptionTransfer(this.myFactory.createTypeValue(this.createClassType(scope, "java.lang.Error"), Nullness.NOT_NULL));
        this.myNpe = this.createClassType(scope, "java.lang.NullPointerException");
        this.myAssertionError = this.createClassType(scope, "java.lang.AssertionError");
    }

    @Nullable
    public ControlFlow buildControlFlow() {
        this.myCurrentFlow = new ControlFlow(this.myFactory);
        try {
            this.myCodeFragment.accept(this);
        }
        catch (CannotAnalyzeException e) {
            return null;
        }
        PsiElement parent = this.myCodeFragment.getParent();
        if (parent instanceof PsiLambdaExpression && this.myCodeFragment instanceof PsiExpression) {
            this.generateBoxingUnboxingInstructionFor((PsiExpression)this.myCodeFragment, LambdaUtil.getFunctionalInterfaceReturnType((PsiLambdaExpression)parent));
            this.addInstruction(new CheckReturnValueInstruction(this.myCodeFragment));
        }
        this.addInstruction(new ReturnInstruction(this.myFactory.controlTransfer(ReturnTransfer.INSTANCE, FList.emptyList()), null));
        if (Registry.is("idea.dfa.live.variables.analysis")) {
            new LiveVariablesAnalyzer(this.myCurrentFlow, this.myFactory).flushDeadVariablesOnStatementFinish();
        }
        return this.myCurrentFlow;
    }

    private PsiClassType createClassType(GlobalSearchScope scope, String fqn) {
        PsiClass aClass = JavaPsiFacade.getInstance(this.myProject).findClass(fqn, scope);
        if (aClass != null) {
            return JavaPsiFacade.getElementFactory(this.myProject).createType(aClass);
        }
        return JavaPsiFacade.getElementFactory(this.myProject).createTypeByFQClassName(fqn, scope);
    }

    private <T extends Instruction> T addInstruction(T i2) {
        this.myCurrentFlow.addInstruction(i2);
        return i2;
    }

    private ControlFlow.ControlFlowOffset getEndOffset(PsiElement element) {
        return this.myCurrentFlow.getEndOffset(element);
    }

    private ControlFlow.ControlFlowOffset getStartOffset(PsiElement element) {
        return this.myCurrentFlow.getStartOffset(element);
    }

    private void startElement(PsiElement element) {
        this.myCurrentFlow.startElement(element);
    }

    private void finishElement(PsiElement element) {
        this.myCurrentFlow.finishElement(element);
        if (element instanceof PsiStatement && !(element instanceof PsiReturnStatement)) {
            this.addInstruction(new FinishElementInstruction(element));
        }
    }

    @Override
    public void visitErrorElement(PsiErrorElement element) {
        throw new CannotAnalyzeException();
    }

    @Override
    public void visitAssignmentExpression(PsiAssignmentExpression expression) {
        PsiExpression lExpr = expression.getLExpression();
        PsiExpression rExpr = expression.getRExpression();
        this.startElement(expression);
        if (rExpr == null) {
            this.pushUnknown();
            this.finishElement(expression);
            return;
        }
        IElementType op = expression.getOperationTokenType();
        PsiType type = expression.getType();
        boolean isBoolean = PsiType.BOOLEAN.equals(type);
        if (op == JavaTokenType.EQ) {
            lExpr.accept(this);
            rExpr.accept(this);
            this.generateBoxingUnboxingInstructionFor(rExpr, type);
        } else if (op == JavaTokenType.ANDEQ) {
            if (isBoolean) {
                this.generateBooleanAssignmentExpression(true, lExpr, rExpr, type);
            } else {
                this.generateDefaultAssignmentBinOp(lExpr, rExpr, type);
            }
        } else if (op == JavaTokenType.OREQ) {
            if (isBoolean) {
                this.generateBooleanAssignmentExpression(false, lExpr, rExpr, type);
            } else {
                this.generateDefaultAssignmentBinOp(lExpr, rExpr, type);
            }
        } else if (op == JavaTokenType.XOREQ) {
            if (isBoolean) {
                this.generateXorExpression(expression, new PsiExpression[]{lExpr, rExpr}, type, true);
            } else {
                this.generateDefaultAssignmentBinOp(lExpr, rExpr, type);
            }
        } else if (op == JavaTokenType.PLUSEQ && type != null && type.equalsToText("java.lang.String")) {
            lExpr.accept(this);
            this.addInstruction(new DupInstruction());
            rExpr.accept(this);
            this.addInstruction(new BinopInstruction(JavaTokenType.PLUS, null, this.myProject));
        } else {
            this.generateDefaultAssignmentBinOp(lExpr, rExpr, type);
        }
        this.addInstruction(new AssignInstruction(rExpr, this.myFactory.createValue(lExpr)));
        this.flushArrayElementsOnUnknownIndexAssignment(lExpr);
        this.finishElement(expression);
    }

    private void flushArrayElementsOnUnknownIndexAssignment(PsiExpression lExpr) {
        DfaValue arrayVar;
        if (lExpr instanceof PsiArrayAccessExpression && !(this.myFactory.createValue(lExpr) instanceof DfaVariableValue) && (arrayVar = this.myFactory.createValue(((PsiArrayAccessExpression)lExpr).getArrayExpression())) instanceof DfaVariableValue) {
            this.addInstruction(new FlushVariableInstruction((DfaVariableValue)arrayVar, true));
        }
    }

    private void generateDefaultAssignmentBinOp(PsiExpression lExpr, PsiExpression rExpr, PsiType exprType) {
        lExpr.accept(this);
        this.addInstruction(new DupInstruction());
        this.generateBoxingUnboxingInstructionFor(lExpr, exprType);
        rExpr.accept(this);
        this.generateBoxingUnboxingInstructionFor(rExpr, exprType);
        this.addInstruction(new BinopInstruction(null, null, this.myProject));
    }

    @Override
    public void visitAssertStatement(PsiAssertStatement statement) {
        if (this.myIgnoreAssertions) {
            return;
        }
        this.startElement(statement);
        PsiExpression condition = statement.getAssertCondition();
        PsiExpression description = statement.getAssertDescription();
        if (condition != null) {
            condition.accept(this);
            this.generateBoxingUnboxingInstructionFor(condition, PsiType.BOOLEAN);
            this.addInstruction(new ConditionalGotoInstruction(this.getEndOffset(statement), false, condition));
            if (description != null) {
                description.accept(this);
            }
            this.throwException(this.myAssertionError, (PsiElement)statement);
        }
        this.finishElement(statement);
    }

    @Override
    public void visitDeclarationStatement(PsiDeclarationStatement statement) {
        PsiElement[] elements;
        this.startElement(statement);
        for (PsiElement element : elements = statement.getDeclaredElements()) {
            PsiVariable variable;
            PsiExpression initializer;
            if (element instanceof PsiClass) {
                this.addInstruction(new EmptyInstruction(element));
                continue;
            }
            if (!(element instanceof PsiVariable) || (initializer = (variable = (PsiVariable)element).getInitializer()) == null) continue;
            this.initializeVariable(variable, initializer);
        }
        this.finishElement(statement);
    }

    @Override
    public void visitField(PsiField field) {
        PsiExpression initializer = field.getInitializer();
        if (initializer != null) {
            this.initializeVariable(field, initializer);
        }
    }

    private void initializeVariable(PsiVariable variable, PsiExpression initializer) {
        DfaVariableValue dfaVariable = this.myFactory.getVarFactory().createVariableValue(variable, false);
        this.addInstruction(new PushInstruction(dfaVariable, initializer));
        initializer.accept(this);
        this.generateBoxingUnboxingInstructionFor(initializer, variable.getType());
        this.addInstruction(new AssignInstruction(initializer, dfaVariable));
        this.addInstruction(new PopInstruction());
    }

    @Override
    public void visitCodeFragment(JavaCodeFragment codeFragment) {
        PsiExpression expression;
        this.startElement(codeFragment);
        if (codeFragment instanceof PsiExpressionCodeFragment && (expression = ((PsiExpressionCodeFragment)codeFragment).getExpression()) != null) {
            expression.accept(this);
        }
        this.finishElement(codeFragment);
    }

    @Override
    public void visitCodeBlock(PsiCodeBlock block) {
        this.startElement(block);
        for (PsiStatement statement : block.getStatements()) {
            statement.accept(this);
        }
        this.flushCodeBlockVariables(block);
        this.finishElement(block);
    }

    private void flushCodeBlockVariables(PsiCodeBlock block) {
        block6: {
            PsiResourceList list;
            PsiElement parent;
            block8: {
                block7: {
                    block5: {
                        for (PsiStatement statement : block.getStatements()) {
                            if (!(statement instanceof PsiDeclarationStatement)) continue;
                            for (PsiElement declaration : ((PsiDeclarationStatement)statement).getDeclaredElements()) {
                                if (!(declaration instanceof PsiVariable)) continue;
                                this.myCurrentFlow.removeVariable((PsiVariable)declaration);
                            }
                        }
                        parent = block.getParent();
                        if (!(parent instanceof PsiCatchSection)) break block5;
                        this.myCurrentFlow.removeVariable(((PsiCatchSection)parent).getParameter());
                        break block6;
                    }
                    if (!(parent instanceof PsiForeachStatement)) break block7;
                    this.myCurrentFlow.removeVariable(((PsiForeachStatement)parent).getIterationParameter());
                    break block6;
                }
                if (!(parent instanceof PsiForStatement)) break block8;
                PsiStatement statement = ((PsiForStatement)parent).getInitialization();
                if (!(statement instanceof PsiDeclarationStatement)) break block6;
                for (PsiElement declaration : ((PsiDeclarationStatement)statement).getDeclaredElements()) {
                    if (!(declaration instanceof PsiVariable)) continue;
                    this.myCurrentFlow.removeVariable((PsiVariable)declaration);
                }
                break block6;
            }
            if (parent instanceof PsiTryStatement && (list = ((PsiTryStatement)parent).getResourceList()) != null) {
                for (PsiResourceListElement resource : list) {
                    if (!(resource instanceof PsiResourceVariable)) continue;
                    this.myCurrentFlow.removeVariable((PsiVariable)((Object)resource));
                }
            }
        }
    }

    @Override
    public void visitBlockStatement(PsiBlockStatement statement) {
        this.startElement(statement);
        statement.getCodeBlock().accept(this);
        this.finishElement(statement);
    }

    @Override
    public void visitBreakStatement(PsiBreakStatement statement) {
        this.startElement(statement);
        PsiStatement exitedStatement = statement.findExitedStatement();
        if (exitedStatement != null) {
            this.controlTransfer(new InstructionTransfer(this.getEndOffset(exitedStatement), this.getVariablesInside(exitedStatement)), this.getTrapsInsideStatement(exitedStatement));
        }
        this.finishElement(statement);
    }

    private void controlTransfer(InstructionTransfer target, FList<Trap> traps) {
        this.addInstruction(new ControlTransferInstruction(this.myFactory.controlTransfer(target, traps)));
    }

    @NotNull
    private FList<Trap> getTrapsInsideStatement(PsiStatement statement) {
        FList<Trap> fList = FList.createFromReversed(ContainerUtil.reverse(ContainerUtil.findAll(this.myTrapStack, cd -> PsiTreeUtil.isAncestor(statement, cd.getAnchor(), true))));
        if (fList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ControlFlowAnalyzer", "getTrapsInsideStatement"));
        }
        return fList;
    }

    @NotNull
    private List<DfaVariableValue> getVariablesInside(PsiElement exitedStatement) {
        List<DfaVariableValue> list = ContainerUtil.map(PsiTreeUtil.findChildrenOfType(exitedStatement, PsiVariable.class), var -> this.myFactory.getVarFactory().createVariableValue((PsiVariable)var, false));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ControlFlowAnalyzer", "getVariablesInside"));
        }
        return list;
    }

    @Override
    public void visitContinueStatement(PsiContinueStatement statement) {
        this.startElement(statement);
        PsiStatement continuedStatement = statement.findContinuedStatement();
        if (continuedStatement instanceof PsiLoopStatement) {
            PsiStatement body = ((PsiLoopStatement)continuedStatement).getBody();
            this.controlTransfer(new InstructionTransfer(this.getEndOffset(body), this.getVariablesInside(body)), this.getTrapsInsideStatement(body));
        } else {
            this.addInstruction(new EmptyInstruction(null));
        }
        this.finishElement(statement);
    }

    @Override
    public void visitDoWhileStatement(PsiDoWhileStatement statement) {
        this.startElement(statement);
        PsiStatement body = statement.getBody();
        if (body != null) {
            body.accept(this);
            PsiExpression condition = statement.getCondition();
            if (condition != null) {
                condition.accept(this);
                this.generateBoxingUnboxingInstructionFor(condition, PsiType.BOOLEAN);
                this.addInstruction(new ConditionalGotoInstruction(this.getStartOffset(statement), false, condition));
            }
        }
        this.finishElement(statement);
    }

    @Override
    public void visitEmptyStatement(PsiEmptyStatement statement) {
        this.startElement(statement);
        this.finishElement(statement);
    }

    @Override
    public void visitExpressionStatement(PsiExpressionStatement statement) {
        this.startElement(statement);
        PsiExpression expr = statement.getExpression();
        expr.accept(this);
        this.addInstruction(new PopInstruction());
        this.finishElement(statement);
    }

    @Override
    public void visitExpressionListStatement(PsiExpressionListStatement statement) {
        PsiExpression[] expressions;
        this.startElement(statement);
        for (PsiExpression expr : expressions = statement.getExpressionList().getExpressions()) {
            expr.accept(this);
            this.addInstruction(new PopInstruction());
        }
        this.finishElement(statement);
    }

    @Override
    public void visitForeachStatement(PsiForeachStatement statement) {
        this.startElement(statement);
        PsiParameter parameter = statement.getIterationParameter();
        PsiExpression iteratedValue = statement.getIteratedValue();
        if (iteratedValue != null) {
            iteratedValue.accept(this);
            this.addInstruction(new FieldReferenceInstruction(iteratedValue, "Collection iterator or array.length"));
        }
        ControlFlow.ControlFlowOffset offset = this.myCurrentFlow.getNextOffset();
        DfaVariableValue dfaVariable = this.myFactory.getVarFactory().createVariableValue(parameter, false);
        this.addInstruction(new FlushVariableInstruction(dfaVariable));
        this.pushUnknown();
        this.addInstruction(new ConditionalGotoInstruction(this.getEndOffset(statement), true, null));
        PsiStatement body = statement.getBody();
        if (body != null) {
            body.accept(this);
        }
        this.addInstruction(new GotoInstruction(offset));
        this.finishElement(statement);
        this.myCurrentFlow.removeVariable(parameter);
    }

    @Override
    public void visitForStatement(PsiForStatement statement) {
        PsiStatement update;
        PsiExpression condition;
        this.startElement(statement);
        final ArrayList declaredVariables = new ArrayList();
        PsiStatement initialization = statement.getInitialization();
        if (initialization != null) {
            initialization.accept(this);
            initialization.accept(new JavaRecursiveElementWalkingVisitor(){

                @Override
                public void visitReferenceExpression(PsiReferenceExpression expression) {
                    this.visitElement(expression);
                }

                @Override
                public void visitDeclarationStatement(PsiDeclarationStatement statement) {
                    PsiElement[] declaredElements;
                    for (PsiElement element : declaredElements = statement.getDeclaredElements()) {
                        if (!(element instanceof PsiVariable)) continue;
                        declaredVariables.add(element);
                    }
                }
            });
        }
        if ((condition = statement.getCondition()) != null) {
            condition.accept(this);
            this.generateBoxingUnboxingInstructionFor(condition, PsiType.BOOLEAN);
        } else {
            this.addInstruction(new PushInstruction(statement.getRParenth() == null ? null : this.myFactory.getConstFactory().getTrue(), null));
        }
        this.addInstruction(new ConditionalGotoInstruction(this.getEndOffset(statement), true, condition));
        PsiStatement body = statement.getBody();
        if (body != null) {
            body.accept(this);
        }
        if ((update = statement.getUpdate()) != null) {
            update.accept(this);
        }
        ControlFlow.ControlFlowOffset offset = initialization != null ? this.getEndOffset(initialization) : this.getStartOffset(statement);
        this.addInstruction(new GotoInstruction(offset));
        this.finishElement(statement);
        for (PsiElement declaredVariable : declaredVariables) {
            PsiVariable psiVariable = (PsiVariable)declaredVariable;
            this.myCurrentFlow.removeVariable(psiVariable);
        }
    }

    @Override
    public void visitIfStatement(PsiIfStatement statement) {
        ControlFlow.ControlFlowOffset offset;
        this.startElement(statement);
        PsiExpression condition = statement.getCondition();
        PsiStatement thenStatement = statement.getThenBranch();
        PsiStatement elseStatement = statement.getElseBranch();
        ControlFlow.ControlFlowOffset controlFlowOffset = offset = elseStatement != null ? this.getStartOffset(elseStatement) : this.getEndOffset(statement);
        if (condition != null) {
            condition.accept(this);
            this.generateBoxingUnboxingInstructionFor(condition, PsiType.BOOLEAN);
            this.addInstruction(new ConditionalGotoInstruction(offset, true, condition));
        }
        if (thenStatement != null) {
            thenStatement.accept(this);
        }
        if (elseStatement != null) {
            offset = this.getEndOffset(statement);
            GotoInstruction instruction = new GotoInstruction(offset);
            this.addInstruction(instruction);
            elseStatement.accept(this);
        }
        this.finishElement(statement);
    }

    @Override
    public void visitStatement(PsiStatement statement) {
        this.startElement(statement);
        this.finishElement(statement);
    }

    @Override
    public void visitLabeledStatement(PsiLabeledStatement statement) {
        this.startElement(statement);
        PsiStatement childStatement = statement.getStatement();
        if (childStatement != null) {
            childStatement.accept(this);
        }
        this.finishElement(statement);
    }

    @Override
    public void visitLambdaExpression(PsiLambdaExpression expression) {
        this.startElement(expression);
        DfaValue dfaValue = this.myFactory.createValue(expression);
        this.addInstruction(new PushInstruction(dfaValue, expression));
        this.addInstruction(new LambdaInstruction(expression));
        this.finishElement(expression);
    }

    @Override
    public void visitReturnStatement(PsiReturnStatement statement) {
        this.startElement(statement);
        PsiExpression returnValue = statement.getReturnValue();
        if (returnValue != null) {
            returnValue.accept(this);
            PsiMethod method = PsiTreeUtil.getParentOfType((PsiElement)statement, PsiMethod.class, true, PsiMember.class, PsiLambdaExpression.class);
            if (method != null) {
                this.generateBoxingUnboxingInstructionFor(returnValue, method.getReturnType());
            } else {
                PsiLambdaExpression lambdaExpression = PsiTreeUtil.getParentOfType((PsiElement)statement, PsiLambdaExpression.class, true, PsiMember.class);
                if (lambdaExpression != null) {
                    this.generateBoxingUnboxingInstructionFor(returnValue, LambdaUtil.getFunctionalInterfaceReturnType(lambdaExpression));
                }
            }
            this.addInstruction(new CheckReturnValueInstruction(returnValue));
        }
        this.addInstruction(new ReturnInstruction(this.myFactory.controlTransfer(ReturnTransfer.INSTANCE, this.myTrapStack), statement));
        this.finishElement(statement);
    }

    @Override
    public void visitSwitchLabelStatement(PsiSwitchLabelStatement statement) {
        this.startElement(statement);
        this.finishElement(statement);
    }

    @Override
    public void visitSwitchStatement(PsiSwitchStatement switchStmt) {
        PsiCodeBlock body;
        this.startElement(switchStmt);
        PsiExpression caseExpression = switchStmt.getExpression();
        HashSet<PsiEnumConstant> enumValues = null;
        if (caseExpression != null) {
            caseExpression.accept(this);
            this.generateBoxingUnboxingInstructionFor(caseExpression, PsiType.INT);
            PsiClass psiClass = PsiUtil.resolveClassInType(caseExpression.getType());
            if (psiClass != null) {
                this.addInstruction(new FieldReferenceInstruction(caseExpression, "switch statement expression"));
                if (psiClass.isEnum()) {
                    enumValues = new HashSet<PsiEnumConstant>();
                    for (PsiField f : psiClass.getFields()) {
                        if (!(f instanceof PsiEnumConstant)) continue;
                        enumValues.add((PsiEnumConstant)f);
                    }
                }
            } else {
                this.addInstruction(new PopInstruction());
            }
        }
        if ((body = switchStmt.getBody()) != null) {
            PsiStatement[] statements = body.getStatements();
            PsiSwitchLabelStatement defaultLabel = null;
            for (PsiStatement statement : statements) {
                if (!(statement instanceof PsiSwitchLabelStatement)) continue;
                PsiSwitchLabelStatement psiLabelStatement = (PsiSwitchLabelStatement)statement;
                if (psiLabelStatement.isDefaultCase()) {
                    defaultLabel = psiLabelStatement;
                    continue;
                }
                try {
                    boolean alwaysTrue;
                    ControlFlow.ControlFlowOffset offset = this.getStartOffset(statement);
                    PsiExpression caseValue = psiLabelStatement.getCaseValue();
                    if (enumValues != null && caseValue instanceof PsiReferenceExpression) {
                        enumValues.remove(((PsiReferenceExpression)caseValue).resolve());
                    }
                    boolean bl = alwaysTrue = enumValues != null && enumValues.isEmpty();
                    if (alwaysTrue) {
                        this.addInstruction(new PushInstruction(this.myFactory.getConstFactory().getTrue(), null));
                    } else if (caseValue != null && caseExpression instanceof PsiReferenceExpression && ((PsiReferenceExpression)caseExpression).getQualifierExpression() == null) {
                        this.addInstruction(new PushInstruction(this.myFactory.createValue(caseExpression), caseExpression));
                        caseValue.accept(this);
                        this.addInstruction(new BinopInstruction(JavaTokenType.EQEQ, null, this.myProject));
                    } else {
                        this.pushUnknown();
                    }
                    this.addInstruction(new ConditionalGotoInstruction(offset, false, statement));
                }
                catch (IncorrectOperationException e) {
                    LOG.error(e);
                }
            }
            if (enumValues == null || !enumValues.isEmpty()) {
                ControlFlow.ControlFlowOffset offset = defaultLabel != null ? this.getStartOffset(defaultLabel) : this.getEndOffset(body);
                this.addInstruction(new GotoInstruction(offset));
            }
            body.accept(this);
        }
        this.finishElement(switchStmt);
    }

    @Override
    public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression) {
        this.startElement(expression);
        PsiExpression qualifier = expression.getQualifierExpression();
        if (qualifier != null) {
            qualifier.accept(this);
            this.addInstruction(new FieldReferenceInstruction(qualifier, "Method reference qualifier"));
        }
        this.addInstruction(new PushInstruction(this.myFactory.createTypeValue(expression.getFunctionalInterfaceType(), Nullness.NOT_NULL), expression));
        this.finishElement(expression);
    }

    @Override
    public void visitSynchronizedStatement(PsiSynchronizedStatement statement) {
        this.startElement(statement);
        PsiExpression lock = statement.getLockExpression();
        if (lock != null) {
            lock.accept(this);
            this.addInstruction(new FieldReferenceInstruction(lock, "Synchronized value"));
        }
        this.addInstruction(new FlushVariableInstruction(null));
        PsiCodeBlock body = statement.getBody();
        if (body != null) {
            body.accept(this);
        }
        this.finishElement(statement);
    }

    @Override
    public void visitThrowStatement(PsiThrowStatement statement) {
        this.startElement(statement);
        PsiExpression exception = statement.getException();
        if (exception != null) {
            exception.accept(this);
            this.addConditionalRuntimeThrow();
            this.addInstruction(new DupInstruction());
            this.addInstruction(new PushInstruction(this.myFactory.getConstFactory().getNull(), null));
            this.addInstruction(new BinopInstruction(JavaTokenType.EQEQ, null, this.myProject));
            ConditionalGotoInstruction gotoInstruction = new ConditionalGotoInstruction(null, true, null);
            this.addInstruction(gotoInstruction);
            this.addInstruction(new FieldReferenceInstruction(exception, "thrown exception"));
            this.throwException(this.myNpe, (PsiElement)statement);
            gotoInstruction.setOffset(this.myCurrentFlow.getInstructionCount());
            this.throwException(exception.getType(), (PsiElement)statement);
        }
        this.finishElement(statement);
    }

    private void addConditionalRuntimeThrow() {
        if (this.myTrapStack.isEmpty()) {
            return;
        }
        this.pushUnknown();
        ConditionalGotoInstruction ifNoException = this.addInstruction(new ConditionalGotoInstruction(null, false, null));
        this.pushUnknown();
        ConditionalGotoInstruction ifError = this.addInstruction(new ConditionalGotoInstruction(null, false, null));
        this.throwException(this.myRuntimeException, null);
        ifError.setOffset(this.myCurrentFlow.getInstructionCount());
        this.throwException(this.myError, null);
        ifNoException.setOffset(this.myCurrentFlow.getInstructionCount());
    }

    @Override
    public void visitTryStatement(PsiTryStatement statement) {
        PsiCatchSection[] sections;
        Trap.TryFinally finallyDescriptor;
        this.startElement(statement);
        PsiResourceList resourceList = statement.getResourceList();
        PsiCodeBlock tryBlock = statement.getTryBlock();
        PsiCodeBlock finallyBlock = statement.getFinallyBlock();
        Trap.TryFinally tryFinally = finallyDescriptor = finallyBlock != null ? new Trap.TryFinally(finallyBlock, this.getStartOffset(finallyBlock)) : null;
        if (finallyDescriptor != null) {
            this.myTrapStack = this.myTrapStack.prepend(finallyDescriptor);
        }
        if ((sections = statement.getCatchSections()).length > 0) {
            LinkedHashMap<PsiCatchSection, ControlFlow.ControlFlowOffset> clauses = new LinkedHashMap<PsiCatchSection, ControlFlow.ControlFlowOffset>();
            for (PsiCatchSection section : sections) {
                PsiCodeBlock catchBlock = section.getCatchBlock();
                if (catchBlock == null) continue;
                clauses.put(section, this.getStartOffset(catchBlock));
            }
            this.myTrapStack = this.myTrapStack.prepend(new Trap.TryCatch(statement, clauses));
        }
        if (resourceList != null) {
            resourceList.accept(this);
        }
        if (tryBlock != null) {
            tryBlock.accept(this);
        }
        InstructionTransfer gotoEnd = new InstructionTransfer(this.getEndOffset(statement), this.getVariablesInside(tryBlock));
        FList<Trap> singleFinally = FList.createFromReversed(ContainerUtil.createMaybeSingletonList(finallyDescriptor));
        this.controlTransfer(gotoEnd, singleFinally);
        if (sections.length > 0) {
            assert (this.myTrapStack.getHead() instanceof Trap.TryCatch);
            this.myTrapStack = this.myTrapStack.getTail();
        }
        for (PsiCatchSection section : sections) {
            PsiCodeBlock catchBlock = section.getCatchBlock();
            if (catchBlock != null) {
                this.visitCodeBlock(catchBlock);
            }
            this.controlTransfer(gotoEnd, singleFinally);
        }
        if (finallyBlock != null) {
            assert (this.myTrapStack.getHead() instanceof Trap.TryFinally);
            this.myTrapStack = this.myTrapStack.getTail().prepend(new Trap.InsideFinally(finallyBlock));
            finallyBlock.accept(this);
            this.addInstruction(new ControlTransferInstruction(null));
            assert (this.myTrapStack.getHead() instanceof Trap.InsideFinally);
            this.myTrapStack = this.myTrapStack.getTail();
        }
        this.finishElement(statement);
    }

    @Override
    public void visitResourceList(PsiResourceList resourceList) {
        for (PsiResourceListElement resource : resourceList) {
            List<PsiClassType> closerExceptions;
            if (resource instanceof PsiResourceVariable) {
                PsiResourceVariable variable = (PsiResourceVariable)resource;
                PsiExpression initializer = variable.getInitializer();
                if (initializer != null) {
                    this.initializeVariable(variable, initializer);
                }
            } else if (resource instanceof PsiResourceExpression) {
                ((PsiResourceExpression)resource).getExpression().accept(this);
            }
            if ((closerExceptions = ExceptionUtil.getCloserExceptions(resource)).isEmpty()) continue;
            this.addThrows(null, closerExceptions.toArray(new PsiClassType[closerExceptions.size()]));
        }
    }

    @Override
    public void visitWhileStatement(PsiWhileStatement statement) {
        this.startElement(statement);
        PsiExpression condition = statement.getCondition();
        if (condition != null) {
            condition.accept(this);
            this.generateBoxingUnboxingInstructionFor(condition, PsiType.BOOLEAN);
        } else {
            this.pushUnknown();
        }
        this.addInstruction(new ConditionalGotoInstruction(this.getEndOffset(statement), true, condition));
        PsiStatement body = statement.getBody();
        if (body != null) {
            body.accept(this);
        }
        this.addInstruction(new GotoInstruction(this.getStartOffset(statement)));
        this.finishElement(statement);
    }

    @Override
    public void visitExpressionList(PsiExpressionList list) {
        PsiExpression[] expressions;
        this.startElement(list);
        for (PsiExpression expression : expressions = list.getExpressions()) {
            expression.accept(this);
        }
        this.finishElement(list);
    }

    @Override
    public void visitExpression(PsiExpression expression) {
        this.startElement(expression);
        DfaValue dfaValue = this.myFactory.createValue(expression);
        this.addInstruction(new PushInstruction(dfaValue, expression));
        this.finishElement(expression);
    }

    @Override
    public void visitArrayAccessExpression(PsiArrayAccessExpression expression) {
        DfaValue toPush;
        this.startElement(expression);
        PsiExpression arrayExpression = expression.getArrayExpression();
        arrayExpression.accept(this);
        this.addInstruction(new FieldReferenceInstruction(expression, null));
        PsiExpression indexExpression = expression.getIndexExpression();
        if (indexExpression != null) {
            indexExpression.accept(this);
            this.generateBoxingUnboxingInstructionFor(indexExpression, PsiType.INT);
            this.addInstruction(new PopInstruction());
        }
        this.addInstruction(new PushInstruction((toPush = this.myFactory.createValue(expression)) != null ? toPush : this.myFactory.createTypeValue(expression.getType(), Nullness.UNKNOWN), null));
        this.finishElement(expression);
    }

    @Override
    public void visitArrayInitializerExpression(PsiArrayInitializerExpression expression) {
        PsiExpression[] initializers;
        this.startElement(expression);
        PsiType type = expression.getType();
        for (PsiExpression initializer : initializers = expression.getInitializers()) {
            initializer.accept(this);
            if (type instanceof PsiArrayType) {
                this.generateBoxingUnboxingInstructionFor(initializer, ((PsiArrayType)type).getComponentType());
            }
            this.addInstruction(new PopInstruction());
        }
        this.pushUnknown();
        this.finishElement(expression);
    }

    @Override
    public void visitPolyadicExpression(PsiPolyadicExpression expression) {
        this.startElement(expression);
        DfaValue dfaValue = this.myFactory.createValue(expression);
        if (dfaValue != null) {
            this.addInstruction(new PushInstruction(dfaValue, expression));
            this.finishElement(expression);
            return;
        }
        IElementType op = expression.getOperationTokenType();
        PsiExpression[] operands = expression.getOperands();
        if (operands.length <= 1) {
            this.pushUnknown();
            this.finishElement(expression);
            return;
        }
        PsiType type = expression.getType();
        if (op == JavaTokenType.ANDAND) {
            this.generateAndExpression(operands, type, true);
        } else if (op == JavaTokenType.OROR) {
            this.generateOrExpression(operands, type, true);
        } else if (op == JavaTokenType.XOR && PsiType.BOOLEAN.equals(type)) {
            this.generateXorExpression(expression, operands, type, false);
        } else if (op == JavaTokenType.AND && PsiType.BOOLEAN.equals(type)) {
            this.generateAndExpression(operands, type, false);
        } else if (op == JavaTokenType.OR && PsiType.BOOLEAN.equals(type)) {
            this.generateOrExpression(operands, type, false);
        } else {
            this.generateOther(expression, op, operands, type);
        }
        this.finishElement(expression);
    }

    private void generateOther(PsiPolyadicExpression expression, IElementType op, PsiExpression[] operands, PsiType type) {
        op = ControlFlowAnalyzer.substituteBinaryOperation(op, type);
        PsiExpression lExpr = operands[0];
        lExpr.accept(this);
        PsiType lType = lExpr.getType();
        for (int i2 = 1; i2 < operands.length; ++i2) {
            PsiExpression rExpr = operands[i2];
            PsiType rType = rExpr.getType();
            this.acceptBinaryRightOperand(op, type, lExpr, lType, rExpr, rType);
            this.addInstruction(new BinopInstruction(op, expression.isPhysical() ? expression : null, this.myProject));
            lExpr = rExpr;
            lType = rType;
        }
    }

    @Nullable
    private static IElementType substituteBinaryOperation(IElementType op, PsiType type) {
        if (!(JavaTokenType.PLUS != op || type != null && type.equalsToText("java.lang.String"))) {
            return null;
        }
        return op;
    }

    private void acceptBinaryRightOperand(@Nullable IElementType op, PsiType type, PsiExpression lExpr, PsiType lType, PsiExpression rExpr, PsiType rType) {
        PsiType castType;
        boolean comparingPrimitiveNumeric;
        boolean comparing = op == JavaTokenType.EQEQ || op == JavaTokenType.NE;
        boolean comparingRef = comparing && !TypeConversionUtil.isPrimitiveAndNotNull(lType) && !TypeConversionUtil.isPrimitiveAndNotNull(rType);
        boolean bl = comparingPrimitiveNumeric = comparing && TypeConversionUtil.isPrimitiveAndNotNull(lType) && TypeConversionUtil.isPrimitiveAndNotNull(rType) && TypeConversionUtil.isNumericType(lType) && TypeConversionUtil.isNumericType(rType);
        PsiType psiType = comparingPrimitiveNumeric ? (TypeConversionUtil.isFloatOrDoubleType(lType) ? PsiType.DOUBLE : PsiType.LONG) : (castType = type);
        if (!comparingRef) {
            this.generateBoxingUnboxingInstructionFor(lExpr, castType);
        }
        rExpr.accept(this);
        if (!comparingRef) {
            this.generateBoxingUnboxingInstructionFor(rExpr, castType);
        }
    }

    private void generateBoxingUnboxingInstructionFor(@NotNull PsiExpression expression, PsiType expectedType) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInspection/dataFlow/ControlFlowAnalyzer", "generateBoxingUnboxingInstructionFor"));
        }
        if (PsiType.VOID.equals(expectedType)) {
            return;
        }
        PsiType exprType = expression.getType();
        if (TypeConversionUtil.isPrimitiveAndNotNull(expectedType) && TypeConversionUtil.isPrimitiveWrapper(exprType)) {
            this.addInstruction(new MethodCallInstruction(expression, MethodCallInstruction.MethodType.UNBOXING, expectedType));
        } else if (TypeConversionUtil.isAssignableFromPrimitiveWrapper(expectedType) && TypeConversionUtil.isPrimitiveAndNotNull(exprType)) {
            this.addConditionalRuntimeThrow();
            this.addInstruction(new MethodCallInstruction(expression, MethodCallInstruction.MethodType.BOXING, expectedType));
        } else if (exprType != expectedType && TypeConversionUtil.isPrimitiveAndNotNull(exprType) && TypeConversionUtil.isPrimitiveAndNotNull(expectedType) && TypeConversionUtil.isNumericType(exprType) && TypeConversionUtil.isNumericType(expectedType)) {
            this.addInstruction(new MethodCallInstruction(expression, MethodCallInstruction.MethodType.CAST, expectedType){

                @Override
                public DfaInstructionState[] accept(DataFlowRunner runner, DfaMemoryState stateBefore, InstructionVisitor visitor) {
                    return visitor.visitCast(this, runner, stateBefore);
                }
            });
        }
    }

    private void generateXorExpression(PsiExpression expression, PsiExpression[] operands, PsiType exprType, boolean forAssignment) {
        PsiExpression operand = operands[0];
        operand.accept(this);
        if (forAssignment) {
            this.addInstruction(new DupInstruction());
        }
        this.generateBoxingUnboxingInstructionFor(operand, exprType);
        for (int i2 = 1; i2 < operands.length; ++i2) {
            operand = operands[i2];
            operand.accept(this);
            this.generateBoxingUnboxingInstructionFor(operand, exprType);
            PsiExpression psiAnchor = i2 == operands.length - 1 && expression.isPhysical() ? expression : null;
            this.addInstruction(new BinopInstruction(JavaTokenType.NE, psiAnchor, this.myProject));
        }
    }

    private void generateOrExpression(PsiExpression[] operands, PsiType exprType, boolean shortCircuit) {
        for (int i2 = 0; i2 < operands.length; ++i2) {
            PsiExpression nextOperand;
            PsiExpression operand = operands[i2];
            operand.accept(this);
            this.generateBoxingUnboxingInstructionFor(operand, exprType);
            if (!shortCircuit) {
                if (i2 <= 0) continue;
                this.combineStackBooleans(false, operand);
                continue;
            }
            PsiExpression psiExpression = nextOperand = i2 == operands.length - 1 ? null : operands[i2 + 1];
            if (nextOperand == null) continue;
            this.addInstruction(new ConditionalGotoInstruction(this.getStartOffset(nextOperand), true, operand));
            this.addInstruction(new PushInstruction(this.myFactory.getConstFactory().getTrue(), null));
            this.addInstruction(new GotoInstruction(this.getEndOffset(operands[operands.length - 1])));
        }
    }

    private void generateBooleanAssignmentExpression(boolean and, PsiExpression lExpression, PsiExpression rExpression, PsiType exprType) {
        lExpression.accept(this);
        this.generateBoxingUnboxingInstructionFor(lExpression, exprType);
        this.addInstruction(new DupInstruction());
        rExpression.accept(this);
        this.generateBoxingUnboxingInstructionFor(rExpression, exprType);
        this.addInstruction(new SwapInstruction());
        this.combineStackBooleans(and, lExpression);
    }

    private void combineStackBooleans(boolean and, PsiExpression anchor) {
        ConditionalGotoInstruction toPopAndPushSuccess = new ConditionalGotoInstruction(null, and, anchor);
        this.addInstruction(toPopAndPushSuccess);
        GotoInstruction overPushSuccess = new GotoInstruction(null);
        this.addInstruction(overPushSuccess);
        PopInstruction pop = new PopInstruction();
        this.addInstruction(pop);
        DfaConstValue constValue = and ? this.myFactory.getConstFactory().getFalse() : this.myFactory.getConstFactory().getTrue();
        PushInstruction pushSuccess = new PushInstruction(constValue, null);
        this.addInstruction(pushSuccess);
        toPopAndPushSuccess.setOffset(pop.getIndex());
        overPushSuccess.setOffset(pushSuccess.getIndex() + 1);
    }

    private void generateAndExpression(PsiExpression[] operands, PsiType exprType, boolean shortCircuit) {
        ArrayList<ConditionalGotoInstruction> branchToFail = new ArrayList<ConditionalGotoInstruction>();
        for (int i2 = 0; i2 < operands.length; ++i2) {
            PsiExpression operand = operands[i2];
            operand.accept(this);
            this.generateBoxingUnboxingInstructionFor(operand, exprType);
            if (!shortCircuit) {
                if (i2 <= 0) continue;
                this.combineStackBooleans(true, operand);
                continue;
            }
            ConditionalGotoInstruction onFail = new ConditionalGotoInstruction(null, true, operand);
            branchToFail.add(onFail);
            this.addInstruction(onFail);
        }
        if (!shortCircuit) {
            return;
        }
        this.addInstruction(new PushInstruction(this.myFactory.getConstFactory().getTrue(), null));
        GotoInstruction toSuccess = new GotoInstruction(null);
        this.addInstruction(toSuccess);
        PushInstruction pushFalse = new PushInstruction(this.myFactory.getConstFactory().getFalse(), null);
        this.addInstruction(pushFalse);
        for (ConditionalGotoInstruction toFail : branchToFail) {
            toFail.setOffset(pushFalse.getIndex());
        }
        toSuccess.setOffset(pushFalse.getIndex() + 1);
    }

    @Override
    public void visitClassObjectAccessExpression(PsiClassObjectAccessExpression expression) {
        this.startElement(expression);
        this.addInstruction(new PushInstruction(this.myFactory.createTypeValue(expression.getType(), Nullness.NOT_NULL), expression));
        this.finishElement(expression);
    }

    @Override
    public void visitConditionalExpression(PsiConditionalExpression expression) {
        ControlFlow.ControlFlowOffset elseOffset;
        this.startElement(expression);
        PsiExpression condition = expression.getCondition();
        PsiExpression thenExpression = expression.getThenExpression();
        PsiExpression elseExpression = expression.getElseExpression();
        ControlFlow.ControlFlowOffset controlFlowOffset = elseOffset = elseExpression == null ? ControlFlow.deltaOffset(this.getEndOffset(expression), -1) : this.getStartOffset(elseExpression);
        if (thenExpression != null) {
            condition.accept(this);
            this.generateBoxingUnboxingInstructionFor(condition, PsiType.BOOLEAN);
            PsiType type = expression.getType();
            this.addInstruction(new ConditionalGotoInstruction(elseOffset, true, PsiUtil.skipParenthesizedExprDown(condition)));
            thenExpression.accept(this);
            this.generateBoxingUnboxingInstructionFor(thenExpression, type);
            this.addInstruction(new GotoInstruction(this.getEndOffset(expression)));
            if (elseExpression != null) {
                elseExpression.accept(this);
                this.generateBoxingUnboxingInstructionFor(elseExpression, type);
            } else {
                this.pushUnknown();
            }
        } else {
            this.pushUnknown();
        }
        this.finishElement(expression);
    }

    private void pushUnknown() {
        this.addInstruction(new PushInstruction(DfaUnknownValue.getInstance(), null));
    }

    @Override
    public void visitInstanceOfExpression(PsiInstanceOfExpression expression) {
        this.startElement(expression);
        PsiExpression operand = expression.getOperand();
        PsiTypeElement checkType = expression.getCheckType();
        if (checkType != null) {
            operand.accept(this);
            PsiType type = checkType.getType();
            if (type instanceof PsiClassType) {
                type = ((PsiClassType)type).rawType();
            }
            this.addInstruction(new PushInstruction(this.myFactory.createTypeValue(type, Nullness.UNKNOWN), null));
            this.addInstruction(new InstanceofInstruction(expression, this.myProject, operand, type));
        } else {
            this.pushUnknown();
        }
        this.finishElement(expression);
    }

    private void addMethodThrows(PsiMethod method, @Nullable PsiElement explicitCall) {
        if (method != null) {
            this.addThrows(explicitCall, method.getThrowsList().getReferencedTypes());
        }
    }

    private void addThrows(@Nullable PsiElement explicitCall, PsiClassType[] refs) {
        for (PsiClassType ref : refs) {
            this.pushUnknown();
            ConditionalGotoInstruction cond = new ConditionalGotoInstruction(null, false, null);
            this.addInstruction(cond);
            this.throwException(ref, explicitCall);
            cond.setOffset(this.myCurrentFlow.getInstructionCount());
        }
    }

    private void throwException(PsiType ref, @Nullable PsiElement anchor) {
        this.throwException(new ExceptionTransfer(this.myFactory.createTypeValue(ref, Nullness.NOT_NULL)), anchor);
    }

    private void throwException(ExceptionTransfer kind, @Nullable PsiElement anchor) {
        this.addInstruction(new EmptyStackInstruction());
        this.addInstruction(new ReturnInstruction(this.myFactory.controlTransfer(kind, this.myTrapStack), anchor));
    }

    @Override
    public void visitMethodCallExpression(PsiMethodCallExpression expression) {
        this.startElement(expression);
        PsiReferenceExpression methodExpression = expression.getMethodExpression();
        PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
        if (qualifierExpression != null) {
            qualifierExpression.accept(this);
        } else {
            this.pushUnknown();
        }
        PsiExpression[] expressions = expression.getArgumentList().getExpressions();
        PsiElement method = methodExpression.resolve();
        PsiParameter[] parameters = method instanceof PsiMethod ? ((PsiMethod)method).getParameterList().getParameters() : null;
        boolean isEqualsCall = expressions.length == 1 && method instanceof PsiMethod && "equals".equals(((PsiMethod)method).getName()) && parameters.length == 1 && parameters[0].getType().equalsToText("java.lang.Object") && PsiType.BOOLEAN.equals(((PsiMethod)method).getReturnType());
        for (int i2 = 0; i2 < expressions.length; ++i2) {
            PsiExpression paramExpr = expressions[i2];
            paramExpr.accept(this);
            if (parameters != null && i2 < parameters.length) {
                this.generateBoxingUnboxingInstructionFor(paramExpr, parameters[i2].getType());
            }
            if (i2 != 0 || !isEqualsCall) continue;
            this.addInstruction(new SwapInstruction());
            this.addInstruction(new DupInstruction(2, 1));
            this.addInstruction(new PopInstruction());
        }
        this.addConditionalRuntimeThrow();
        List<MethodContract> contracts = method instanceof PsiMethod ? ControlFlowAnalyzer.getMethodCallContracts((PsiMethod)method, expression) : Collections.emptyList();
        this.addInstruction(new MethodCallInstruction(expression, this.myFactory.createValue(expression), contracts));
        if (!contracts.isEmpty()) {
            this.addInstruction(new DupInstruction());
            this.addInstruction(new PushInstruction(this.myFactory.getConstFactory().getContractFail(), null));
            this.addInstruction(new BinopInstruction(JavaTokenType.EQEQ, null, this.myProject));
            ConditionalGotoInstruction ifNotFail = new ConditionalGotoInstruction(null, true, null);
            this.addInstruction(ifNotFail);
            this.addInstruction(new EmptyStackInstruction());
            this.addInstruction(new ReturnInstruction(this.myFactory.controlTransfer(new ExceptionTransfer(DfaUnknownValue.getInstance()), this.myTrapStack), expression));
            ifNotFail.setOffset(this.myCurrentFlow.getInstructionCount());
        }
        if (!this.myTrapStack.isEmpty()) {
            this.addMethodThrows(expression.resolveMethod(), expression);
        }
        if (isEqualsCall) {
            ConditionalGotoInstruction ifFalse = this.addInstruction(new ConditionalGotoInstruction(null, true, null));
            this.addInstruction(new ApplyNotNullInstruction(expression));
            this.addInstruction(new PushInstruction(this.myFactory.getConstFactory().getTrue(), null));
            this.addInstruction(new GotoInstruction(this.getEndOffset(expression)));
            ifFalse.setOffset(this.myCurrentFlow.getInstructionCount());
            this.addInstruction(new PopInstruction());
            this.addInstruction(new PushInstruction(this.myFactory.getConstFactory().getFalse(), null));
        }
        this.finishElement(expression);
    }

    private static List<MethodContract> getMethodCallContracts(@NotNull PsiMethod method, @NotNull PsiMethodCallExpression call) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/dataFlow/ControlFlowAnalyzer", "getMethodCallContracts"));
        }
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/codeInspection/dataFlow/ControlFlowAnalyzer", "getMethodCallContracts"));
        }
        List<MethodContract> contracts = HardcodedContracts.getHardcodedContracts(method, call);
        return !contracts.isEmpty() ? contracts : ControlFlowAnalyzer.getMethodContracts(method);
    }

    static List<MethodContract> getMethodContracts(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/dataFlow/ControlFlowAnalyzer", "getMethodContracts"));
        }
        return (List)CachedValuesManager.getCachedValue(method, () -> {
            String text;
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/dataFlow/ControlFlowAnalyzer", "lambda$getMethodContracts$3"));
            }
            PsiAnnotation contractAnno = ControlFlowAnalyzer.findContractAnnotation(method);
            if (contractAnno != null && (text = AnnotationUtil.getStringAttributeValue(contractAnno, null)) != null) {
                try {
                    int paramCount = method.getParameterList().getParametersCount();
                    List<MethodContract> applicable = ContainerUtil.filter(MethodContract.parseContract(text), contract -> contract.arguments.length == paramCount);
                    return CachedValueProvider.Result.create(applicable, contractAnno, method, PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return CachedValueProvider.Result.create(Collections.emptyList(), method, PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT);
        });
    }

    @Nullable
    public static PsiAnnotation findContractAnnotation(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/dataFlow/ControlFlowAnalyzer", "findContractAnnotation"));
        }
        return AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)method, Collections.singleton(ORG_JETBRAINS_ANNOTATIONS_CONTRACT));
    }

    public static boolean isPure(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/dataFlow/ControlFlowAnalyzer", "isPure"));
        }
        PsiAnnotation anno = ControlFlowAnalyzer.findContractAnnotation(method);
        return anno != null && Boolean.TRUE.equals(AnnotationUtil.getBooleanAttributeValue(anno, "pure"));
    }

    @Override
    public void visitEnumConstant(PsiEnumConstant enumConstant) {
        if (enumConstant.getArgumentList() == null) {
            return;
        }
        this.pushUnknown();
        this.pushConstructorArguments(enumConstant);
        this.addInstruction(new MethodCallInstruction(enumConstant, null, Collections.emptyList()));
        this.addInstruction(new PopInstruction());
    }

    @Override
    public void visitNewExpression(PsiNewExpression expression) {
        this.startElement(expression);
        this.pushUnknown();
        if (expression.getType() instanceof PsiArrayType) {
            PsiExpression[] dimensions;
            for (PsiExpression dimension : dimensions = expression.getArrayDimensions()) {
                dimension.accept(this);
            }
            for (PsiExpression ignored : dimensions) {
                this.addInstruction(new PopInstruction());
            }
            PsiArrayInitializerExpression arrayInitializer = expression.getArrayInitializer();
            if (arrayInitializer != null) {
                for (PsiExpression initializer : arrayInitializer.getInitializers()) {
                    initializer.accept(this);
                    this.addInstruction(new PopInstruction());
                }
            }
            this.addConditionalRuntimeThrow();
            this.addInstruction(new MethodCallInstruction(expression, null, Collections.emptyList()));
        } else {
            PsiMethod constructor = this.pushConstructorArguments(expression);
            this.addConditionalRuntimeThrow();
            this.addInstruction(new MethodCallInstruction(expression, null, constructor == null ? Collections.emptyList() : ControlFlowAnalyzer.getMethodContracts(constructor)));
            if (!this.myTrapStack.isEmpty()) {
                this.addMethodThrows(constructor, expression);
            }
        }
        this.finishElement(expression);
    }

    @Nullable
    private PsiMethod pushConstructorArguments(PsiConstructorCall call) {
        PsiExpressionList args = call.getArgumentList();
        PsiMethod ctr = call.resolveConstructor();
        if (args != null) {
            PsiExpression[] params = args.getExpressions();
            PsiParameter[] parameters = ctr == null ? null : ctr.getParameterList().getParameters();
            for (int i2 = 0; i2 < params.length; ++i2) {
                PsiExpression param = params[i2];
                param.accept(this);
                if (parameters == null || i2 >= parameters.length) continue;
                this.generateBoxingUnboxingInstructionFor(param, parameters[i2].getType());
            }
        }
        return ctr;
    }

    @Override
    public void visitParenthesizedExpression(PsiParenthesizedExpression expression) {
        this.startElement(expression);
        PsiExpression inner = expression.getExpression();
        if (inner != null) {
            inner.accept(this);
        } else {
            this.pushUnknown();
        }
        this.finishElement(expression);
    }

    @Override
    public void visitPostfixExpression(PsiPostfixExpression expression) {
        this.startElement(expression);
        PsiExpression operand = PsiUtil.skipParenthesizedExprDown(expression.getOperand());
        if (operand != null) {
            operand.accept(this);
            this.generateBoxingUnboxingInstructionFor(operand, PsiType.INT);
        } else {
            this.pushUnknown();
        }
        this.addInstruction(new PopInstruction());
        this.pushUnknown();
        this.flushIncrementedValue(operand);
        this.finishElement(expression);
    }

    @Override
    public void visitPrefixExpression(PsiPrefixExpression expression) {
        this.startElement(expression);
        DfaValue dfaValue = this.myFactory.createValue(expression);
        if (dfaValue == null) {
            PsiExpression operand = PsiUtil.skipParenthesizedExprDown(expression.getOperand());
            if (operand == null) {
                this.pushUnknown();
            } else {
                operand.accept(this);
                PsiType type = expression.getType();
                PsiPrimitiveType unboxed = PsiPrimitiveType.getUnboxedType(type);
                this.generateBoxingUnboxingInstructionFor(operand, unboxed == null ? type : unboxed);
                if (expression.getOperationTokenType() == JavaTokenType.EXCL) {
                    this.addInstruction(new NotInstruction());
                } else {
                    this.addInstruction(new PopInstruction());
                    this.pushUnknown();
                    this.flushIncrementedValue(operand);
                }
            }
        } else {
            this.addInstruction(new PushInstruction(dfaValue, expression));
        }
        this.finishElement(expression);
    }

    private void flushIncrementedValue(@Nullable PsiExpression operand) {
        DfaValue dfaVariable;
        DfaValue dfaValue = dfaVariable = operand == null ? null : this.myFactory.createValue(operand);
        if (dfaVariable instanceof DfaVariableValue && PsiUtil.isAccessedForWriting(operand)) {
            this.addInstruction(new FlushVariableInstruction((DfaVariableValue)dfaVariable));
            if (((DfaVariableValue)dfaVariable).getPsiVariable() instanceof PsiField) {
                this.addInstruction(new FlushVariableInstruction(null));
            }
        }
    }

    @Override
    public void visitReferenceExpression(PsiReferenceExpression expression) {
        this.startElement(expression);
        PsiExpression qualifierExpression = expression.getQualifierExpression();
        if (qualifierExpression != null) {
            qualifierExpression.accept(this);
            this.addInstruction(expression.resolve() instanceof PsiField ? new FieldReferenceInstruction(expression, null) : new PopInstruction());
        }
        boolean writing = PsiUtil.isAccessedForWriting(expression) && !PsiUtil.isAccessedForReading(expression);
        this.addInstruction(new PushInstruction(this.myFactory.createValue(expression), expression, writing));
        this.finishElement(expression);
    }

    @Override
    public void visitSuperExpression(PsiSuperExpression expression) {
        this.startElement(expression);
        this.addInstruction(new PushInstruction(this.myFactory.createTypeValue(expression.getType(), Nullness.NOT_NULL), null));
        this.finishElement(expression);
    }

    @Override
    public void visitThisExpression(PsiThisExpression expression) {
        this.startElement(expression);
        this.addInstruction(new PushInstruction(this.myFactory.createTypeValue(expression.getType(), Nullness.NOT_NULL), null));
        this.finishElement(expression);
    }

    @Override
    public void visitLiteralExpression(PsiLiteralExpression expression) {
        this.startElement(expression);
        DfaValue dfaValue = this.myFactory.createLiteralValue(expression);
        this.addInstruction(new PushInstruction(dfaValue, expression));
        this.finishElement(expression);
    }

    @Override
    public void visitTypeCastExpression(PsiTypeCastExpression castExpression) {
        this.startElement(castExpression);
        PsiExpression operand = castExpression.getOperand();
        if (operand != null) {
            operand.accept(this);
            this.generateBoxingUnboxingInstructionFor(operand, castExpression.getType());
        } else {
            this.addInstruction(new PushInstruction(this.myFactory.createTypeValue(castExpression.getType(), Nullness.UNKNOWN), null));
        }
        PsiTypeElement typeElement = castExpression.getCastType();
        if (typeElement != null && operand != null && operand.getType() != null) {
            if (typeElement.getType() instanceof PsiPrimitiveType && UnnecessaryExplicitNumericCastInspection.isPrimitiveNumericCastNecessary(castExpression)) {
                this.addInstruction(new PopInstruction());
                this.pushUnknown();
            } else {
                this.addInstruction(new TypeCastInstruction(castExpression, operand, typeElement.getType()));
            }
        }
        this.finishElement(castExpression);
    }

    @Override
    public void visitClass(PsiClass aClass) {
    }

    private static class ApplyNotNullInstruction
    extends Instruction {
        private final PsiMethodCallExpression myCall;

        private ApplyNotNullInstruction(PsiMethodCallExpression call) {
            this.myCall = call;
        }

        @Override
        public DfaInstructionState[] accept(DataFlowRunner runner, DfaMemoryState state, InstructionVisitor visitor) {
            DfaValue value = state.pop();
            DfaValueFactory factory = runner.getFactory();
            if (state.applyCondition(factory.getRelationFactory().createRelation(value, factory.getConstFactory().getNull(), JavaTokenType.EQEQ, true))) {
                return this.nextInstruction(runner, state);
            }
            if (visitor instanceof StandardInstructionVisitor) {
                ((StandardInstructionVisitor)visitor).skipConstantConditionReporting(this.myCall);
            }
            return DfaInstructionState.EMPTY_ARRAY;
        }
    }

    private static class CannotAnalyzeException
    extends RuntimeException {
        private CannotAnalyzeException() {
        }
    }
}

