/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.export;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.HTMLComposerImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.containers.HashMap;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;

public class HTMLExporter {
    private final String myRootFolder;
    private int myFileCounter;
    private final Map<RefEntity, String> myElementToFilenameMap;
    private final HTMLComposerImpl myComposer;
    private final Set<RefEntity> myGeneratedReferences;

    public HTMLExporter(String rootFolder, HTMLComposerImpl composer) {
        this.myRootFolder = rootFolder;
        this.myElementToFilenameMap = new HashMap<RefEntity, String>();
        this.myFileCounter = 0;
        this.myComposer = composer;
        this.myGeneratedReferences = new HashSet<RefEntity>();
    }

    public String createPage(RefEntity element) {
        StringBuffer buf = new StringBuffer();
        this.myComposer.composeWithExporter(buf, element, this);
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFileImpl(String folder, @NonNls String fileName, CharSequence buf) throws IOException {
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        String fullPath = folder + File.separator + fileName;
        if (indicator != null) {
            ProgressManager.checkCanceled();
            indicator.setText(InspectionsBundle.message("inspection.export.generating.html.for", fullPath));
        }
        OutputStreamWriter writer = null;
        try {
            File folderFile = new File(folder);
            folderFile.mkdirs();
            new File(fullPath).getParentFile().mkdirs();
            writer = new FileWriter(fullPath);
            writer.write(buf.toString().toCharArray());
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public String getURL(RefEntity element) {
        this.myGeneratedReferences.add(element);
        return this.fileNameForElement(element);
    }

    public String fileNameForElement(RefEntity element) {
        String fileName = this.myElementToFilenameMap.get(element);
        if (fileName == null) {
            fileName = "e" + Integer.toString(++this.myFileCounter) + ".html";
            this.myElementToFilenameMap.put(element, fileName);
        }
        return fileName;
    }

    public String getRootFolder() {
        return this.myRootFolder;
    }
}

