/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.miscGenerics;

import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RawTypeCanBeGenericInspection
extends BaseJavaBatchLocalInspectionTool {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/miscGenerics/RawTypeCanBeGenericInspection", "buildVisitor"));
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            @Override
            public void visitVariable(PsiVariable variable) {
                PsiType type;
                super.visitVariable(variable);
                PsiTypeElement variableTypeElement = variable.getTypeElement();
                if (variableTypeElement != null && (type = RawTypeCanBeGenericInspection.getSuggestedType(variable)) != null) {
                    String typeText = type.getPresentableText();
                    String message = InspectionsBundle.message("inspection.raw.variable.type.can.be.generic.quickfix", variable.getName(), typeText);
                    PsiElement beforeInitializer = PsiTreeUtil.skipSiblingsBackward(variable.getInitializer(), PsiWhiteSpace.class, PsiComment.class);
                    ProblemDescriptor descriptor = holder.getManager().createProblemDescriptor((PsiElement)variableTypeElement, beforeInitializer != null ? beforeInitializer : variableTypeElement, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly, new MyLocalQuickFix(message));
                    holder.registerProblem(descriptor);
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/miscGenerics/RawTypeCanBeGenericInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    @Nullable
    private static PsiType getSuggestedType(@NotNull PsiVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/codeInspection/miscGenerics/RawTypeCanBeGenericInspection", "getSuggestedType"));
        }
        PsiExpression initializer = variable.getInitializer();
        if (initializer == null) {
            return null;
        }
        PsiType variableType = variable.getType();
        PsiType initializerType = initializer.getType();
        if (!(variableType instanceof PsiClassType)) {
            return null;
        }
        PsiClassType variableClassType = (PsiClassType)variableType;
        if (!variableClassType.isRaw()) {
            return null;
        }
        if (!(initializerType instanceof PsiClassType)) {
            return null;
        }
        PsiClassType initializerClassType = (PsiClassType)initializerType;
        if (initializerClassType.isRaw()) {
            return null;
        }
        PsiClassType.ClassResolveResult variableResolveResult = variableClassType.resolveGenerics();
        PsiClassType.ClassResolveResult initializerResolveResult = initializerClassType.resolveGenerics();
        if (initializerResolveResult.getElement() == null) {
            return null;
        }
        PsiClass variableResolved = variableResolveResult.getElement();
        if (variableResolved == null) {
            return null;
        }
        PsiSubstitutor targetSubstitutor = TypeConversionUtil.getClassSubstitutor(variableResolved, initializerResolveResult.getElement(), initializerResolveResult.getSubstitutor());
        if (targetSubstitutor == null) {
            return null;
        }
        PsiClassType type = JavaPsiFacade.getInstance(variable.getProject()).getElementFactory().createType(variableResolved, targetSubstitutor);
        if (variableType.equals(type)) {
            return null;
        }
        return type;
    }

    private static class MyLocalQuickFix
    implements LocalQuickFix {
        private String myName;

        public MyLocalQuickFix(@NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/codeInspection/miscGenerics/RawTypeCanBeGenericInspection$MyLocalQuickFix", "<init>"));
            }
            this.myName = name;
        }

        @Override
        @Nls
        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/miscGenerics/RawTypeCanBeGenericInspection$MyLocalQuickFix", "getName"));
            }
            return string;
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            String string = InspectionsBundle.message("inspection.raw.variable.type.can.be.generic.family.quickfix", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/miscGenerics/RawTypeCanBeGenericInspection$MyLocalQuickFix", "getFamilyName"));
            }
            return string;
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiType type;
            PsiVariable variable;
            PsiTypeElement typeElement;
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/miscGenerics/RawTypeCanBeGenericInspection$MyLocalQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/miscGenerics/RawTypeCanBeGenericInspection$MyLocalQuickFix", "applyFix"));
            }
            PsiElement element = descriptor.getStartElement().getParent();
            if (element instanceof PsiVariable && (typeElement = (variable = (PsiVariable)element).getTypeElement()) != null && (type = RawTypeCanBeGenericInspection.getSuggestedType(variable)) != null) {
                PsiElementFactory factory = JavaPsiFacade.getInstance(variable.getProject()).getElementFactory();
                typeElement.replace(factory.createTypeElement(type));
            }
        }
    }
}

