/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.util;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Contract;

public class LambdaGenerationUtil {
    @Contract(value="null -> false")
    public static boolean canBeUncheckedLambda(PsiExpression lambdaCandidate) {
        if (lambdaCandidate == null) {
            return false;
        }
        if (!ExceptionUtil.getThrownCheckedExceptions(lambdaCandidate).isEmpty()) {
            return false;
        }
        return PsiTreeUtil.processElements(lambdaCandidate, e -> {
            if (!(e instanceof PsiReferenceExpression)) {
                return true;
            }
            PsiElement element = ((PsiReferenceExpression)e).resolve();
            return !(element instanceof PsiVariable) || HighlightControlFlowUtil.isEffectivelyFinal((PsiVariable)element, lambdaCandidate, null);
        });
    }
}

