/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class MakeInitializerExplicitFix
extends InspectionGadgetsFix {
    @Override
    @NotNull
    public String getFamilyName() {
        String string = InspectionGadgetsBundle.message("make.initialization.explicit.quickfix", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/fixes/MakeInitializerExplicitFix", "getFamilyName"));
        }
        return string;
    }

    @Override
    public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
        PsiElement fieldName = descriptor.getPsiElement();
        PsiElement parent = fieldName.getParent();
        if (!(parent instanceof PsiField)) {
            return;
        }
        PsiField field = (PsiField)parent;
        if (field.getInitializer() != null) {
            return;
        }
        PsiType type = field.getType();
        PsiManager psiManager = PsiManager.getInstance(project);
        PsiElementFactory factory = JavaPsiFacade.getInstance(psiManager.getProject()).getElementFactory();
        PsiExpression initializer = factory.createExpressionFromText(MakeInitializerExplicitFix.getDefaultValue(type), field);
        field.setInitializer(initializer);
    }

    @NonNls
    private static String getDefaultValue(PsiType type) {
        if (PsiType.INT.equals(type)) {
            return "0";
        }
        if (PsiType.LONG.equals(type)) {
            return "0L";
        }
        if (PsiType.DOUBLE.equals(type)) {
            return "0.0";
        }
        if (PsiType.FLOAT.equals(type)) {
            return "0.0F";
        }
        if (PsiType.SHORT.equals(type)) {
            return "(short)0";
        }
        if (PsiType.BYTE.equals(type)) {
            return "(byte)0";
        }
        if (PsiType.BOOLEAN.equals(type)) {
            return "false";
        }
        if (PsiType.CHAR.equals(type)) {
            return "(char)0";
        }
        return "null";
    }
}

