/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class MalformedSetUpTearDownInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("malformed.set.up.tear.down.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/MalformedSetUpTearDownInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("malformed.set.up.tear.down.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/junit/MalformedSetUpTearDownInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new MalformedSetUpTearDownVisitor();
    }

    private static class MalformedSetUpTearDownVisitor
    extends BaseInspectionVisitor {
        private MalformedSetUpTearDownVisitor() {
        }

        @Override
        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/siyeh/ig/junit/MalformedSetUpTearDownInspection$MalformedSetUpTearDownVisitor", "visitMethod"));
            }
            String methodName = method.getName();
            if (!"setUp".equals(methodName) && !"tearDown".equals(methodName)) {
                return;
            }
            PsiClass targetClass = method.getContainingClass();
            if (!InheritanceUtil.isInheritor(targetClass, "junit.framework.TestCase")) {
                return;
            }
            if (method.getParameterList().getParametersCount() != 0 || !PsiType.VOID.equals(method.getReturnType()) || !method.hasModifierProperty("public") && !method.hasModifierProperty("protected")) {
                this.registerMethodError(method, new Object[0]);
            }
        }
    }
}

