/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.ReadOnlyMappedBufferWrapper;
import com.intellij.util.io.ReadWriteDirectBufferWrapper;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.jetbrains.annotations.Nullable;

public abstract class ByteBufferWrapper {
    protected final File myFile;
    protected final long myPosition;
    protected final long myLength;
    protected volatile boolean myDirty;

    protected ByteBufferWrapper(File file, long offset, long length) {
        this.myFile = file;
        this.myPosition = offset;
        this.myLength = length;
    }

    @Nullable
    public abstract ByteBuffer getCachedBuffer();

    public final void markDirty() {
        if (!this.myDirty) {
            this.myDirty = true;
        }
    }

    public final boolean isDirty() {
        return this.myDirty;
    }

    public abstract ByteBuffer getBuffer() throws IOException;

    public abstract void unmap();

    public abstract void flush();

    public void dispose() {
        this.unmap();
    }

    public static ByteBufferWrapper readWrite(File file, int offset, int length) {
        return new ReadWriteDirectBufferWrapper(file, offset, length);
    }

    public static ByteBufferWrapper readWriteDirect(File file, long offset, int length) {
        return new ReadWriteDirectBufferWrapper(file, offset, length);
    }

    public static ByteBufferWrapper readOnly(File file, int offset) {
        return new ReadOnlyMappedBufferWrapper(file, offset);
    }

    public String toString() {
        return "Buffer for " + this.myFile + ", offset:" + this.myPosition + ", size: " + this.myLength;
    }
}

